/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestGeneralConfiguration
extends JIRAWebTest {
    public TestGeneralConfiguration(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testAjaxIssuePicker() {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.assertTableCellHasText("options_table", 12, 1, "ON");
        this.clickLinkWithText("Edit Configuration");
        this.checkCheckbox("ajaxIssuePicker", "false");
        this.submit("Update");
        this.assertTableCellHasText("options_table", 12, 1, "OFF");
    }

    public void testAjaxUserPicker() {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.assertTableCellHasText("options_table", 13, 1, "ON");
        this.clickLinkWithText("Edit Configuration");
        this.checkCheckbox("ajaxUserPicker", "false");
        this.submit("Update");
        this.assertTableCellHasText("options_table", 13, 1, "OFF");
    }

    public void testBaseUrlStripsEndingSlash() {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("baseURL", "http://example.url.com:8090/");
        this.submit("Update");
        this.assertTextPresent("http://example.url.com:8090");
        this.assertTextNotPresent("http://example.url.com:8090/");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("baseURL", "http://example.url.com:8090/jira/");
        this.submit("Update");
        this.assertTextPresent("http://example.url.com:8090/jira");
        this.assertTextNotPresent("http://example.url.com:8090/jira/");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("baseURL", "http://example.url.com:8090");
        this.submit("Update");
        this.assertTextPresent("http://example.url.com:8090");
        this.assertTextNotPresent("http://example.url.com:8090/");
    }

    public void testMimeSnifferOptions() {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.assertTextPresent("Work around Internet Explorer security hole");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("ieMimeSniffer", "secure");
        this.submit("Update");
        this.assertTextPresent("Secure: forced download of attachments for all browsers");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("ieMimeSniffer", "insecure");
        this.submit("Update");
        this.assertTextPresent("Insecure: inline display of attachments");
        this.clickLinkWithText("Edit Configuration");
        this.setFormElement("ieMimeSniffer", "workaround");
        this.submit("Update");
        this.assertTextPresent("Work around Internet Explorer security hole");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/jira/EditApplicationProperties.jspa?title=jWebTest+JIRA+installation&mode=public&captcha=false&baseURL=http%3A%2F%2Flocalhost%3A8080%2Fjira&emailFromHeaderFormat=%24%7Bfullname%7D+%28JIRA%29&introduction=&encoding=UTF-8&language=english&defaultLocale=-1&voting=true&watching=true&allowUnassigned=false&externalUM=false&externalPM=false&logoutConfirm=never&useGzip=false&allowRpc=false&emailVisibility=show&groupVisibility=true&excludePrecedenceHeader=false&ajaxIssuePicker=true&ajaxUserPicker=true&Update=Update"));
        this.assertTextPresent("The MIME sniffing policy option is required.");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/jira/EditApplicationProperties.jspa?title=jWebTest+JIRA+installation&mode=public&captcha=false&baseURL=http%3A%2F%2Flocalhost%3A8080%2Fjira&emailFromHeaderFormat=%24%7Bfullname%7D+%28JIRA%29&introduction=&encoding=UTF-8&language=english&defaultLocale=-1&voting=true&watching=true&allowUnassigned=false&externalUM=false&externalPM=false&logoutConfirm=never&useGzip=false&allowRpc=false&emailVisibility=show&groupVisibility=true&excludePrecedenceHeader=false&ajaxIssuePicker=true&ajaxUserPicker=true&ieMimeSniffer=_WRONGARSE%26copy;&Update=Update"));
        this.assertTextPresent("The given value for MIME sniffing policy is invalid: _WRONGARSE&amp;copy;");
    }

    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("German (Germany)");
        this.navigation.gotoAdminSection("general_configuration");
        int lastRow = this.page.getHtmlTable("language-info").getRowCount() - 1;
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow, 1), "Deutsch (Deutschland)");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow - 1, 1), "Deutsch (Deutschland)");
        this.tester.gotoPage("secure/admin/jira/EditApplicationProperties!default.jspa");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Installierte Sprachen", "Deutsch (Deutschland)", "Standardsprache");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("defaultLocale", "Deutsch (Deutschland)");
    }

    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("German (Germany)");
        this.navigation.login("fred");
        this.navigation.gotoAdminSection("general_configuration");
        int lastRow = this.page.getHtmlTable("language-info").getRowCount() - 1;
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow, 1), "alem\u00e1n (Alemania)");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow - 1, 1), "espa\u00f1ol (Espa\u00f1a)");
        this.tester.gotoPage("secure/admin/jira/EditApplicationProperties!default.jspa");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Lenguajes instalados", "espa\u00f1ol (Espa\u00f1a)", "Lenguaje por defecto");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("defaultLocale", "alem\u00e1n (Alemania)");
    }

    public void testMaxAuthattempts() {
        this.gotoAdmin();
        this.clickLink("general_configuration");
        this.text.assertTextSequence(this.xpath("//table//tr[@id='maximumAuthenticationAttemptsAllowed']"), "Maximum Authentication Attempts Allowed", "3");
        this.clickLinkWithText("Edit Configuration");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", "xzl");
        this.submit("Update");
        this.text.assertTextPresent(this.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "You must specify a number or leave it blank");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", "0");
        this.submit("Update");
        this.text.assertTextPresent(this.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "You cannot set the maximum authentication attempts to zero or less");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", "-1");
        this.submit("Update");
        this.text.assertTextPresent(this.xpath("//form[@name='jiraform']//span[@class='errMsg']"), "You cannot set the maximum authentication attempts to zero or less");
        this.tester.setFormElement("maximumAuthenticationAttemptsAllowed", "10");
        this.submit("Update");
        this.text.assertTextSequence(this.xpath("//table//tr[@id='maximumAuthenticationAttemptsAllowed']"), "Maximum Authentication Attempts Allowed", "10");
    }
}

