/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.cargo;

import com.atlassian.cargotestrunner.testrunner.TestRunner;
import com.atlassian.cargotestrunner.testrunner.TestRunnerConfig;
import com.atlassian.cargotestrunner.webtest.TestSetupCallbackFactory;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.webtests.AcceptanceTestHarness;
import com.atlassian.jira.webtests.cargo.JIRACallbackFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CargoTestHarness
extends TestSuite {
    public static final String URL_PREFIX = "/atlassian-jira";
    public static final String DEFAULT_CONTAINERS_LOCATION = "src/etc/java/containers.properties";
    public static final String DEFAULT_WAR_LOCATION = "../../target/atlassian-jira";
    public static final String CONTAINER_LOCATION_PROPERTY = "jira.functest.containerproperties";
    public static final String WAR_LOCATION_PROPERTY = "jira.functest.warlocation";
    public static final String CONTAINERS_PROPERTY = "cargo.containers";
    public static final String DELETE_TEMP_DIR_PROPERTY = "cargo.container.deleteTempDirectory";
    public static final String JIRA_HOME_PROPERTY = "jira.functest.home";
    public static final String DEFAULT_JIRA_HOME = "target/jirahome/";

    public static Test suite() throws IOException {
        FuncTestOut.out.println("_________________________");
        FuncTestOut.out.println("JIRA CargoTestHarness has started...");
        FuncTestOut.out.println("_________________________");
        CargoTestHarness.printSystemPropertiesInEffect();
        CargoTestHarness.printEnvironmentInEffect();
        Properties containerProperties = CargoTestHarness.getProperties();
        File war = CargoTestHarness.initWarFile();
        return CargoTestHarness.suite(war, containerProperties);
    }

    private static void printSystemPropertiesInEffect() {
        Properties properties = System.getProperties();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object object : properties.keySet()) {
            keys.add((String)object);
        }
        Collections.sort(keys);
        FuncTestOut.out.println("The following (" + keys.size() + ") Java System properties are in effect");
        for (String string : keys) {
            String value = properties.getProperty(string);
            FuncTestOut.out.println("\t" + string + " : " + value);
        }
        FuncTestOut.out.println("_________________________");
    }

    private static void printEnvironmentInEffect() {
        Map<String, String> map = System.getenv();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        FuncTestOut.out.println("The following (" + keys.size() + ") environment variables are in effect");
        for (String key : keys) {
            String value = map.get(key);
            FuncTestOut.out.println("\t" + key + " : " + value);
        }
        FuncTestOut.out.println("_________________________");
    }

    protected static File initWarFile() throws IOException {
        String warLocation = System.getProperty(WAR_LOCATION_PROPERTY, DEFAULT_WAR_LOCATION);
        FuncTestOut.out.println("Using war from '" + warLocation + "'");
        File war = new File(warLocation);
        if (!war.exists()) {
            throw new RuntimeException("Could not find JIRA war at " + war.getCanonicalPath() + ".  Please ensure that the working directory is the functional test dir");
        }
        return war;
    }

    private static Collection<String> parseContainersList(String containersList) {
        StringTokenizer st = new StringTokenizer(containersList, ",", false);
        ArrayList<String> containers = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = StringUtils.trimToNull((String)st.nextToken());
            if (token == null) continue;
            containers.add(token);
        }
        return containers;
    }

    public static Test suite(File warLocation, Properties properties) throws IOException {
        Test test = AcceptanceTestHarness.suite();
        return TestRunner.suite(Collections.singletonList(test), (Properties)properties, (TestSetupCallbackFactory)new JIRACallbackFactory(URL_PREFIX), (File)warLocation, (TestRunnerConfig)new TestRunnerConfig(true, false, false));
    }

    protected static Properties getProperties() throws IOException {
        String containerPropertiesLocation = System.getProperty(CONTAINER_LOCATION_PROPERTY, DEFAULT_CONTAINERS_LOCATION);
        FuncTestOut.out.println("Using container properties from '" + containerPropertiesLocation + "'");
        File containerProperties = new File(containerPropertiesLocation);
        if (!containerProperties.exists()) {
            throw new RuntimeException("Could not find containers.properties at " + containerProperties.getCanonicalPath() + ".  Please ensure that the working directory is the functional test dir");
        }
        return CargoTestHarness.getProperties(containerProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(File containerProperties) throws IOException {
        Properties properties = new Properties();
        FileInputStream inStream = new FileInputStream(containerProperties);
        try {
            properties.load(inStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inStream);
        }
        Collection<String> containerIds = CargoTestHarness.getContainerNames(properties);
        CargoTestHarness.cleanTemp(properties, containerIds);
        CargoTestHarness.addJiraHome(properties, containerIds);
        return properties;
    }

    private static void cleanTemp(Properties properties, Collection<String> containerIds) throws IOException {
        boolean clean = Boolean.parseBoolean(properties.getProperty(DELETE_TEMP_DIR_PROPERTY));
        for (String containerId : containerIds) {
            File containerTempDirectory = new File(System.getProperty("java.io.tmpdir"), containerId);
            if (!containerTempDirectory.exists()) continue;
            if (clean) {
                FuncTestOut.out.println("Deleting temp directory " + containerTempDirectory);
                boolean deleted = FileUtils.deleteQuietly((File)containerTempDirectory);
                FuncTestOut.out.println("Temp Directory deleted: " + deleted);
                continue;
            }
            throw new IllegalStateException("File " + containerTempDirectory.getCanonicalPath() + " exists and property " + DELETE_TEMP_DIR_PROPERTY + " is not set.  Cargo will not be able to run.");
        }
    }

    private static void addJiraHome(Properties properties, Collection<String> containerIds) {
        String home = properties.getProperty(JIRA_HOME_PROPERTY, DEFAULT_JIRA_HOME);
        File homeFile = new File(home).getAbsoluteFile();
        for (String containerId : containerIds) {
            String propertyName = "cargo." + containerId + ".jvmArgs";
            String vmArgs = properties.getProperty(propertyName, "");
            if (vmArgs.indexOf("-Djava.home") >= 0) continue;
            vmArgs = vmArgs + " -Djira.home=\"" + homeFile.getPath() + "\"";
            properties.put(propertyName, vmArgs);
        }
    }

    private static Collection<String> getContainerNames(Properties serverProperties) {
        Collection<String> containerNames;
        String containersList = serverProperties.getProperty(CONTAINERS_PROPERTY);
        if (containersList == null) {
            FuncTestOut.out.println("Empty list of containerNames.  Please set property 'cargo.containers'");
            containerNames = Collections.emptyList();
        } else {
            containerNames = CargoTestHarness.parseContainersList(containersList);
        }
        if (containerNames.isEmpty()) {
            FuncTestOut.out.println("Empty list of containerNames.  Please set property 'cargo.containers'");
        }
        return containerNames;
    }
}

