/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.collect.UnmodifiableIterator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class TransformingCollection<I, E>
extends AbstractCollection<E> {
    private final Collection<? extends I> collection;
    private final Function<I, E> transformer;

    TransformingCollection(@NotNull Collection<? extends I> collection, @NotNull Function<I, E> transformer) {
        this.collection = Assertions.notNull("collection", collection);
        this.transformer = Assertions.notNull("transformer", transformer);
    }

    @Override
    public Iterator<E> iterator() {
        return Transformed.iterator(new UnmodifiableIterator<I>(this.collection.iterator()), this.transformer);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }
}

