/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.FilteredIterator;
import com.atlassian.jira.util.collect.TransformingIterator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    @Deprecated
    public static <T> void apply(Iterator<T> iterator, Consumer<T> sink) {
        CollectionUtil.foreach(iterator, sink);
    }

    @Deprecated
    public static <T> void apply(Iterable<T> iterable, Consumer<T> sink) {
        CollectionUtil.foreach(iterable, sink);
    }

    public static <T> void foreach(Iterator<T> iterator, Consumer<T> sink) {
        while (iterator.hasNext()) {
            sink.consume(iterator.next());
        }
    }

    public static <T> void foreach(Iterable<T> iterable, Consumer<T> sink) {
        if (iterable != null) {
            CollectionUtil.foreach(iterable.iterator(), sink);
        }
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        final ArrayList result = new ArrayList();
        CollectionUtil.foreach(iterator, new Consumer<T>(){

            @Override
            public void consume(T element) {
                result.add(element);
            }
        });
        return result;
    }

    public static <T, R> List<R> transform(Iterator<T> iterator, Function<T, R> transformer) {
        return CollectionUtil.toList(CollectionUtil.transformIterator(iterator, transformer));
    }

    public static <T, R> List<R> transform(Iterable<T> iterable, Function<T, R> transformer) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return CollectionUtil.transform(iterable.iterator(), transformer);
    }

    public static <T, R> Iterator<R> transformIterator(Iterator<T> iterator, Function<T, R> transformer) {
        return new TransformingIterator<T, R>(iterator, transformer);
    }

    public static <T> Iterator<T> filter(Iterator<T> iterator, Predicate<T> predicate) {
        return new FilteredIterator<T>(iterator, predicate);
    }

    public static <T> Iterable<T> filter(Iterable<T> iterable, Predicate<T> predicate) {
        return new FilteredIterable<T>(iterable, predicate);
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> sorted = new ArrayList<T>(collection);
        if (sorted.size() > 1) {
            Collections.sort(sorted, comparator);
        }
        return sorted;
    }

    public static <T> List<T> copyAsImmutableList(Collection<? extends T> copy) {
        Assertions.notNull("copy", copy);
        if (copy.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(copy));
    }

    public static <T> Set<T> copyAsImmutableSet(Collection<? extends T> copy) {
        Assertions.notNull("copy", copy);
        if (copy.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<T>(copy));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilteredIterable<T>
    implements Iterable<T> {
        private final Iterable<T> delegate;
        private final Predicate<T> predicate;

        FilteredIterable(Iterable<T> delegate, Predicate<T> predicate) {
            this.delegate = delegate;
            this.predicate = predicate;
        }

        @Override
        public Iterator<T> iterator() {
            return new FilteredIterator<T>(this.delegate.iterator(), this.predicate);
        }
    }
}

