/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.url;

import com.atlassian.jira.functest.framework.util.url.ParsedURL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class TestParsedURL
extends TestCase {
    public void testBasicParse() {
        ParsedURL url = new ParsedURL("http://localhost:666/path1/path2?p1=v1&p2=v2");
        TestParsedURL.assertEquals((String)"http", (String)url.getProtocol());
        TestParsedURL.assertEquals((String)"localhost", (String)url.getHost());
        TestParsedURL.assertEquals((int)666, (int)url.getPort());
        TestParsedURL.assertEquals((String)"/path1/path2", (String)url.getPath());
        TestParsedURL.assertEquals((String)"/path1/path2?p1=v1&p2=v2", (String)url.getFile());
        TestParsedURL.assertEquals((String)"p1=v1&p2=v2", (String)url.getQuery());
    }

    public void testNoPort() {
        ParsedURL url = new ParsedURL("http://localhost/path1/path2?p1=v1&p2=v2");
        TestParsedURL.assertEquals((String)"http", (String)url.getProtocol());
        TestParsedURL.assertEquals((String)"localhost", (String)url.getHost());
        TestParsedURL.assertEquals((int)-1, (int)url.getPort());
        TestParsedURL.assertEquals((String)"/path1/path2", (String)url.getPath());
        TestParsedURL.assertEquals((String)"/path1/path2?p1=v1&p2=v2", (String)url.getFile());
        TestParsedURL.assertEquals((String)"p1=v1&p2=v2", (String)url.getQuery());
    }

    public void testNoProtocol() {
        ParsedURL url = new ParsedURL("localhost/path1/path2?p1=v1&p2=v2");
        TestParsedURL.assertEquals((String)"http", (String)url.getProtocol());
        TestParsedURL.assertEquals((String)"", (String)url.getHost());
        TestParsedURL.assertEquals((int)-1, (int)url.getPort());
        TestParsedURL.assertEquals((String)"/localhost/path1/path2", (String)url.getPath());
        TestParsedURL.assertEquals((String)"/localhost/path1/path2?p1=v1&p2=v2", (String)url.getFile());
        TestParsedURL.assertEquals((String)"p1=v1&p2=v2", (String)url.getQuery());
    }

    public void testNoParameters() {
        ParsedURL url = new ParsedURL("http://localhost/path1/path2");
        TestParsedURL.assertEquals((String)"http", (String)url.getProtocol());
        TestParsedURL.assertEquals((String)"localhost", (String)url.getHost());
        TestParsedURL.assertEquals((int)-1, (int)url.getPort());
        TestParsedURL.assertEquals((String)"/path1/path2", (String)url.getPath());
        TestParsedURL.assertEquals((String)"/path1/path2", (String)url.getFile());
        TestParsedURL.assertEquals((String)"", (String)url.getQuery());
    }

    public void testMultipleParameters() {
        ParsedURL url = new ParsedURL("http://localhost/path1/path2?p2=v2b&p2=v2a&p1=v1");
        Map<String, List<String>> parameters = url.getMultiQueryParameters();
        TestParsedURL.assertTrue((boolean)parameters.containsKey("p1"));
        TestParsedURL.assertTrue((boolean)parameters.containsKey("p2"));
        TestParsedURL.assertEquals((int)1, (int)parameters.get("p1").size());
        TestParsedURL.assertEquals((int)2, (int)parameters.get("p2").size());
        TestParsedURL.assertTrue((boolean)parameters.get("p2").contains("v2a"));
        TestParsedURL.assertTrue((boolean)parameters.get("p2").contains("v2b"));
        Iterator<String> keyIt = parameters.keySet().iterator();
        TestParsedURL.assertEquals((String)"p1", (String)keyIt.next());
        TestParsedURL.assertEquals((String)"p2", (String)keyIt.next());
    }

    public void testSimpleParameters() {
        ParsedURL url = new ParsedURL("http://localhost/path1/path2?p2=v2b&p2=v2a&p3=v3&p1=v1");
        Map<String, String> parameters = url.getQueryParameters();
        TestParsedURL.assertTrue((boolean)parameters.containsKey("p1"));
        TestParsedURL.assertTrue((boolean)parameters.containsKey("p2"));
        TestParsedURL.assertTrue((boolean)parameters.containsKey("p3"));
        TestParsedURL.assertEquals((String)"v1", (String)parameters.get("p1"));
        TestParsedURL.assertEquals((String)"v2a", (String)parameters.get("p2"));
        TestParsedURL.assertEquals((String)"v3", (String)parameters.get("p3"));
        Iterator<String> keyIt = parameters.keySet().iterator();
        TestParsedURL.assertEquals((String)"p1", (String)keyIt.next());
        TestParsedURL.assertEquals((String)"p2", (String)keyIt.next());
        TestParsedURL.assertEquals((String)"p3", (String)keyIt.next());
    }
}

