/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.locator;

import com.atlassian.jira.functest.framework.locator.AggregateLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.atlassian.jira.functest.unittests.mocks.MockWebServer;
import com.atlassian.jira.functest.unittests.mocks.MockWebTester;
import com.atlassian.jira.functest.unittests.mocks.XmlParserHelper;
import com.meterware.httpunit.WebTable;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestLocator
extends TestCase {
    private static final String HTML_START = "<html><body>";
    private static final String HTML_END = "</body></html>";
    private static final String HTML_TEXT_SIMPLE = "<html><body><span id=\"s1\">some text</span><div>Some text <b> with bold tags</b>   and spaces </div></body></html>";

    public static Test suite() {
        TestSuite testSuite = new TestSuite(TestLocator.class);
        return new TestSetup((Test)testSuite){

            protected void tearDown() throws Exception {
                MockWebServer.getInstance().stop();
            }
        };
    }

    public void testXpathLocator() throws Exception {
        XPathLocator xpathLocator = this.newXPathLocator(HTML_TEXT_SIMPLE, "//span");
        Node[] nodes = xpathLocator.getNodes();
        TestLocator.assertNotNull((Object)nodes);
        TestLocator.assertEquals((int)1, (int)nodes.length);
        TestLocator.assertTrue((boolean)xpathLocator.hasNodes());
        TestLocator.assertEquals((String)"span", (String)((Element)nodes[0]).getTagName());
        String text = xpathLocator.getHTML();
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertEquals((String)"<span id=\"s1\">some text</span>", (String)text);
        text = xpathLocator.getText();
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertEquals((String)"some text", (String)text);
        xpathLocator = this.newXPathLocator(HTML_TEXT_SIMPLE, "//div");
        nodes = xpathLocator.getNodes();
        TestLocator.assertNotNull((Object)nodes);
        TestLocator.assertEquals((int)1, (int)nodes.length);
        TestLocator.assertTrue((boolean)xpathLocator.hasNodes());
        TestLocator.assertEquals((String)"div", (String)((Element)nodes[0]).getTagName());
        text = xpathLocator.getHTML();
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertEquals((String)"<div>Some text <b> with bold tags</b>   and spaces </div>", (String)text);
        text = xpathLocator.getHTML(nodes[0]);
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertEquals((String)"<div>Some text <b> with bold tags</b>   and spaces </div>", (String)text);
        text = xpathLocator.getText();
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertEquals((String)"Some text with bold tags and spaces", (String)text);
        text = xpathLocator.getText(nodes[0]);
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertEquals((String)"Some text with bold tags and spaces", (String)text);
        text = xpathLocator.getRawText();
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertEquals((String)"Some text  with bold tags   and spaces ", (String)text);
        text = xpathLocator.getRawText(nodes[0]);
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertEquals((String)"Some text  with bold tags   and spaces ", (String)text);
    }

    public void testWebPageLocator() throws Exception {
        MockWebServer webServer = MockWebServer.getInstance();
        webServer.addPage("/", HTML_TEXT_SIMPLE);
        MockWebTester webTester = new MockWebTester(webServer);
        WebPageLocator locator = new WebPageLocator(webTester);
        Node[] nodes = locator.getNodes();
        TestLocator.assertNotNull((Object)nodes);
        TestLocator.assertEquals((int)1, (int)nodes.length);
        TestLocator.assertTrue((boolean)locator.hasNodes());
        TestLocator.assertEquals((String)"html", (String)((Element)nodes[0]).getTagName());
        String text = locator.getHTML();
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertTrue((boolean)TextKit.containsTextSequence(text, new String[]{"<span id=\"s1\">some text</span><div>Some text <b> with bold tags</b>   and spaces </div>"}));
        text = locator.getText();
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertEquals((String)text, (String)"some textSome text with bold tags and spaces");
    }

    public void testAggregate() throws Exception {
        XPathLocator xpathLocator1 = this.newXPathLocator(HTML_TEXT_SIMPLE, "//span");
        XPathLocator xpathLocator2 = this.newXPathLocator(HTML_TEXT_SIMPLE, "//div");
        AggregateLocator aggregateLocator = new AggregateLocator(xpathLocator1, xpathLocator2);
        Node[] nodes = aggregateLocator.getNodes();
        TestLocator.assertNotNull((Object)nodes);
        TestLocator.assertNotNull((Object)aggregateLocator.getNode());
        TestLocator.assertEquals((int)2, (int)nodes.length);
        TestLocator.assertTrue((boolean)aggregateLocator.hasNodes());
        String text = aggregateLocator.getText();
        TestLocator.assertNotNull((Object)text);
        TestLocator.assertTrue((text.indexOf("some text") != -1 ? 1 : 0) != 0);
        TestLocator.assertTrue((text.indexOf("bold tags") != -1 ? 1 : 0) != 0);
        Node[] nodes2 = aggregateLocator.getNodes();
        TestLocator.assertNotNull((Object)nodes2);
        TestLocator.assertNotNull((Object)aggregateLocator.getNode());
        TestLocator.assertEquals((int)2, (int)nodes2.length);
        TestLocator.assertTrue((boolean)aggregateLocator.hasNodes());
        TestLocator.assertSame((Object)nodes[0], (Object)nodes2[0]);
        TestLocator.assertSame((Object)nodes[1], (Object)nodes2[1]);
    }

    public void testTableLocator() throws Exception {
        String TABLE_HTML = "<html><body><table id=\"t1\"><tr><td>r0c1</td><td>r0c2</td></tr><tr><td>r1c1</td><td>r1c2</td></tr><tr><td>r2c1</td><td>r2c2</td></tr></table></body></html>";
        MockWebServer webServer = MockWebServer.getInstance();
        webServer.addPage("/table", TABLE_HTML);
        MockWebTester webTester = new MockWebTester(webServer);
        webTester.gotoPage("/table");
        TableLocator tableLocator = new TableLocator(webTester, "t1");
        TestLocator.assertNotNull((Object)tableLocator.getNodes());
        TestLocator.assertEquals((int)1, (int)tableLocator.getNodes().length);
        TestLocator.assertTrue((boolean)tableLocator.hasNodes());
        TestLocator.assertEquals((String)"table", (String)((Element)tableLocator.getNodes()[0]).getTagName());
        String text = tableLocator.getText();
        TestLocator.assertNotNull((Object)text);
        WebTable webTable = tableLocator.getTable();
        TestLocator.assertNotNull((Object)webTable);
        TestLocator.assertEquals((String)"r0c1", (String)webTable.getCellAsText(0, 0));
        TestLocator.assertEquals((String)"r0c2", (String)webTable.getCellAsText(0, 1));
        text = tableLocator.getText();
        TestLocator.assertNotNull((Object)text);
    }

    public void testXpathAttributeSelectSupport() throws Exception {
        String someHTML = "<html><body><div id=\"1 2\t 3 \t\n4\">div1</div><div id=\"456\" lang=\"es\">div2</div></body></html>";
        XPathLocator xpathLocator = this.newXPathLocator(someHTML, "//div/@id");
        TestLocator.assertTrue((boolean)xpathLocator.hasNodes());
        TestLocator.assertEquals((int)2, (int)xpathLocator.getNodes().length);
        xpathLocator = this.newXPathLocator(someHTML, "//div[1]/@id");
        TestLocator.assertTrue((boolean)xpathLocator.hasNodes());
        TestLocator.assertEquals((int)1, (int)xpathLocator.getNodes().length);
        String actualText = xpathLocator.getText();
        TestLocator.assertEquals((String)"1 2  3   4", (String)actualText);
        actualText = xpathLocator.getRawText();
        TestLocator.assertEquals((String)"1 2  3   4", (String)actualText);
        actualText = xpathLocator.getHTML();
        TestLocator.assertEquals((String)"id=\"1 2  3   4\"", (String)actualText);
        xpathLocator = this.newXPathLocator(someHTML, "//div/@lang");
        TestLocator.assertTrue((boolean)xpathLocator.hasNodes());
        TestLocator.assertEquals((int)1, (int)xpathLocator.getNodes().length);
        xpathLocator = this.newXPathLocator(someHTML, "//div/@doesntexist");
        TestLocator.assertFalse((boolean)xpathLocator.hasNodes());
        TestLocator.assertEquals((int)0, (int)xpathLocator.getNodes().length);
    }

    private XPathLocator newXPathLocator(String xmlText, String xpathExpression) {
        return new XPathLocator(this.getDOM(xmlText), xpathExpression);
    }

    private Document getDOM(String xmlText) {
        try {
            return XmlParserHelper.parseXml(xmlText);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

