/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.CheckOptionsFactory;
import com.atlassian.jira.functest.unittests.config.CheckResultBuilder;
import com.atlassian.jira.functest.unittests.config.ConfigMailServer;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigService;
import com.atlassian.jira.functest.unittests.config.ConfigurationCheck;
import com.atlassian.jira.functest.unittests.config.JiraConfig;
import com.atlassian.jira.functest.unittests.config.MailChecker;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;

public class TestMailChecker
extends TestCase {
    private static final String CHECK_MAIL_SERVER = "mailserver";
    private static final String CHECK_MAIL_SERVICE = "mailservice";

    public void testCheckMailServer() throws Exception {
        ArrayList<ConfigMailServer> servers = new ArrayList<ConfigMailServer>();
        servers.add(new ConfigMailServer().setId(10L));
        servers.add(new ConfigMailServer().setId(11L).setServerName("blarg2").setUserName("bbain").setType(ConfigMailServer.Type.SMTP));
        JiraConfig config = new JiraConfig();
        config.setMailServers(servers);
        MailChecker checker = new MailChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        CheckResultBuilder builds = new CheckResultBuilder();
        builds.error("Mail server '10' to '<unknown type>:<unknown server>' for user '<anonymous>' exists.", CHECK_MAIL_SERVER);
        builds.error("Mail server '11' to 'SMTP:blarg2' for user 'bbain' exists.", CHECK_MAIL_SERVER);
        TestMailChecker.assertEquals((Object)builds.buildResult(), (Object)result);
    }

    public void testCheckMailServerCheckDisabled() throws Exception {
        ArrayList<ConfigMailServer> servers = new ArrayList<ConfigMailServer>();
        servers.add(new ConfigMailServer().setId(10L));
        servers.add(new ConfigMailServer().setId(11L).setServerName("blarg2").setUserName("bbain").setType(ConfigMailServer.Type.SMTP));
        JiraConfig config = new JiraConfig();
        config.setMailServers(servers);
        MailChecker checker = new MailChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECK_MAIL_SERVER));
        CheckResultBuilder builds = new CheckResultBuilder();
        TestMailChecker.assertEquals((Object)builds.buildResult(), (Object)result);
    }

    public void testCheckMailServices() throws Exception {
        ArrayList<ConfigService> services = new ArrayList<ConfigService>();
        services.add(new ConfigService(15L, 10L, "ssslsls.PopService", "PopService", new ConfigPropertySet()));
        services.add(new ConfigService(16L, 10L, "ssslsls.Name", "name", new ConfigPropertySet()));
        services.add(new ConfigService(17L, 10L, "ssslsls.ImapService", "ImapService", new ConfigPropertySet()));
        services.add(new ConfigService(18L, 10L, "ssslsls.FileService", "FileService", new ConfigPropertySet()));
        JiraConfig config = new JiraConfig();
        config.setServices(services);
        config.setMailServers(Collections.<ConfigMailServer>emptyList());
        MailChecker checker = new MailChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        CheckResultBuilder builds = new CheckResultBuilder();
        builds.error("Mail service 'PopService' exists.", CHECK_MAIL_SERVICE);
        builds.error("Mail service 'ImapService' exists.", CHECK_MAIL_SERVICE);
        builds.error("Mail service 'FileService' exists.", CHECK_MAIL_SERVICE);
        TestMailChecker.assertEquals((Object)builds.buildResult(), (Object)result);
    }

    public void testCheckMailServicesCheckDisabled() throws Exception {
        ArrayList<ConfigService> services = new ArrayList<ConfigService>();
        services.add(new ConfigService(15L, 10L, "ssslsls.PopService", "PopService", new ConfigPropertySet()));
        services.add(new ConfigService(16L, 10L, "ssslsls.Name", "name", new ConfigPropertySet()));
        services.add(new ConfigService(17L, 10L, "ssslsls.ImapService", "ImapService", new ConfigPropertySet()));
        services.add(new ConfigService(18L, 10L, "ssslsls.FileService", "FileService", new ConfigPropertySet()));
        JiraConfig config = new JiraConfig();
        config.setServices(services);
        config.setMailServers(Collections.<ConfigMailServer>emptyList());
        MailChecker checker = new MailChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECK_MAIL_SERVICE));
        CheckResultBuilder builds = new CheckResultBuilder();
        TestMailChecker.assertEquals((Object)builds.buildResult(), (Object)result);
    }

    public void testFixMailServer() throws Exception {
        ArrayList<ConfigMailServer> servers = new ArrayList<ConfigMailServer>();
        servers.add(new ConfigMailServer().setId(10L));
        servers.add(new ConfigMailServer().setId(11L).setServerName("blarg2").setUserName("bbain").setType(ConfigMailServer.Type.SMTP));
        JiraConfig config = new JiraConfig();
        config.setMailServers(servers);
        MailChecker checker = new MailChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestMailChecker.assertTrue((boolean)config.getMailServers().isEmpty());
    }

    public void testFixMailServerCheckDisabled() throws Exception {
        ArrayList<ConfigMailServer> servers = new ArrayList<ConfigMailServer>();
        servers.add(new ConfigMailServer().setId(10L));
        servers.add(new ConfigMailServer().setId(11L).setServerName("blarg2").setUserName("bbain").setType(ConfigMailServer.Type.SMTP));
        JiraConfig config = new JiraConfig();
        config.setMailServers(new ArrayList<ConfigMailServer>(servers));
        MailChecker checker = new MailChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECK_MAIL_SERVER));
        TestMailChecker.assertEquals(servers, config.getMailServers());
    }

    public void testFixMailServices() throws Exception {
        ArrayList<ConfigService> services = new ArrayList<ConfigService>();
        ConfigService keptService = new ConfigService(16L, 10L, "ssslsls.Name", "name", new ConfigPropertySet());
        services.add(keptService);
        services.add(new ConfigService(15L, 10L, "ssslsls.PopService", "PopService", new ConfigPropertySet()));
        services.add(new ConfigService(17L, 10L, "ssslsls.ImapService", "ImapService", new ConfigPropertySet()));
        services.add(new ConfigService(18L, 10L, "ssslsls.FileService", "FileService", new ConfigPropertySet()));
        JiraConfig config = new JiraConfig();
        config.setServices(services);
        config.setMailServers(Collections.<ConfigMailServer>emptyList());
        MailChecker checker = new MailChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestMailChecker.assertEquals(Collections.singletonList(keptService), config.getServices());
    }

    public void testFixMailServicesCheckDisabled() throws Exception {
        ArrayList<ConfigService> services = new ArrayList<ConfigService>();
        services.add(new ConfigService(15L, 10L, "ssslsls.PopService", "PopService", new ConfigPropertySet()));
        services.add(new ConfigService(16L, 10L, "ssslsls.Name", "name", new ConfigPropertySet()));
        services.add(new ConfigService(17L, 10L, "ssslsls.ImapService", "ImapService", new ConfigPropertySet()));
        services.add(new ConfigService(18L, 10L, "ssslsls.FileService", "FileService", new ConfigPropertySet()));
        JiraConfig config = new JiraConfig();
        config.setServices(new ArrayList<ConfigService>(services));
        config.setMailServers(Collections.<ConfigMailServer>emptyList());
        MailChecker checker = new MailChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECK_MAIL_SERVICE));
        TestMailChecker.assertEquals(services, config.getServices());
    }
}

