/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigMailServer;
import com.atlassian.jira.functest.unittests.config.ConfigMailServerManager;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySetManager;
import com.atlassian.jira.functest.unittests.config.ConfigSequence;
import com.atlassian.jira.functest.unittests.config.ConfigService;
import com.atlassian.jira.functest.unittests.config.ConfigServiceManager;
import com.atlassian.jira.functest.unittests.config.JiraConfig;
import java.io.File;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;

public class TestJiraConfig
extends TestCase {
    private static final String ROOT_ELEMENT = "entity-engine-xml";
    private ConfigMailServerManager mailServerManager;
    private ConfigPropertySetManager propertySetManager;
    private ConfigServiceManager serviceManager;
    private ConfigSequence configSequence;
    private IMocksControl control;
    private static final String PROP_NAME = "jira.properties";
    private static final long PROP_ID = 1L;

    protected void setUp() throws Exception {
        super.setUp();
        this.control = EasyMock.createControl();
        this.mailServerManager = (ConfigMailServerManager)this.control.createMock(ConfigMailServerManager.class);
        this.propertySetManager = (ConfigPropertySetManager)this.control.createMock(ConfigPropertySetManager.class);
        this.serviceManager = (ConfigServiceManager)this.control.createMock(ConfigServiceManager.class);
        this.configSequence = (ConfigSequence)this.control.createMock(ConfigSequence.class);
    }

    protected void tearDown() throws Exception {
        this.mailServerManager = null;
        this.propertySetManager = null;
        this.serviceManager = null;
        this.configSequence = null;
        this.control = null;
    }

    public void testIsJiraConfig() throws Exception {
        TestJiraConfig.assertFalse((boolean)JiraConfig.isJiraXml(null));
        TestJiraConfig.assertFalse((boolean)JiraConfig.isJiraXml(TestJiraConfig.createEmptyDocument("shshshshjs")));
        TestJiraConfig.assertTrue((boolean)JiraConfig.isJiraXml(TestJiraConfig.createJiraConfig()));
        Document notSoEmptyDocument = TestJiraConfig.createJiraConfig();
        notSoEmptyDocument.addComment("comment");
        notSoEmptyDocument.getRootElement().addAttribute("rna", "value");
        notSoEmptyDocument.getRootElement().addElement("rna").setText("valye");
        TestJiraConfig.assertTrue((boolean)JiraConfig.isJiraXml(notSoEmptyDocument));
    }

    public void testEmptyCotr() throws Exception {
        JiraConfig config = new JiraConfig();
        Document document = config.getDocument();
        Element root = document.getRootElement();
        TestJiraConfig.assertEquals((String)ROOT_ELEMENT, (String)root.getName());
        TestJiraConfig.assertTrue((boolean)root.elements().isEmpty());
        TestJiraConfig.assertTrue((boolean)root.attributes().isEmpty());
    }

    public void testCotrDocumentFile() throws Exception {
        File file = new File("/tmp/test.txt");
        Document doc = TestJiraConfig.createJiraConfig();
        JiraConfig config = new JiraConfig(doc, file);
        TestJiraConfig.assertSame((Object)file, (Object)config.getFile());
        TestJiraConfig.assertSame((Object)doc, (Object)config.getDocument());
        Document notSoEmptyDocument = TestJiraConfig.createJiraConfig();
        notSoEmptyDocument.addComment("comment");
        notSoEmptyDocument.getRootElement().addAttribute("rna", "value");
        notSoEmptyDocument.getRootElement().addElement("rna").setText("valye");
        TestJiraConfig.assertTrue((boolean)JiraConfig.isJiraXml(notSoEmptyDocument));
        config = new JiraConfig(notSoEmptyDocument, null);
        TestJiraConfig.assertNull((Object)config.getFile());
        TestJiraConfig.assertSame((Object)notSoEmptyDocument, (Object)config.getDocument());
        try {
            new JiraConfig(null, file);
            TestJiraConfig.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new JiraConfig(TestJiraConfig.createEmptyDocument("djsdjaksda"), file);
            TestJiraConfig.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testSetApplicationProperties() throws Exception {
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        this.control.replay();
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setTextProperty("this", "mine");
        config.setApplicationProperties(configPropertySet);
        TestJiraConfig.assertEquals((Object)configPropertySet, (Object)config.getApplicationProperties());
        this.control.verify();
    }

    public void testGetApplicationProperties() throws Exception {
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        ConfigPropertySet set = new ConfigPropertySet();
        set.setLongProperty("value", 1L);
        EasyMock.expect((Object)this.propertySetManager.loadPropertySet(PROP_NAME, 1L)).andReturn((Object)set);
        this.control.replay();
        TestJiraConfig.assertEquals((Object)set, (Object)config.getApplicationProperties());
        this.control.verify();
    }

    public void testSetServices() throws Exception {
        ConfigService service = new ConfigService().setId(10L).setName("test");
        List<ConfigService> services = Collections.singletonList(service);
        this.control.replay();
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        config.setServices(services);
        TestJiraConfig.assertEquals(services, config.getServices());
        this.control.verify();
    }

    public void testGetServices() throws Exception {
        ConfigService service = new ConfigService().setId(10L).setName("test");
        List<ConfigService> services = Collections.singletonList(service);
        EasyMock.expect(this.serviceManager.loadServices()).andReturn(services).andReturn(null);
        this.control.replay();
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        TestJiraConfig.assertEquals(services, config.getServices());
        config.setServices(null);
        TestJiraConfig.assertEquals(Collections.emptyList(), config.getServices());
        this.control.verify();
    }

    public void testSetMail() throws Exception {
        ConfigMailServer server = new ConfigMailServer().setId(10L).setName("test");
        List<ConfigMailServer> servers = Collections.singletonList(server);
        this.control.replay();
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        config.setMailServers(servers);
        TestJiraConfig.assertEquals(servers, config.getMailServers());
        this.control.verify();
    }

    public void testGetMail() throws Exception {
        ConfigMailServer server = new ConfigMailServer().setId(10L).setName("test");
        List<ConfigMailServer> servers = Collections.singletonList(server);
        EasyMock.expect(this.mailServerManager.loadServers()).andReturn(servers).andReturn(null);
        this.control.replay();
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        TestJiraConfig.assertEquals(servers, config.getMailServers());
        config.setMailServers(null);
        TestJiraConfig.assertEquals(Collections.emptyList(), config.getMailServers());
        this.control.verify();
    }

    public void testSaveNoData() throws Exception {
        EasyMock.expect((Object)this.configSequence.save()).andReturn((Object)false);
        this.control.replay();
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        TestJiraConfig.assertFalse((boolean)config.save());
        this.control.verify();
    }

    public void testSaveWithApplicationPropertyChanges() throws Exception {
        ConfigPropertySet propertySet = new ConfigPropertySet("test", 10101L);
        EasyMock.expect((Object)this.propertySetManager.savePropertySet(propertySet.copyForEntity(PROP_NAME, 1L))).andReturn((Object)true);
        EasyMock.expect((Object)this.configSequence.save()).andReturn((Object)false);
        this.control.replay();
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        config.setApplicationProperties(propertySet);
        TestJiraConfig.assertTrue((boolean)config.save());
        this.control.verify();
    }

    public void testSaveWithServiceChanges() throws Exception {
        ConfigService srv = new ConfigService().setId(17272L).setName("blarg");
        List<ConfigService> srvs = Collections.singletonList(srv);
        EasyMock.expect((Object)this.serviceManager.saveServices(srvs)).andReturn((Object)true);
        EasyMock.expect((Object)this.configSequence.save()).andReturn((Object)false);
        this.control.replay();
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        config.setServices(srvs);
        TestJiraConfig.assertTrue((boolean)config.save());
        this.control.verify();
    }

    public void testSaveWithMailChanges() throws Exception {
        ConfigMailServer mailsrv = new ConfigMailServer().setId(17272L).setName("blarg");
        List<ConfigMailServer> mailsrvs = Collections.singletonList(mailsrv);
        EasyMock.expect((Object)this.mailServerManager.saveServers(mailsrvs)).andReturn((Object)true);
        EasyMock.expect((Object)this.configSequence.save()).andReturn((Object)false);
        this.control.replay();
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        config.setMailServers(mailsrvs);
        TestJiraConfig.assertTrue((boolean)config.save());
        this.control.verify();
    }

    public void testSaveWithNoChanges() throws Exception {
        this.checkSave(false, false, false, false);
        this.checkSave(false, false, false, true);
        this.checkSave(false, false, true, false);
        this.checkSave(false, false, true, true);
        this.checkSave(false, true, false, false);
        this.checkSave(false, true, false, true);
        this.checkSave(false, true, true, false);
        this.checkSave(false, true, true, true);
        this.checkSave(true, false, false, false);
        this.checkSave(true, false, false, true);
        this.checkSave(true, false, true, false);
        this.checkSave(true, false, true, true);
        this.checkSave(true, true, false, false);
        this.checkSave(true, true, false, true);
        this.checkSave(true, true, true, false);
        this.checkSave(true, true, true, true);
    }

    private void checkSave(boolean propertySetReturn, boolean mailServerReturn, boolean serviceReturn, boolean seqeunceReturn) {
        this.control.reset();
        List<ConfigMailServer> mailsrvs = Collections.singletonList(new ConfigMailServer().setId(17272L).setName("blarg"));
        List<ConfigService> srvs = Collections.singletonList(new ConfigService().setId(17272L).setName("blarg"));
        ConfigPropertySet ap = new ConfigPropertySet("aaa", 10101L);
        ap.setStringProperty("dkasla", "1111");
        EasyMock.expect((Object)this.propertySetManager.savePropertySet(ap.copyForEntity(PROP_NAME, 1L))).andReturn((Object)propertySetReturn);
        EasyMock.expect((Object)this.mailServerManager.saveServers(mailsrvs)).andReturn((Object)mailServerReturn);
        EasyMock.expect((Object)this.serviceManager.saveServices(srvs)).andReturn((Object)serviceReturn);
        EasyMock.expect((Object)this.configSequence.save()).andReturn((Object)seqeunceReturn);
        this.control.replay();
        JiraConfig config = new JiraConfig(TestJiraConfig.createJiraConfig(), new File("m"), this.configSequence, this.mailServerManager, this.propertySetManager, this.serviceManager);
        config.setMailServers(mailsrvs);
        config.setServices(srvs);
        config.setApplicationProperties(ap);
        TestJiraConfig.assertEquals((propertySetReturn || mailServerReturn || serviceReturn || seqeunceReturn ? 1 : 0) != 0, (boolean)config.save());
        this.control.verify();
    }

    private static Document createJiraConfig() {
        return TestJiraConfig.createEmptyDocument(ROOT_ELEMENT);
    }

    private static Document createEmptyDocument(String rootElement) {
        DocumentFactory instance = DocumentFactory.getInstance();
        Document rootDoc = instance.createDocument();
        rootDoc.setRootElement(instance.createElement(rootElement));
        return rootDoc;
    }
}

