/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.CheckOptionsFactory;
import com.atlassian.jira.functest.unittests.config.CheckResultBuilder;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigurationCheck;
import com.atlassian.jira.functest.unittests.config.IndexDirectoryChecker;
import com.atlassian.jira.functest.unittests.config.JiraConfig;
import com.atlassian.jira.functest.unittests.config.TestXmlUtils;
import junit.framework.TestCase;

public class TestIndexDirectoryChecker
extends TestCase {
    private static final String CHECKID_INDEX_HOME = "indexhome";
    private static final String CHECKID_INDEX_ENABLED = "indexenabled";
    private static final String CHECKID_INDEX_DIRECTORY = "indexdirectory";
    private static final String PROP_INDEX_OPTION = "jira.option.indexing";
    private static final String PROP_INDEX_PATH = "jira.path.index";
    private static final String PROP_INDEX_DEFAULT_DIR = "jira.path.index.use.default.directory";
    private static final String FUNC_TEST_INDEX = "func_test_index";

    public void testInvalidProperties() throws Exception {
        JiraConfig config = new JiraConfig(TestXmlUtils.createInvalidDocument(), null);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        TestIndexDirectoryChecker.assertEquals((int)1, (int)result.getErrors().size());
        TestIndexDirectoryChecker.assertTrue((boolean)result.getWarnings().isEmpty());
        TestIndexDirectoryChecker.assertTrue((boolean)result.getErrors().iterator().next().getMessage().matches(".*Unable to read entry:.*"));
    }

    public void testCheckGoodConfiguration() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckIndexingDisabled() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, false);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        builder.warning("File does not have indexing enabled.", CHECKID_INDEX_ENABLED);
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckIndexingNotSet() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        builder.warning("File does not have indexing enabled.", CHECKID_INDEX_ENABLED);
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckIndexingDisabledCheckDisabled() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, false);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_INDEX_ENABLED));
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckIndexingUsingHome() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, false);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        builder.error("File has 'func_test_index' configured as its index path. It should be using its JIRA.HOME.", CHECKID_INDEX_HOME);
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckIndexingUsingHomeNotSet() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        builder.error("File has 'func_test_index' configured as its index path. It should be using its JIRA.HOME.", CHECKID_INDEX_HOME);
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckIndexingUsingHomeCheckDisabled() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, false);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_INDEX_HOME));
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckIndexingDir() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, "radomdir");
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_INDEX_HOME));
        builder.warning("File has 'radomdir' configured as its index path. It should be using 'func_test_index' even with JIRA.HOME configured.", CHECKID_INDEX_DIRECTORY);
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckIndexingDirCheckDisabled() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, "radomdir");
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_INDEX_DIRECTORY));
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckIndexingNoDir() throws Exception {
        CheckResultBuilder builder = new CheckResultBuilder();
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        TestIndexDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testFixGood() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
    }

    public void testFixIndexingDisabled() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, false);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        ap = config.getApplicationProperties();
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
    }

    public void testFixIndexingNotSet() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, false);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        ap = config.getApplicationProperties();
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
    }

    public void testFixIndexingCheckDisabled() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, false);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_INDEX_ENABLED));
        TestIndexDirectoryChecker.assertFalse((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
        ap.removeProperty(PROP_INDEX_OPTION);
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_INDEX_ENABLED));
        TestIndexDirectoryChecker.assertNull((Object)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
    }

    public void testFixHomeDir() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, false);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        ap = config.getApplicationProperties();
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
        ap.removeProperty(PROP_INDEX_DEFAULT_DIR);
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
    }

    public void testFixHomeDirCheckDisabled() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, false);
        ap.setStringProperty(PROP_INDEX_PATH, FUNC_TEST_INDEX);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_INDEX_HOME));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertFalse((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
        ap.removeProperty(PROP_INDEX_DEFAULT_DIR);
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_INDEX_HOME));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertNull((Object)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
    }

    public void testFixDefaultDir() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, true);
        ap.setStringProperty(PROP_INDEX_PATH, "random");
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        ap = config.getApplicationProperties();
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)FUNC_TEST_INDEX, (String)ap.getStringProperty(PROP_INDEX_PATH));
        ap.removeProperty(PROP_INDEX_PATH);
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertNull((Object)ap.getStringProperty(PROP_INDEX_PATH));
    }

    public void testFixDefaultDirCheckDisabled() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setBooleanProperty(PROP_INDEX_OPTION, true);
        ap.setBooleanProperty(PROP_INDEX_DEFAULT_DIR, false);
        ap.setStringProperty(PROP_INDEX_PATH, "random");
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(ap);
        ap = config.getApplicationProperties();
        IndexDirectoryChecker checker = new IndexDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_INDEX_DIRECTORY));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_OPTION));
        TestIndexDirectoryChecker.assertTrue((boolean)ap.getBooleanProperty(PROP_INDEX_DEFAULT_DIR));
        TestIndexDirectoryChecker.assertEquals((String)"random", (String)ap.getStringProperty(PROP_INDEX_PATH));
    }
}

