/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigException;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySetEntry;
import com.atlassian.jira.functest.unittests.config.ConfigXmlUtils;
import com.atlassian.jira.functest.unittests.config.DefaultConfigPropertySetManager;
import com.atlassian.jira.functest.unittests.config.DefaultConfigSequence;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class TestDefaultConfigPropertySetManager
extends TestCase {
    private static final String ATTRIB_PROPERTY_KEY = "propertyKey";
    private static final String ATTRIB_ID = "id";
    private static final String ATTRIB_VALUE = "value";
    private static final String ATTRIB_TYPE = "type";
    private static final String ATTRIB_ENTITY_NAME = "entityName";
    private static final String ATTRIB_ENTITY_ID = "entityId";
    private static final String ATTRIB_SEQ_NAME = "seqName";
    private static final String ATTRIB_SEQ_ID = "seqId";
    private static final String ELEMENT_OSPROPERTY_ENTRY = "OSPropertyEntry";
    private static final String ELEMENT_OS_PROPERTY_ENTRY = "OSPropertyEntry";
    private static final String ELEMENT_OS_PROPERTY_NUMBER = "OSPropertyNumber";
    private static final String ELEMENT_OS_PROPERTY_TEXT = "OSPropertyText";
    private static final String ELEMENT_SEQ_VALUE_ITEM = "SequenceValueItem";
    private static final String ELEMENT_OS_PROPERTY_STRING = "OSPropertyString";
    private static final String ENTITY_ROOT = "entity-engine-xml";
    private long globalId = 10000L;

    public void testLoadPropertySet() throws Exception {
        String entityName = "Test";
        long entityId = 1L;
        String stringValue = "String";
        String textValue = "Text";
        String intKey = "intKey";
        String longKey = "longKey";
        String booleanKey = "booleanKey";
        Element root = this.createRoot();
        this.addStringEntry(root, "Test", 1L, "String", "String");
        this.addTextEntry(root, "Test", 1L, "Text", "Text");
        this.addInteger(root, "Test", 1L, "intKey", 1);
        this.addLong(root, "Test", 1L, "longKey", 12L);
        this.addBoolean(root, "Test", 1L, "booleanKey", true);
        this.addInteger(root, "Test", 2L, "intKey", Integer.MAX_VALUE);
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        ConfigPropertySet propertySet = mgr.loadPropertySet("Test", 1L);
        HashMap<String, ConfigPropertySetEntry> expectedEntries = new HashMap<String, ConfigPropertySetEntry>();
        expectedEntries.put("String", ConfigPropertySetEntry.createStringEntry("String", "String"));
        expectedEntries.put("Text", ConfigPropertySetEntry.createTextEntry("Text", "Text"));
        expectedEntries.put("intKey", ConfigPropertySetEntry.createIntegerEntry("intKey", 1));
        expectedEntries.put("longKey", ConfigPropertySetEntry.createLongEntry("longKey", 12L));
        expectedEntries.put("booleanKey", ConfigPropertySetEntry.createBooleanEntry("booleanKey", true));
        TestDefaultConfigPropertySetManager.assertEquals(expectedEntries, propertySet.entryMap());
        propertySet = mgr.loadPropertySet("Test", 2L);
        expectedEntries = new HashMap();
        expectedEntries.put("intKey", ConfigPropertySetEntry.createIntegerEntry("intKey", Integer.MAX_VALUE));
        TestDefaultConfigPropertySetManager.assertEquals(expectedEntries, propertySet.entryMap());
    }

    public void testLoadPropertySetBrokenXml() throws Exception {
        String entityName = "Test";
        long entityId = 1L;
        String stringValue = "String";
        Element root = this.createRoot();
        this.addStringEntry(root, "Test", 1L, "", "String");
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        root = this.createRoot();
        this.addPropertyEntry(root, this.createId(), "Test", 1L, 78, "blarg");
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
    }

    public void testLoadPropertyBadString() throws Exception {
        String entityName = "Test";
        long entityId = 1L;
        String stringValue = "String";
        Element root = this.createRoot();
        this.addStringEntry(root, "Test", 1L, "String", null);
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        root = this.createRoot();
        this.addPropertyEntry(root, this.createId(), "Test", 1L, ConfigPropertySetEntry.Type.STRING.getPropertySetType(), "String");
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
    }

    public void testLoadPropertyBadText() throws Exception {
        String entityName = "Test";
        long entityId = 1L;
        String stringValue = "String";
        Element root = this.createRoot();
        this.addTextEntry(root, "Test", 1L, "String", null);
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        root = this.createRoot();
        this.addPropertyEntry(root, this.createId(), "Test", 1L, ConfigPropertySetEntry.Type.TEXT.getPropertySetType(), "String");
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
    }

    public void testLoadPropertyBadLong() throws Exception {
        String entityName = "Test";
        long entityId = 1L;
        String longKey = "longKey";
        Element root = this.createRoot();
        this.addLong(root, "Test", 1L, "longKey", null);
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        root = this.createRoot();
        this.addStringNumber(root, "Test", 1L, "longKey", "something", ConfigPropertySetEntry.Type.LONG.getPropertySetType());
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        root = this.createRoot();
        this.addPropertyEntry(root, this.createId(), "Test", 1L, ConfigPropertySetEntry.Type.LONG.getPropertySetType(), "longKey");
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
    }

    public void testLoadPropertyBadInteger() throws Exception {
        String entityName = "Test";
        long entityId = 1L;
        String intKey = "intKey";
        Element root = this.createRoot();
        this.addInteger(root, "Test", 1L, "intKey", null);
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        root = this.createRoot();
        this.addStringNumber(root, "Test", 1L, "intKey", "something", ConfigPropertySetEntry.Type.INTEGER.getPropertySetType());
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        root = this.createRoot();
        this.addPropertyEntry(root, this.createId(), "Test", 1L, ConfigPropertySetEntry.Type.INTEGER.getPropertySetType(), "intKey");
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
    }

    public void testLoadPropertyBadBoolean() throws Exception {
        String entityName = "Test";
        long entityId = 1L;
        String boolKey = "boolKey";
        Element root = this.createRoot();
        this.addBoolean(root, "Test", 1L, "boolKey", null);
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        root = this.createRoot();
        this.addStringNumber(root, "Test", 1L, "boolKey", "something", ConfigPropertySetEntry.Type.BOOLEAN.getPropertySetType());
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        root = this.createRoot();
        this.addPropertyEntry(root, this.createId(), "Test", 1L, ConfigPropertySetEntry.Type.BOOLEAN.getPropertySetType(), "boolKey");
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        try {
            mgr.loadPropertySet("Test", 1L);
            TestDefaultConfigPropertySetManager.fail((String)"Should not load property set with bad data.");
        }
        catch (ConfigException e) {
            // empty catch block
        }
    }

    public void testDeletePropertySet() {
        String entityName = "Test";
        long entityId = 1L;
        String stringValue = "String";
        String textValue = "Text";
        String intKey = "intKey";
        String longKey = "longKey";
        String booleanKey = "booleanKey";
        Element root = this.createRoot();
        this.addStringEntry(root, "Test", 1L, "String", "String");
        this.addTextEntry(root, "Test", 1L, "Text", "Text");
        this.addInteger(root, "Test", 1L, "intKey", 28);
        this.addLong(root, "Test", 1L, "longKey", 12L);
        this.addBoolean(root, "Test", 1L, "booleanKey", true);
        long otherIntId = this.addInteger(root, "Test", 2L, "intKey", Integer.MAX_VALUE);
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        mgr.deletePropertySet("Test", 1L);
        Document doc = root.getDocument();
        this.assertNoValue(doc, "Test", 1L, "String", "String");
        this.assertNoValue(doc, "Test", 1L, "Text", "Text");
        this.assertNoValue(doc, "Test", 1L, "intKey", "28");
        this.assertNoValue(doc, "Test", 1L, "longKey", "12");
        this.assertNoValue(doc, "Test", 1L, "booleanKey", "1");
        this.assertInteger(doc, otherIntId, "Test", 2L, "intKey", Integer.MAX_VALUE);
    }

    public void testUpdatePropertySet() throws Exception {
        String entityName = "Test";
        long entityId = 1L;
        String stringValue = "String";
        String textValue = "Text";
        String intKey = "intKey";
        String longKey = "longKey";
        String booleanKey = "booleanKey";
        Element root = this.createRoot();
        this.addSequence(root);
        long stringId = this.addStringEntry(root, "Test", 1L, "String", "String");
        long textId = this.addTextEntry(root, "Test", 1L, "Text", "Text");
        long intId = this.addInteger(root, "Test", 1L, "intKey", 1);
        long longId = this.addLong(root, "Test", 1L, "longKey", 12L);
        long booleanId = this.addBoolean(root, "Test", 1L, "booleanKey", true);
        long otherIntId = this.addInteger(root, "Test", 2L, "intKey", Integer.MAX_VALUE);
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), new DefaultConfigSequence(root.getDocument()));
        ConfigPropertySet configPropertySet = mgr.loadPropertySet("Test", 1L);
        configPropertySet.setStringProperty("String", "String");
        configPropertySet.setTextProperty("Text", "Text");
        configPropertySet.setLongProperty("longKey", 12L);
        configPropertySet.setIntegerProperty("intKey", 1);
        configPropertySet.setBooleanProperty("booleanKey", true);
        TestDefaultConfigPropertySetManager.assertFalse((boolean)mgr.savePropertySet(configPropertySet));
        configPropertySet.setStringProperty("String", "newStringValue");
        configPropertySet.setTextProperty("Text", "newTextValue");
        configPropertySet.setIntegerProperty("intKey", 5);
        configPropertySet.setLongProperty("longKey", 19399L);
        configPropertySet.setBooleanProperty("booleanKey", false);
        TestDefaultConfigPropertySetManager.assertTrue((boolean)mgr.savePropertySet(configPropertySet));
        Document doc = root.getDocument();
        this.assertString(doc, stringId, "Test", 1L, "String", "newStringValue");
        this.assertText(doc, textId, "Test", 1L, "Text", "newTextValue");
        this.assertInteger(doc, intId, "Test", 1L, "intKey", 5);
        this.assertLong(doc, longId, "Test", 1L, "longKey", 19399L);
        this.assertBoolean(doc, booleanId, "Test", 1L, "booleanKey", false);
        this.assertInteger(doc, otherIntId, "Test", 2L, "intKey", Integer.MAX_VALUE);
        configPropertySet.setIntegerProperty("String", 10);
        configPropertySet.setLongProperty("Text", 101L);
        configPropertySet.setStringProperty("longKey", "long");
        configPropertySet.setBooleanProperty("intKey", false);
        configPropertySet.setTextProperty("booleanKey", "something in the way she moves");
        TestDefaultConfigPropertySetManager.assertTrue((boolean)mgr.savePropertySet(configPropertySet));
        this.assertInteger(doc, stringId, "Test", 1L, "String", 10);
        TestDefaultConfigPropertySetManager.assertNull((Object)this.getStringEntry(doc, stringId));
        this.assertLong(doc, textId, "Test", 1L, "Text", 101L);
        TestDefaultConfigPropertySetManager.assertNull((Object)this.getTextEntry(doc, textId));
        this.assertString(doc, longId, "Test", 1L, "longKey", "long");
        TestDefaultConfigPropertySetManager.assertNull((Object)this.getNumberEntry(doc, longId));
        this.assertBoolean(doc, intId, "Test", 1L, "intKey", false);
        this.assertText(doc, booleanId, "Test", 1L, "booleanKey", "something in the way she moves");
        TestDefaultConfigPropertySetManager.assertNull((Object)this.getNumberEntry(doc, booleanId));
        this.assertInteger(doc, otherIntId, "Test", 2L, "intKey", Integer.MAX_VALUE);
        String newString = "newString";
        String newText = "newText";
        String newIntKey = "newInt";
        String newLongKey = "newLong";
        String newBoolKey = "newBool";
        configPropertySet.setStringProperty("newString", "newString");
        configPropertySet.setTextProperty("newText", "newText");
        configPropertySet.setIntegerProperty("newInt", 1002);
        configPropertySet.setLongProperty("newLong", 10029222L);
        configPropertySet.setBooleanProperty("newBool", false);
        TestDefaultConfigPropertySetManager.assertTrue((boolean)mgr.savePropertySet(configPropertySet));
        this.assertInteger(doc, stringId, "Test", 1L, "String", 10);
        this.assertLong(doc, textId, "Test", 1L, "Text", 101L);
        this.assertString(doc, longId, "Test", 1L, "longKey", "long");
        this.assertBoolean(doc, intId, "Test", 1L, "intKey", false);
        this.assertText(doc, booleanId, "Test", 1L, "booleanKey", "something in the way she moves");
        this.assertString(doc, null, "Test", 1L, "newString", "newString");
        this.assertText(doc, null, "Test", 1L, "newText", "newText");
        this.assertInteger(doc, null, "Test", 1L, "newInt", 1002);
        this.assertLong(doc, null, "Test", 1L, "newLong", 10029222L);
        this.assertBoolean(doc, null, "Test", 1L, "newBool", false);
        this.assertInteger(doc, otherIntId, "Test", 2L, "intKey", Integer.MAX_VALUE);
        TestDefaultConfigPropertySetManager.assertFalse((boolean)mgr.savePropertySet(configPropertySet));
        configPropertySet.removeProperty("newString");
        configPropertySet.removeProperty("newText");
        configPropertySet.removeProperty("newInt");
        configPropertySet.removeProperty("newLong");
        configPropertySet.removeProperty("newBool");
        TestDefaultConfigPropertySetManager.assertTrue((boolean)mgr.savePropertySet(configPropertySet));
        this.assertInteger(doc, stringId, "Test", 1L, "String", 10);
        this.assertLong(doc, textId, "Test", 1L, "Text", 101L);
        this.assertString(doc, longId, "Test", 1L, "longKey", "long");
        this.assertBoolean(doc, intId, "Test", 1L, "intKey", false);
        this.assertText(doc, booleanId, "Test", 1L, "booleanKey", "something in the way she moves");
        this.assertNoValue(doc, "Test", 1L, "newString", "newString");
        this.assertNoValue(doc, "Test", 1L, "newText", "newText");
        this.assertNoValue(doc, "Test", 1L, "newInt", "1002");
        this.assertNoValue(doc, "Test", 1L, "newLong", "10029222");
        this.assertNoPropertyEntry(doc, "Test", 1L, "newBool");
        TestDefaultConfigPropertySetManager.assertFalse((boolean)mgr.savePropertySet(configPropertySet));
    }

    public void testRoundTripping() throws Exception {
        ConfigPropertySet expectedPs = new ConfigPropertySet("jira.properties", 1L);
        String booleanKey = "boolean";
        String longKey = "long";
        String stringKey = "string";
        String textKey = "text";
        String intKey = "int";
        expectedPs.setBooleanProperty("boolean", true);
        expectedPs.setStringProperty("string", "string");
        expectedPs.setTextProperty("text", "text");
        expectedPs.setIntegerProperty("int", Integer.MAX_VALUE);
        expectedPs.setLongProperty("long", Long.MAX_VALUE);
        Element root = this.createRoot();
        this.assertRoundtip(expectedPs, root);
        expectedPs.setStringProperty("boolean", "ahghdsja");
        expectedPs.setIntegerProperty("string", 13243);
        expectedPs.setLongProperty("text", 34398201L);
        expectedPs.setBooleanProperty("int", false);
        expectedPs.setTextProperty("long", "moves me like no other");
        this.assertRoundtip(expectedPs, root);
        expectedPs.setStringProperty("booleannew", "ahghdsja");
        expectedPs.setIntegerProperty("stringnew", 13243);
        expectedPs.setLongProperty("textnew", 34398201L);
        expectedPs.setBooleanProperty("intnew", false);
        expectedPs.setTextProperty("longnew", "moves me like no other");
        this.assertRoundtip(expectedPs, root);
        expectedPs.removeProperty("boolean");
        expectedPs.removeProperty("string");
        expectedPs.removeProperty("text");
        expectedPs.removeProperty("int");
        expectedPs.removeProperty("long");
        this.assertRoundtip(expectedPs, root);
    }

    private void assertRoundtip(ConfigPropertySet expected, Element root) {
        DefaultConfigSequence sequence = new DefaultConfigSequence(root.getDocument());
        DefaultConfigPropertySetManager mgr = new DefaultConfigPropertySetManager(root.getDocument(), sequence);
        mgr.savePropertySet(expected);
        sequence.save();
        mgr = new DefaultConfigPropertySetManager(root.getDocument(), sequence);
        ConfigPropertySet actualPs = mgr.loadPropertySet(expected.getEntityName(), expected.getEntityId());
        TestDefaultConfigPropertySetManager.assertEquals((Object)expected, (Object)actualPs);
    }

    private Element createRoot() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        return document.addElement(ENTITY_ROOT);
    }

    private void addSequence(Element root) {
        Element element = ConfigXmlUtils.createNewElement(root, ELEMENT_SEQ_VALUE_ITEM);
        ConfigXmlUtils.setAttribute(element, ATTRIB_SEQ_NAME, "OSPropertyEntry");
        ConfigXmlUtils.setAttribute(element, ATTRIB_SEQ_ID, "50000");
    }

    private long addBoolean(Element root, String entity, Long id, String key, Boolean boolValue) {
        String val = boolValue == null ? null : (boolValue != false ? "1" : "0");
        return this.addStringNumber(root, entity, id, key, val, ConfigPropertySetEntry.Type.BOOLEAN.getPropertySetType());
    }

    private long addLong(Element root, String entity, Long id, String key, Long longValue) {
        String value = longValue != null ? longValue.toString() : null;
        return this.addStringNumber(root, entity, id, key, value, ConfigPropertySetEntry.Type.LONG.getPropertySetType());
    }

    private long addInteger(Element root, String entity, Long id, String key, Integer intValue) {
        String value = intValue != null ? intValue.toString() : null;
        return this.addStringNumber(root, entity, id, key, value, ConfigPropertySetEntry.Type.INTEGER.getPropertySetType());
    }

    private long addStringNumber(Element root, String entity, Long id, String key, String value, int type) {
        long returnId = this.createId();
        this.addPropertyEntry(root, returnId, entity, id, type, key);
        Element element = ConfigXmlUtils.createNewElement(root, ELEMENT_OS_PROPERTY_NUMBER);
        ConfigXmlUtils.setAttribute(element, ATTRIB_ID, String.valueOf(returnId));
        ConfigXmlUtils.setAttribute(element, ATTRIB_VALUE, value);
        return returnId;
    }

    private long addStringEntry(Element root, String entity, Long id, String key, String value) {
        long returnId = this.createId();
        this.addPropertyEntry(root, returnId, entity, id, ConfigPropertySetEntry.Type.STRING.getPropertySetType(), key);
        Element element = ConfigXmlUtils.createNewElement(root, ELEMENT_OS_PROPERTY_STRING);
        ConfigXmlUtils.setAttribute(element, ATTRIB_ID, String.valueOf(returnId));
        ConfigXmlUtils.setAttribute(element, ATTRIB_VALUE, value);
        return returnId;
    }

    private long addTextEntry(Element root, String entity, Long id, String key, String value) {
        long returnId = this.createId();
        this.addPropertyEntry(root, returnId, entity, id, ConfigPropertySetEntry.Type.TEXT.getPropertySetType(), key);
        Element element = ConfigXmlUtils.createNewElement(root, ELEMENT_OS_PROPERTY_TEXT);
        ConfigXmlUtils.setAttribute(element, ATTRIB_ID, String.valueOf(returnId));
        ConfigXmlUtils.setAttribute(element, ATTRIB_VALUE, value);
        return returnId;
    }

    private Element addPropertyEntry(Element document, Long id, String entityType, Long entityId, Integer type, String key) {
        Element element = ConfigXmlUtils.createNewElement(document, "OSPropertyEntry");
        if (id != null) {
            ConfigXmlUtils.setAttribute(element, ATTRIB_ID, String.valueOf(id));
        }
        if (entityType != null) {
            ConfigXmlUtils.setAttribute(element, ATTRIB_ENTITY_NAME, entityType);
        }
        if (entityId != null) {
            ConfigXmlUtils.setAttribute(element, ATTRIB_ENTITY_ID, entityId.toString());
        }
        if (type != null) {
            ConfigXmlUtils.setAttribute(element, ATTRIB_TYPE, type.toString());
        }
        if (key != null) {
            ConfigXmlUtils.setAttribute(element, ATTRIB_PROPERTY_KEY, key);
        }
        return element;
    }

    private void assertBoolean(Document document, Long id, String entityName, Long entityId, String key, Boolean value) {
        Long actualId = this.assertPropertyEntry(document, id, entityName, entityId, key, ConfigPropertySetEntry.Type.BOOLEAN.getPropertySetType());
        Element stringValue = this.getNumberEntry(document, actualId);
        TestDefaultConfigPropertySetManager.assertNotNull((Object)stringValue);
        Integer integerValue = ConfigXmlUtils.getIntegerValue(stringValue, ATTRIB_VALUE);
        TestDefaultConfigPropertySetManager.assertEquals((boolean)value, (integerValue != 0 ? 1 : 0) != 0);
    }

    private void assertString(Document document, Long id, String entityName, Long entityId, String key, String value) {
        Long actualId = this.assertPropertyEntry(document, id, entityName, entityId, key, ConfigPropertySetEntry.Type.STRING.getPropertySetType());
        Element stringValue = this.getStringEntry(document, actualId);
        TestDefaultConfigPropertySetManager.assertNotNull((Object)stringValue);
        TestDefaultConfigPropertySetManager.assertEquals((String)value, (String)ConfigXmlUtils.getTextValue(stringValue, ATTRIB_VALUE));
    }

    private void assertText(Document document, Long id, String entityName, Long entityId, String key, String value) {
        Long actualId = this.assertPropertyEntry(document, id, entityName, entityId, key, ConfigPropertySetEntry.Type.TEXT.getPropertySetType());
        Element stringValue = this.getTextEntry(document, actualId);
        TestDefaultConfigPropertySetManager.assertNotNull((Object)stringValue);
        TestDefaultConfigPropertySetManager.assertEquals((String)value, (String)ConfigXmlUtils.getTextValue(stringValue, ATTRIB_VALUE));
    }

    private void assertLong(Document document, Long id, String entityName, Long entityId, String key, Long value) {
        Long actualId = this.assertPropertyEntry(document, id, entityName, entityId, key, ConfigPropertySetEntry.Type.LONG.getPropertySetType());
        Element longEntry = this.getNumberEntry(document, actualId);
        TestDefaultConfigPropertySetManager.assertNotNull((Object)longEntry);
        TestDefaultConfigPropertySetManager.assertEquals((Object)value, (Object)ConfigXmlUtils.getLongValue(longEntry, ATTRIB_VALUE));
    }

    private void assertInteger(Document document, Long id, String entityName, Long entityId, String key, Integer value) {
        Long actualId = this.assertPropertyEntry(document, id, entityName, entityId, key, ConfigPropertySetEntry.Type.INTEGER.getPropertySetType());
        Element intEntry = this.getNumberEntry(document, actualId);
        TestDefaultConfigPropertySetManager.assertNotNull((Object)intEntry);
        TestDefaultConfigPropertySetManager.assertEquals((Object)value, (Object)ConfigXmlUtils.getIntegerValue(intEntry, ATTRIB_VALUE));
    }

    private Long assertPropertyEntry(Document document, Long id, String entityName, Long entityId, String key, int type) {
        Element entry = id != null ? this.getPropertyEntry(document, id) : this.getPropertyEntry(document, entityName, entityId, key);
        TestDefaultConfigPropertySetManager.assertNotNull((Object)entry);
        TestDefaultConfigPropertySetManager.assertEquals((String)entityName, (String)ConfigXmlUtils.getTextValue(entry, ATTRIB_ENTITY_NAME));
        TestDefaultConfigPropertySetManager.assertEquals((Object)entityId, (Object)ConfigXmlUtils.getLongValue(entry, ATTRIB_ENTITY_ID));
        TestDefaultConfigPropertySetManager.assertEquals((String)key, (String)ConfigXmlUtils.getTextValue(entry, ATTRIB_PROPERTY_KEY));
        TestDefaultConfigPropertySetManager.assertEquals((int)type, (int)ConfigXmlUtils.getIntegerValue(entry, ATTRIB_TYPE));
        return ConfigXmlUtils.getLongValue(entry, ATTRIB_ID);
    }

    private void assertNoValue(Document document, String entityName, Long entityId, String key, String value) {
        String[] tables;
        this.assertNoPropertyEntry(document, entityName, entityId, key);
        for (String table : tables = new String[]{ELEMENT_OS_PROPERTY_TEXT, ELEMENT_OS_PROPERTY_NUMBER, ELEMENT_OS_PROPERTY_STRING}) {
            String xPath = String.format("/entity-engine-xml/%s[@value='%s']", table, value);
            List list = document.selectNodes(xPath);
            TestDefaultConfigPropertySetManager.assertTrue((String)("Element '" + table + "' has element with value '" + value + "'."), (boolean)list.isEmpty());
        }
    }

    private void assertNoPropertyEntry(Document document, String entityName, Long entityId, String key) {
        TestDefaultConfigPropertySetManager.assertNull((Object)this.getPropertyEntry(document, entityName, entityId, key));
    }

    private Element getStringEntry(Document document, Long id) {
        String xPath = String.format("/entity-engine-xml/OSPropertyString[@id='%d']", id);
        return (Element)document.selectSingleNode(xPath);
    }

    private Element getNumberEntry(Document document, Long id) {
        String xPath = String.format("/entity-engine-xml/OSPropertyNumber[@id='%d']", id);
        return (Element)document.selectSingleNode(xPath);
    }

    private Element getTextEntry(Document document, Long id) {
        String xPath = String.format("/entity-engine-xml/OSPropertyText[@id='%d']", id);
        return (Element)document.selectSingleNode(xPath);
    }

    private Element getPropertyEntry(Document document, Long id) {
        String xPath = String.format("/entity-engine-xml/OSPropertyEntry[@id='%d']", id);
        return (Element)document.selectSingleNode(xPath);
    }

    private Element getPropertyEntry(Document document, String entityType, Long entityId, String key) {
        String xPath = String.format("/entity-engine-xml/OSPropertyEntry[@entityName='%s' and @entityId='%d' and @propertyKey='%s']", entityType, entityId, key);
        return (Element)document.selectSingleNode(xPath);
    }

    private long createId() {
        return this.globalId++;
    }
}

