/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigException;
import com.atlassian.jira.functest.unittests.config.ConfigMailServer;
import com.atlassian.jira.functest.unittests.config.ConfigXmlUtils;
import com.atlassian.jira.functest.unittests.config.DefaultConfigMailServerManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultConfigMailServerManager
extends TestCase {
    private static final String ELEMENT_SERVER = "MailServer";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_FROM = "from";
    private static final String ATTRIBUTE_PREFIX = "prefix";
    private static final String ATTRIBUTE_SMTP_PORT = "smtpPort";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_SERVERNAME = "servername";
    private static final String ATTRIBUTE_JNDILOCATION = "jndilocation";
    private static final String ATTRIBUTE_USERNAME = "username";
    private static final String ATTRIBUTE_PASSWORD = "password";
    private ConfigMailServer server1;
    private ConfigMailServer server2;

    protected void setUp() throws Exception {
        super.setUp();
        this.server1 = new ConfigMailServer().setId(10L).setName(ATTRIBUTE_NAME).setDescription("desc").setFrom("jack@jill.com").setPrefix("PREFIX").setPort(10).setType(ConfigMailServer.Type.SMTP).setServerName("localhost").setJndiLocation("location").setUserName("bbain").setPassword(ATTRIBUTE_PASSWORD);
        this.server2 = new ConfigMailServer().setFrom("a@jill.com").setId(101L);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.server2 = null;
        this.server1 = null;
    }

    public void testMailServersRead() throws Exception {
        Element rootElement = this.createStandardRoot();
        DefaultConfigMailServerManager mgr = new DefaultConfigMailServerManager(rootElement.getDocument());
        List<ConfigMailServer> actualList = mgr.loadServers();
        this.assertEqualsCollections(Arrays.asList(this.server1, this.server2), actualList);
    }

    public void testMailServersReadNoId() throws Exception {
        Element rootElement1 = TestDefaultConfigMailServerManager.createRootElement();
        TestDefaultConfigMailServerManager.addServerToRoot(this.server1, rootElement1);
        TestDefaultConfigMailServerManager.addServerToRoot(this.server2.setId(null), rootElement1);
        DefaultConfigMailServerManager mgr = new DefaultConfigMailServerManager(rootElement1.getDocument());
        try {
            mgr.loadServers();
            TestDefaultConfigMailServerManager.fail((String)"Exception should have been thrown.");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public void testDeleteMailServer() throws Exception {
        Element element = this.createStandardRoot();
        List<ConfigMailServer> expectedList = Collections.singletonList(this.server1);
        DefaultConfigMailServerManager mgr = new DefaultConfigMailServerManager(element.getDocument());
        mgr.saveServers(expectedList);
        this.assertDocumentContent(element.getDocument(), expectedList);
        expectedList = Collections.emptyList();
        mgr.saveServers(expectedList);
        this.assertDocumentContent(element.getDocument(), expectedList);
    }

    public void testAddMailServer() throws Exception {
        List<ConfigMailServer> expectedList = Collections.singletonList(this.server2);
        Element element = TestDefaultConfigMailServerManager.createRootElement();
        TestDefaultConfigMailServerManager.addServerToRoot(this.server1, element);
        DefaultConfigMailServerManager mgr = new DefaultConfigMailServerManager(element.getDocument());
        try {
            mgr.saveServers(expectedList);
            TestDefaultConfigMailServerManager.fail((String)"Don't support adding new servers.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    public void testEditMailServer() throws Exception {
        Element element = TestDefaultConfigMailServerManager.createRootElement();
        TestDefaultConfigMailServerManager.addServerToRoot(this.server1, element);
        DefaultConfigMailServerManager mgr = new DefaultConfigMailServerManager(element.getDocument());
        List<ConfigMailServer> expectedList = Collections.singletonList(this.server1.setPassword("anotherPassword"));
        try {
            mgr.saveServers(expectedList);
            TestDefaultConfigMailServerManager.fail((String)"Don't support editing servers.");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    private void assertDocumentContent(Document actualDocument, List<ConfigMailServer> expectedList) {
        this.assertEqualsCollections(expectedList, TestDefaultConfigMailServerManager.getMailServersElement(actualDocument));
    }

    private static Collection<ConfigMailServer> getMailServersElement(Document actualDocument) {
        ArrayList<ConfigMailServer> servers = new ArrayList<ConfigMailServer>();
        List elements = actualDocument.getRootElement().elements(ELEMENT_SERVER);
        for (Element mailElem : elements) {
            servers.add(TestDefaultConfigMailServerManager.elementToServer(mailElem));
        }
        return servers;
    }

    private static ConfigMailServer elementToServer(Element mailElem) {
        ConfigMailServer server = new ConfigMailServer();
        server.setId(ConfigXmlUtils.getLongValue(mailElem, ATTRIBUTE_ID));
        server.setName(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_NAME));
        server.setDescription(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_DESCRIPTION));
        server.setFrom(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_FROM));
        server.setPrefix(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_PREFIX));
        server.setPort(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_SMTP_PORT));
        server.setType(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_TYPE));
        server.setServerName(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_SERVERNAME));
        server.setJndiLocation(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_JNDILOCATION));
        server.setUserName(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_USERNAME));
        server.setPassword(ConfigXmlUtils.getTextValue(mailElem, ATTRIBUTE_PASSWORD));
        return server;
    }

    private Element createStandardRoot() {
        Element rootElement = TestDefaultConfigMailServerManager.createRootElement();
        TestDefaultConfigMailServerManager.addServerToRoot(this.server1, rootElement);
        TestDefaultConfigMailServerManager.addServerToRoot(this.server2, rootElement);
        return rootElement;
    }

    private static Element addServerToRoot(ConfigMailServer server, Element root) {
        Element newMailElement = ConfigXmlUtils.createNewElement(root, ELEMENT_SERVER);
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_ID, TestDefaultConfigMailServerManager.asString(server.getId()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_NAME, TestDefaultConfigMailServerManager.asString(server.getName()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_DESCRIPTION, TestDefaultConfigMailServerManager.asString(server.getDescription()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_FROM, TestDefaultConfigMailServerManager.asString(server.getFrom()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_PREFIX, TestDefaultConfigMailServerManager.asString(server.getPrefix()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_SMTP_PORT, TestDefaultConfigMailServerManager.asString(server.getPort()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_TYPE, TestDefaultConfigMailServerManager.asString((Object)server.getType()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_SERVERNAME, TestDefaultConfigMailServerManager.asString(server.getServerName()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_JNDILOCATION, TestDefaultConfigMailServerManager.asString(server.getJndiLocation()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_USERNAME, TestDefaultConfigMailServerManager.asString(server.getUserName()));
        ConfigXmlUtils.setAttribute(newMailElement, ATTRIBUTE_PASSWORD, TestDefaultConfigMailServerManager.asString(server.getPassword()));
        return newMailElement;
    }

    private static String asString(Object object) {
        return object == null ? null : object.toString();
    }

    private static Element createRootElement() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        return document.addElement("entity-engine-xml");
    }

    private void assertEqualsCollections(Collection<?> one, Collection<?> two) {
        TestDefaultConfigMailServerManager.assertEquals((String)String.format("size(%s) != size(%s)", one, two), (int)one.size(), (int)two.size());
        TestDefaultConfigMailServerManager.assertTrue((String)String.format("%s != %s", one, two), (boolean)one.containsAll(two));
    }
}

