/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.CheckMessage;
import com.atlassian.jira.functest.unittests.config.CheckOptions;
import com.atlassian.jira.functest.unittests.config.CheckResultBuilder;
import com.atlassian.jira.functest.unittests.config.ConfigurationCheck;
import com.atlassian.jira.functest.unittests.config.ConfigurationChecker;
import com.atlassian.jira.functest.unittests.config.ConfigurationDefaults;
import com.atlassian.jira.functest.unittests.config.JiraConfig;
import com.atlassian.jira.functest.unittests.config.ZipHelper;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.atlassian.jira.webtests.util.TempDirectoryUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.NameFileFilter;

public class TestConfigurationChecker
extends TestCase
implements EnvironmentAware {
    private File root;

    protected void tearDown() throws Exception {
        this.root = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCheckerBadBackup() throws IOException {
        File directory = TempDirectoryUtil.createTempDirectory("testCheckBadBackup").getCanonicalFile();
        try {
            ZipHelper.extractTo(this.getFile("fixerBroken.zip"), directory);
            ArrayList<File> badFiles = new ArrayList<File>();
            TestResult expectedResult = new TestResult();
            File currentFile = new File(directory, "BackupWithBackupService.xml");
            badFiles.add(currentFile);
            expectedResult.addError(currentFile, "Backup service 'Backup Service' exists.", "backupservice");
            expectedResult.addWarning(currentFile, "Global backup path set to 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\backups'.", "backupglobaldirectory");
            expectedResult.addWarning(currentFile, "File has 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\attachments' configured as it attachment path. It should always be set to 'func_test_attachments' even when using JIRA.HOME.", "attachdirectory");
            currentFile = new File(directory, "BackupWithBackupServiceCheckDisabled.xml");
            badFiles.add(currentFile);
            expectedResult.addError(currentFile, "Backup service configured to output to directory 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\backups' it should be using JIRA.HOME.", "backupservicehome");
            expectedResult.addWarning(currentFile, "Global backup path set to 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\backups'.", "backupglobaldirectory");
            expectedResult.addWarning(currentFile, "File has 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\attachments' configured as it attachment path. It should always be set to 'func_test_attachments' even when using JIRA.HOME.", "attachdirectory");
            expectedResult.addWarning(currentFile, "Backup service configured to output to 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\backups'. It should always be set to 'func_test_backup' even when using JIRA.HOME.", "backupservicedirectory");
            currentFile = new File(directory, "BackupWithIndexDirSpecifiedCheckDisabled.xml");
            badFiles.add(currentFile);
            expectedResult.addError(currentFile, "Backup service 'Backup Service' exists.", "backupservice");
            currentFile = new File(directory, "BackupWithAttachmentDirSpecified.zip");
            badFiles.add(currentFile);
            expectedResult.addError(currentFile, "File has '/private/tmp/jira_autotest/attachments' configured as its attachment path. It should be using its JIRA.HOME.", "attachhome");
            expectedResult.addError(currentFile, "Backup service 'Backup Service' exists.", "backupservice");
            expectedResult.addWarning(currentFile, "Global backup path set to 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\backups'.", "backupglobaldirectory");
            expectedResult.addWarning(currentFile, "File has '/Users/mtokar/tmp/jira/branch/3_13/indexes' configured as its index path. It should be using 'func_test_index' even with JIRA.HOME configured.", "indexdirectory");
            expectedResult.addWarning(currentFile, "File has '/private/tmp/jira_autotest/attachments' configured as it attachment path. It should always be set to 'func_test_attachments' even when using JIRA.HOME.", "attachdirectory");
            File subDir = new File(directory, "sub");
            currentFile = new File(subDir, "BackupWithAttachmentDirSpecifiedCheckDisabled.xml");
            badFiles.add(currentFile);
            expectedResult.addError(currentFile, "Backup service 'Backup Service' exists.", "backupservice");
            expectedResult.addWarning(currentFile, "File has '/Users/mtokar/tmp/jira/branch/3_13/indexes' configured as its index path. It should be using 'func_test_index' even with JIRA.HOME configured.", "indexdirectory");
            expectedResult.addWarning(currentFile, "File has '/private/tmp/jira_autotest/attachments' configured as it attachment path. It should always be set to 'func_test_attachments' even when using JIRA.HOME.", "attachdirectory");
            expectedResult.addWarning(currentFile, "Global backup path set to 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\backups'.", "backupglobaldirectory");
            currentFile = new File(subDir, "BackupWithIndexDirSpecified.xml");
            badFiles.add(currentFile);
            expectedResult.addError(currentFile, "File has '/tmp/jira_autotest/indexes' configured as its index path. It should be using its JIRA.HOME.", "indexhome");
            expectedResult.addError(currentFile, "Backup service 'Backup Service' exists.", "backupservice");
            expectedResult.addWarning(currentFile, "File has '/tmp/jira_autotest/indexes' configured as its index path. It should be using 'func_test_index' even with JIRA.HOME configured.", "indexdirectory");
            expectedResult.addWarning(currentFile, "File has 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\attachments' configured as it attachment path. It should always be set to 'func_test_attachments' even when using JIRA.HOME.", "attachdirectory");
            expectedResult.addWarning(currentFile, "Global backup path set to 'C:\\DOCUME~1\\mchai\\LOCALS~1\\Temp\\\\jira_autotest\\backups'.", "backupglobaldirectory");
            currentFile = new File(subDir, "BackupWithMailServerAndService.xml");
            badFiles.add(currentFile);
            expectedResult.addError(currentFile, "Mail server 'fake server' to 'POP:fake.example' for user 'meh' exists.", "mailserver");
            expectedResult.addError(currentFile, "Mail service 'Pop Service' exists.", "mailservice");
            expectedResult.addWarning(currentFile, "File has '/private/tmp/jira_autotest/indexes' configured as its index path. It should be using 'func_test_index' even with JIRA.HOME configured.", "indexdirectory");
            expectedResult.addWarning(currentFile, "File has 'C:\\temp\\files' configured as it attachment path. It should always be set to 'func_test_attachments' even when using JIRA.HOME.", "attachdirectory");
            currentFile = new File(directory, "empty.xml");
            expectedResult.addErrorRegex(currentFile, "Unable to read configuration.*");
            currentFile = new File(directory, "other.xml");
            expectedResult.addWarning(currentFile, "File does not appear to contain JIRA XML.", null);
            ArrayList<ConfigurationCheck> checks = new ArrayList<ConfigurationCheck>(ConfigurationDefaults.createDefaultConfigurationChecks());
            RecordingConfigurationCheck recCheck = new RecordingConfigurationCheck();
            checks.add(recCheck);
            File goodFile = new File(directory, "BackupGood.xml");
            File checkDisabledFile = new File(directory, "BackupWithMailServerAndServiceCheckDisabled.xml");
            List<File> goodFiles = Arrays.asList(goodFile, checkDisabledFile);
            ConfigurationChecker checker = new ConfigurationChecker(directory, checks);
            expectedResult.assertEquals(checker.check());
            TestConfigurationChecker.assertTrue((boolean)recCheck.getFiles().containsAll(goodFiles));
            TestConfigurationChecker.assertTrue((boolean)recCheck.getFiles().containsAll(badFiles));
            currentFile = new File(directory, "check-cache.xml");
            TestConfigurationChecker.assertTrue((boolean)currentFile.exists());
            TestResult cacheResult = new TestResult(expectedResult);
            cacheResult.addWarning(currentFile, "File does not appear to contain JIRA XML.", null);
            recCheck.clear();
            cacheResult.assertEquals(checker.check());
            TestConfigurationChecker.assertTrue((boolean)Collections.disjoint(recCheck.getFiles(), goodFiles));
            TestConfigurationChecker.assertTrue((boolean)recCheck.getFiles().containsAll(badFiles));
            checker.setExcludes(Collections.singletonList(new NameFileFilter("check-cache.xml")));
            recCheck.clear();
            expectedResult.assertEquals(checker.check());
            TestConfigurationChecker.assertTrue((boolean)Collections.disjoint(recCheck.getFiles(), goodFiles));
            TestConfigurationChecker.assertTrue((boolean)recCheck.getFiles().containsAll(badFiles));
            checks.add(new NoopConfigurationCheck());
            checker.setConfigurationChecks(checks);
            recCheck.clear();
            expectedResult.assertEquals(checker.check());
            TestConfigurationChecker.assertTrue((boolean)recCheck.getFiles().containsAll(goodFiles));
            TestConfigurationChecker.assertTrue((boolean)recCheck.getFiles().containsAll(badFiles));
            this.appendToFile(goodFile, "<!-- Comment by Test -->");
            recCheck.clear();
            expectedResult.assertEquals(checker.check());
            TestConfigurationChecker.assertTrue((boolean)recCheck.getFiles().contains(goodFile));
            TestConfigurationChecker.assertFalse((boolean)recCheck.getFiles().contains(checkDisabledFile));
            TestConfigurationChecker.assertTrue((boolean)recCheck.getFiles().containsAll(badFiles));
        }
        finally {
            FileUtils.deleteQuietly((File)directory);
        }
    }

    public void setEnvironmentData(JIRAEnvironmentData environmentData) {
        this.setRoot(this.root);
    }

    private void setRoot(File root) {
        if (root != null) {
            this.root = root = this.normalizeFile(root);
        }
    }

    private File getRoot() {
        if (this.root == null) {
            File root = new LocalTestEnvironmentData().getXMLDataLocation();
            if (root == null) {
                throw new RuntimeException("Unable to find XML location. Make sure your environment is setup.");
            }
            this.root = this.normalizeFile(root);
        }
        return this.root;
    }

    private File normalizeFile(File root) {
        try {
            root = root.getCanonicalFile();
        }
        catch (IOException e) {
            root = root.getAbsoluteFile();
        }
        return root;
    }

    private File getFile(String child) {
        return new File(this.getRoot(), child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToFile(File file, String data) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, true);
        try {
            fos.write(data.getBytes("UTF-8"));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private static class NoopConfigurationCheck
    implements ConfigurationCheck {
        private NoopConfigurationCheck() {
        }

        public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
            return new CheckResultBuilder().buildResult();
        }

        public void fixConfiguration(JiraConfig config, CheckOptions options) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecordingConfigurationCheck
    implements ConfigurationCheck {
        private final List<File> files = new ArrayList<File>();

        private RecordingConfigurationCheck() {
        }

        @Override
        public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
            this.files.add(config.getFile());
            return new CheckResultBuilder().buildResult();
        }

        @Override
        public void fixConfiguration(JiraConfig config, CheckOptions options) {
            throw new UnsupportedOperationException();
        }

        private List<File> getFiles() {
            return this.files;
        }

        private void clear() {
            this.files.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestResult {
        private final MultiMap<File, Predicate<CheckMessage>, List<Predicate<CheckMessage>>> errors = TestResult.createMultiMap();
        private final MultiMap<File, Predicate<CheckMessage>, List<Predicate<CheckMessage>>> warnings = TestResult.createMultiMap();

        private TestResult() {
        }

        private TestResult(TestResult result) {
            this.errors.putAll(result.errors);
            this.warnings.putAll(result.warnings);
        }

        private void addWarning(File file, String message, String checkId) {
            this.addWarning(file, new CheckMessage(message, checkId));
        }

        private void addWarning(File file, CheckMessage message) {
            this.addMessage(this.warnings, file, message);
        }

        private void addError(File file, String message, String checkId) {
            this.addError(file, new CheckMessage(message, checkId));
        }

        private void addError(File file, CheckMessage message) {
            this.addMessage(this.errors, file, message);
        }

        private void addErrorRegex(File file, final String regex) {
            this.errors.put(file, new Predicate<CheckMessage>(){

                @Override
                public boolean evaluate(CheckMessage input) {
                    return input.toString().matches(regex);
                }

                public String toString() {
                    return "Match regex: " + regex;
                }
            });
        }

        private void addMessage(MultiMap<File, Predicate<CheckMessage>, List<Predicate<CheckMessage>>> maps, File file, final CheckMessage message) {
            maps.put(file, new Predicate<CheckMessage>(){

                @Override
                public boolean evaluate(CheckMessage input) {
                    return message.equals(input);
                }

                public String toString() {
                    return "Match message: " + message;
                }
            });
        }

        private void assertEquals(ConfigurationChecker.CheckResult result) {
            this.assertMaps("ERRORs", this.errors, result.getErrors());
            this.assertMaps("WARNs", this.warnings, result.getWarnings());
        }

        private void assertMaps(String type, Map<File, List<Predicate<CheckMessage>>> expected, Map<File, List<CheckMessage>> actual) {
            Set<File> expectedKeys = expected.keySet();
            Set<File> actualKeys = actual.keySet();
            if (!((Object)actualKeys).equals(expectedKeys)) {
                HashSet<File> extras = new HashSet<File>(actualKeys);
                extras.removeAll(expectedKeys);
                HashSet<File> missing = new HashSet<File>(expectedKeys);
                missing.removeAll(actualKeys);
                Assert.fail((String)String.format("Files for '%s' are not the same. Extras = %s, Missing = %s.", type, extras, missing));
            }
            for (Map.Entry<File, List<CheckMessage>> entry : actual.entrySet()) {
                List<CheckMessage> actualList = entry.getValue();
                ArrayList predicateList = new ArrayList(expected.get(entry.getKey()));
                for (CheckMessage message : actualList) {
                    boolean found = false;
                    Iterator iterator = predicateList.iterator();
                    while (iterator.hasNext()) {
                        Predicate predicate = (Predicate)iterator.next();
                        if (!predicate.evaluate(message)) continue;
                        found = true;
                        iterator.remove();
                    }
                    if (found) continue;
                    Assert.fail((String)String.format("Could not find match. Type = %s, File = '%s', Message = '%s.%n", type, entry.getKey(), message.toString()));
                }
                if (predicateList.isEmpty()) continue;
                Assert.fail((String)String.format("Expecting message to match '%s'. Type = %s, File = '%s'", predicateList, type, entry.getKey()));
            }
        }

        private static MultiMap<File, Predicate<CheckMessage>, List<Predicate<CheckMessage>>> createMultiMap() {
            return MultiMaps.create(new LinkedHashMap(), new Supplier<List<Predicate<CheckMessage>>>(){

                @Override
                public List<Predicate<CheckMessage>> get() {
                    return new ArrayList<Predicate<CheckMessage>>();
                }
            });
        }
    }
}

