/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigFile;
import com.atlassian.jira.webtests.util.TempDirectoryUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.util.NodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestConfigFile
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadBackupLocation() throws Exception {
        File badDirectory = null;
        File badFile = null;
        try {
            badDirectory = TempDirectoryUtil.createTempDirectory("badBackup");
            badDirectory.deleteOnExit();
            badFile = File.createTempFile("testBadBackup", "xml");
            badFile.deleteOnExit();
            try {
                ConfigFile.create(new File("iWouldBeReallyUnluckyIfThisFileExisted"));
                TestConfigFile.fail((String)"A file that does not exist should not work.");
            }
            catch (ConfigFile.ConfigFileException expected) {
                // empty catch block
            }
            try {
                ConfigFile.create(badDirectory);
                TestConfigFile.fail((String)"A directory should not work.");
            }
            catch (ConfigFile.ConfigFileException expected) {
                // empty catch block
            }
            try {
                ConfigFile.create(badFile);
                TestConfigFile.fail((String)"Read only file should not work.");
            }
            catch (ConfigFile.ConfigFileException configFileException) {
                // empty catch block
            }
            this.deleteSafely(badFile);
            this.deleteSafely(badDirectory);
        }
        catch (Throwable throwable) {
            this.deleteSafely(badFile);
            this.deleteSafely(badDirectory);
            throw throwable;
        }
    }

    public void testXmlReadFileGood() throws Exception {
        this.withTempFile("testXmlFile1", ".xml", new Callback<File>(){

            @Override
            public void call(File argument) throws Exception {
                TestConfigFile.this.assertXml(argument);
            }
        });
        this.withTempFile("testXmlFile2", ".XML", new Callback<File>(){

            @Override
            public void call(File argument) throws Exception {
                TestConfigFile.this.assertXml(argument);
            }
        });
        this.withTempFile("testXmlFile2", ".XmL", new Callback<File>(){

            @Override
            public void call(File argument) throws Exception {
                TestConfigFile.this.assertXml(argument);
            }
        });
    }

    public void testXmlReadFileBad() throws Exception {
        this.withTempFile("testZipReadBad", ".XML", new Callback<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(File argument) throws Exception {
                FileOutputStream fos = new FileOutputStream(argument);
                try {
                    fos.write("randomCrap".getBytes("UTF-8"));
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)fos);
                }
                try {
                    ConfigFile configFile = ConfigFile.create(argument);
                    configFile.readConfig();
                    Assert.fail((String)"Should fail with parsing error.");
                }
                catch (ConfigFile.ConfigFileException configFileException) {
                    // empty catch block
                }
            }
        });
    }

    public void testZipReadGood() throws Exception {
        this.withTempFile("testZipFile1", ".zip", new Callback<File>(){

            @Override
            public void call(File argument) throws Exception {
                TestConfigFile.this.assertZip(argument);
            }
        });
        this.withTempFile("testZipFile2", ".ZIP", new Callback<File>(){

            @Override
            public void call(File argument) throws Exception {
                TestConfigFile.this.assertZip(argument);
            }
        });
        this.withTempFile("testZipFile2", ".ZiP", new Callback<File>(){

            @Override
            public void call(File argument) throws Exception {
                TestConfigFile.this.assertZip(argument);
            }
        });
    }

    public void testZipReadBad() throws Exception {
        this.withTempFile("testZipReadbad", ".zip", new Callback<File>(){

            @Override
            public void call(File argument) throws Exception {
                TestConfigFile.this.withZip(argument, new Callback<OutputStream>(){

                    @Override
                    public void call(OutputStream argument) throws Exception {
                        argument.write("randomBytes".getBytes("UTF-8"));
                    }
                });
                try {
                    ConfigFile configFile = ConfigFile.create(argument);
                    configFile.readConfig();
                    Assert.fail((String)"Should fail with parsing error.");
                }
                catch (ConfigFile.ConfigFileException configFileException) {
                    // empty catch block
                }
            }
        });
        this.withTempFile("testZipReadBad2", ".zip", new Callback<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(File argument) throws Exception {
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(argument));
                try {
                    Document document = TestConfigFile.this.createDummyDocument();
                    String badName = FilenameUtils.getBaseName((String)argument.getName()) + ".doc";
                    zos.putNextEntry(new ZipEntry(badName));
                    TestConfigFile.this.writeXmlToFile(argument, document);
                    zos.close();
                    try {
                        ConfigFile configFile = ConfigFile.create(argument);
                        configFile.readConfig();
                        Assert.fail((String)"Should fail with parsing error.");
                    }
                    catch (ConfigFile.ConfigFileException expected) {
                        // empty catch block
                    }
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)zos);
                }
            }
        });
    }

    public void testWriteXml() throws Exception {
        this.withTempFile("testWrite", ".xml", new Callback<File>(){

            @Override
            public void call(File argument) throws Exception {
                Document document = TestConfigFile.this.createDummyDocument();
                ConfigFile file = ConfigFile.create(argument);
                file.writeFile(document);
                TestConfigFile.this.assertDocumentsEqual(document, TestConfigFile.this.readXmlFromFile(argument));
            }
        });
        this.withTempFile("testWriteComment", ".xml", new Callback<File>(){

            @Override
            public void call(File argument) throws Exception {
                DocumentFactory factory = DocumentFactory.getInstance();
                Document document = factory.createDocument();
                document.addComment("This is a comment");
                document.addElement("someElement");
                ConfigFile file = ConfigFile.create(argument);
                file.writeFile(document);
                TestConfigFile.this.assertFileContents(argument, "<!--This is a comment-->\n<someElement/>");
            }
        });
    }

    public void testWriteZip() throws Exception {
        this.withTempFile("testWriteZip", ".zip", new Callback<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void call(File argument) throws Exception {
                Document document = TestConfigFile.this.createDummyDocument();
                ConfigFile file = ConfigFile.create(argument);
                file.writeFile(document);
                ZipInputStream zis = new ZipInputStream(new FileInputStream(argument));
                try {
                    ZipEntry zipEntry = zis.getNextEntry();
                    Assert.assertNotNull((Object)zipEntry);
                    String expectedName = FilenameUtils.getBaseName((String)argument.getName()) + ".xml";
                    Assert.assertEquals((String)expectedName, (String)zipEntry.getName());
                    TestConfigFile.this.assertDocumentsEqual(document, TestConfigFile.this.readXmlFromStream(zis));
                }
                finally {
                    IOUtils.closeQuietly((InputStream)zis);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withTempFile(String prefix, String suffix, Callback<File> callback) throws Exception {
        File badFile = File.createTempFile(prefix, suffix);
        badFile.deleteOnExit();
        try {
            callback.call(badFile);
        }
        finally {
            this.deleteSafely(badFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withZip(File file, Callback<OutputStream> callback) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));
        try {
            String entryName = FilenameUtils.getBaseName((String)file.getName()) + ".xml";
            zos.setLevel(9);
            zos.putNextEntry(new ZipEntry(entryName));
            callback.call(zos);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zos);
        }
    }

    private void assertZip(File zipFile) throws Exception {
        final Document document = this.createDummyDocument();
        this.withZip(zipFile, new Callback<OutputStream>(){

            @Override
            public void call(OutputStream argument) throws Exception {
                TestConfigFile.this.writeXmlToStream(argument, document);
            }
        });
        ConfigFile configFile = ConfigFile.create(zipFile);
        Document readDocument = configFile.readConfig();
        this.assertDocumentsEqual(document, readDocument);
    }

    private void assertDocumentsEqual(Document expected, Document actual) {
        NodeComparator comparator = new NodeComparator();
        TestConfigFile.assertTrue((comparator.compare(actual, expected) == 0 ? 1 : 0) != 0);
    }

    private void assertFileContents(File file, String expected) throws Exception {
        String actual = FileUtils.readFileToString((File)file, (String)"UTF-8");
        TestConfigFile.assertTrue((boolean)actual.contains(expected));
    }

    private void assertXml(File testFile) throws IOException {
        Document document = this.createDummyDocument();
        this.writeXmlToFile(testFile, document);
        ConfigFile configFile = ConfigFile.create(testFile);
        Document readDocument = configFile.readConfig();
        this.assertDocumentsEqual(document, readDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmlToFile(File file, Document document) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            this.writeXmlToStream(fos, document);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmlToStream(OutputStream os, Document document) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new DontCloseOutputStream(os), "UTF-8");
        try {
            this.writeToWriter(writer, document);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private void writeToWriter(Writer writer, Document document) throws IOException {
        XMLWriter xmlWriter = new XMLWriter(writer, OutputFormat.createPrettyPrint());
        xmlWriter.write(document);
        xmlWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readXmlFromFile(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        try {
            Document document = this.readXmlFromStream(fis);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readXmlFromStream(InputStream stream) throws Exception {
        InputStreamReader reader = new InputStreamReader((InputStream)new DontCloseInputStream(stream), "UTF-8");
        try {
            SAXReader docReader = new SAXReader();
            Document document = docReader.read((Reader)reader);
            return document;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private void deleteSafely(File file) {
        if (file != null) {
            file.delete();
        }
    }

    private Document createDummyDocument() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element element = document.addElement("stuff");
        element.addAttribute("test", "true");
        return document;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Callback<T> {
        public void call(T var1) throws Exception;
    }

    private static class DontCloseInputStream
    extends InputStream {
        private final InputStream delegate;

        private DontCloseInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
        }

        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }

    private static class DontCloseOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        private DontCloseOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() {
        }
    }
}

