/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.Checksummer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestChecksummer
extends TestCase {
    private static final String ATTRIB_DEFAULT = "defaultSum";
    private static final String SUM_MD5 = "md5";
    private static final String SUM_SHA = "sha1";
    private static final String DEFAULT_DEFAULT = "md5";
    private static final String ELEMENT_CHECKSUM = "checksum";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_VALUE = "value";
    private static final String ELEMENT_OBJECT = "object";

    public void testChecksummer() throws Exception {
        Pair other = new Pair("dkkaslka", (Serializable)((Object)"dddss"));
        Checksummer<Pair> summer = new Checksummer<Pair>(new PairHelper(), null);
        TestChecksummer.assertNull((Object)summer.getDefaultSum());
        this.assertChecksum(summer, new Pair("qwerty", Integer.valueOf(1)), new Pair("qwerty", (Serializable)((Object)"2")), other);
        summer = new Checksummer<Pair>(new PairHelper(), "md5");
        TestChecksummer.assertEquals((String)"md5", (String)summer.getDefaultSum());
        this.assertChecksum(summer, new Pair("qwerty", Integer.valueOf(1)), new Pair("qwerty", null), other);
        summer = new Checksummer<Pair>(new PairHelper(), "doesNotExist");
        TestChecksummer.assertEquals((String)"doesNotExist", (String)summer.getDefaultSum());
        this.assertChecksum(summer, new Pair(null, Integer.valueOf(1)), new Pair(null, null), other);
    }

    public void testChecksummerNull() throws Exception {
        Checksummer<Pair> summer = new Checksummer<Pair>(new PairHelper(), null);
        TestChecksummer.assertTrue((boolean)summer.hasChanged(null));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(null));
        TestChecksummer.assertTrue((boolean)summer.update(null));
        TestChecksummer.assertTrue((boolean)summer.update(null));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(null));
        Pair pair = new Pair("a", (Serializable)((Object)"b"));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(pair));
        TestChecksummer.assertTrue((boolean)summer.update(pair));
        TestChecksummer.assertFalse((boolean)summer.hasChanged(pair));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(null));
        TestChecksummer.assertTrue((boolean)summer.remove(null));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(null));
    }

    public void testChecksummerFile() throws Exception {
        File file = this.createFile("random");
        File file2 = this.createFile("random is the best");
        Checksummer<File> fsummer = Checksummer.fileChecksummer(SUM_SHA);
        TestChecksummer.assertTrue((boolean)fsummer.hasChanged(file));
        TestChecksummer.assertTrue((boolean)fsummer.hasChanged(file));
        TestChecksummer.assertTrue((boolean)fsummer.update(file));
        TestChecksummer.assertFalse((boolean)fsummer.hasChanged(file));
        TestChecksummer.assertTrue((boolean)fsummer.update(file2));
        TestChecksummer.assertFalse((boolean)fsummer.update(file2));
        this.appendFile(file, "some more random text");
        TestChecksummer.assertTrue((boolean)fsummer.hasChanged(file));
        TestChecksummer.assertFalse((boolean)fsummer.hasChanged(file2));
        TestChecksummer.assertTrue((boolean)fsummer.update(file));
        TestChecksummer.assertFalse((boolean)fsummer.update(file));
        TestChecksummer.assertFalse((boolean)fsummer.hasChanged(file));
        TestChecksummer.assertTrue((boolean)file.delete());
        TestChecksummer.assertTrue((boolean)file2.delete());
    }

    private <T> void assertChecksum(Checksummer<T> summer, T first, T second, T other) {
        TestChecksummer.assertTrue((boolean)summer.hasChanged(first));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(first));
        TestChecksummer.assertTrue((boolean)summer.update(first));
        TestChecksummer.assertFalse((boolean)summer.hasChanged(first));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(second));
        TestChecksummer.assertFalse((boolean)summer.hasChanged(first));
        TestChecksummer.assertTrue((boolean)summer.update(second));
        TestChecksummer.assertFalse((boolean)summer.hasChanged(second));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(first));
        TestChecksummer.assertFalse((boolean)summer.update(second));
        TestChecksummer.assertFalse((boolean)summer.hasChanged(second));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(first));
        TestChecksummer.assertTrue((boolean)summer.remove(second));
        TestChecksummer.assertFalse((boolean)summer.remove(second));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(second));
        TestChecksummer.assertTrue((boolean)summer.update(second));
        TestChecksummer.assertFalse((boolean)summer.hasChanged(second));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(first));
        TestChecksummer.assertFalse((boolean)summer.remove(other));
        TestChecksummer.assertTrue((boolean)summer.remove(second));
        TestChecksummer.assertFalse((boolean)summer.remove(second));
        TestChecksummer.assertTrue((boolean)summer.hasChanged(second));
    }

    public void testWrite() throws Exception {
        Pair p1 = new Pair("test2");
        Pair p2 = new Pair("test1");
        Checksummer<Pair> checksum = new Checksummer<Pair>(new PairHelper(), "md5");
        TestChecksummer.assertTrue((boolean)checksum.update(p1));
        TestChecksummer.assertTrue((boolean)checksum.isModified());
        DocumentFactory factory = DocumentFactory.getInstance();
        Element element = factory.createElement("test");
        checksum.write(element);
        TestChecksummer.assertFalse((boolean)checksum.isModified());
        TestChecksummer.assertEquals((String)"md5", (String)element.attributeValue(ATTRIB_DEFAULT));
        List elements = element.elements(ELEMENT_CHECKSUM);
        TestChecksummer.assertEquals((int)1, (int)elements.size());
        this.assertChecksumElement((Element)elements.get(0), p1.getKey(), "md5", this.md5(p1));
        TestChecksummer.assertFalse((boolean)checksum.update(p1));
        TestChecksummer.assertFalse((boolean)checksum.isModified());
        TestChecksummer.assertTrue((boolean)checksum.update(p2));
        TestChecksummer.assertTrue((boolean)checksum.isModified());
        checksum.update(p2);
        element = factory.createElement("test");
        checksum.write(element);
        TestChecksummer.assertFalse((boolean)checksum.isModified());
        TestChecksummer.assertEquals((String)"md5", (String)element.attributeValue(ATTRIB_DEFAULT));
        elements = element.elements(ELEMENT_CHECKSUM);
        TestChecksummer.assertEquals((int)2, (int)elements.size());
        this.assertChecksumXpath(element, p1.getKey(), "md5", this.md5(p1));
        this.assertChecksumXpath(element, p2.getKey(), "md5", this.md5(p2));
        TestChecksummer.assertFalse((boolean)checksum.update(p2));
        TestChecksummer.assertFalse((boolean)checksum.isModified());
    }

    public void testRead() throws Exception {
        Pair p1 = new Pair("test2");
        Pair p2 = new Pair("test1");
        Pair p3 = new Pair(null);
        Checksummer<Pair> checksum = new Checksummer<Pair>(new PairHelper(), SUM_SHA);
        TestChecksummer.assertTrue((boolean)checksum.update(p1));
        TestChecksummer.assertTrue((boolean)checksum.isModified());
        DocumentFactory factory = DocumentFactory.getInstance();
        Element element = factory.createElement("test");
        element.addAttribute(ATTRIB_DEFAULT, "md5");
        this.addChecksum(element, p2);
        checksum.read(element);
        TestChecksummer.assertEquals((String)"md5", (String)checksum.getDefaultSum());
        TestChecksummer.assertFalse((boolean)checksum.isModified());
        TestChecksummer.assertFalse((boolean)checksum.hasChanged(p2));
        TestChecksummer.assertTrue((boolean)checksum.hasChanged(p1));
        Element copy = element.createCopy();
        this.addChecksum(copy, p1.getKey(), "md5", null);
        checksum.read(copy);
        TestChecksummer.assertEquals((String)"md5", (String)checksum.getDefaultSum());
        TestChecksummer.assertFalse((boolean)checksum.isModified());
        TestChecksummer.assertFalse((boolean)checksum.hasChanged(p2));
        TestChecksummer.assertTrue((boolean)checksum.hasChanged(p1));
        copy = element.createCopy();
        this.addChecksum(copy, p1.getKey(), "BADALG", "8543098");
        checksum.read(copy);
        TestChecksummer.assertEquals((String)"md5", (String)checksum.getDefaultSum());
        TestChecksummer.assertFalse((boolean)checksum.isModified());
        TestChecksummer.assertFalse((boolean)checksum.hasChanged(p2));
        TestChecksummer.assertTrue((boolean)checksum.hasChanged(p1));
        copy = element.createCopy();
        this.addChecksum(copy, p1.getKey(), "md5", "random");
        checksum.read(copy);
        TestChecksummer.assertEquals((String)"md5", (String)checksum.getDefaultSum());
        TestChecksummer.assertFalse((boolean)checksum.isModified());
        TestChecksummer.assertFalse((boolean)checksum.hasChanged(p2));
        TestChecksummer.assertTrue((boolean)checksum.hasChanged(p1));
        copy = element.createCopy();
        this.addChecksum(copy, p3);
        checksum.read(copy);
        TestChecksummer.assertEquals((String)"md5", (String)checksum.getDefaultSum());
        TestChecksummer.assertFalse((boolean)checksum.isModified());
        TestChecksummer.assertFalse((boolean)checksum.hasChanged(p2));
        TestChecksummer.assertFalse((boolean)checksum.hasChanged(p3));
        TestChecksummer.assertTrue((boolean)checksum.hasChanged(p1));
        element = factory.createElement("testagain");
        checksum = new Checksummer<Pair>(new PairHelper(), null);
        TestChecksummer.assertTrue((boolean)checksum.update(p1));
        TestChecksummer.assertTrue((boolean)checksum.update(p2));
        TestChecksummer.assertTrue((boolean)checksum.update(p3));
        TestChecksummer.assertTrue((boolean)checksum.isModified());
        checksum.write(element);
        checksum = new Checksummer<Pair>(new PairHelper(), "md5");
        checksum.read(element);
        TestChecksummer.assertFalse((boolean)checksum.hasChanged(p1));
        TestChecksummer.assertFalse((boolean)checksum.hasChanged(p2));
        TestChecksummer.assertFalse((boolean)checksum.update(p3));
        TestChecksummer.assertFalse((boolean)checksum.isModified());
        TestChecksummer.assertNull((Object)checksum.getDefaultSum());
    }

    private void assertChecksumXpath(Element element, String name, String type, String value) {
        Node node = element.selectSingleNode("checksum[./object/text() = '" + name + "']");
        this.assertChecksumElement((Element)node, name, type, value);
    }

    private void assertChecksumElement(Element checksum, String objectStr, String type, String value) {
        TestChecksummer.assertEquals((String)objectStr, (String)this.getChildValue(checksum, ELEMENT_OBJECT));
        TestChecksummer.assertEquals((String)type, (String)this.getChildValue(checksum, ELEMENT_TYPE));
        TestChecksummer.assertEquals((String)value, (String)this.getChildValue(checksum, ELEMENT_VALUE));
    }

    private Element addChecksum(Element root, Pair pair) {
        return this.addChecksum(root, pair.getKey(), "md5", this.md5(pair));
    }

    private Element addChecksum(Element root, String object, String type, String value) {
        Element check = root.addElement(ELEMENT_CHECKSUM);
        if (object != null) {
            check.addElement(ELEMENT_OBJECT).setText(object);
        }
        if (type != null) {
            check.addElement(ELEMENT_TYPE).setText(type);
        }
        if (value != null) {
            check.addElement(ELEMENT_VALUE).setText(value);
        }
        return check;
    }

    private String getChildValue(Element parent, String childName) {
        Element element = parent.element(childName);
        if (element == null) {
            return null;
        }
        return StringUtils.trimToNull((String)element.getTextTrim());
    }

    private String md5(Pair pair) {
        return new String(Hex.encodeHex((byte[])DigestUtils.md5((byte[])pair.valueAsBytes())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile(String content) throws IOException {
        File tempFile = File.createTempFile("TestChecksummer", "txt");
        tempFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tempFile);
        try {
            fos.write(content.getBytes("UTF-8"));
            File file = tempFile;
            return file;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFile(File file, String content) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, true);
        try {
            fos.write(content.getBytes("UTF-8"));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    private static class Pair {
        private final String key;
        private final Serializable value;

        private Pair(String key) {
            this(key, (Serializable)((Object)key));
        }

        public Pair(String key, Serializable value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Serializable getValue() {
            return this.value;
        }

        public InputStream valueAsStream() {
            byte[] bytes = this.valueAsBytes();
            if (bytes == null) {
                return null;
            }
            return new ByteArrayInputStream(bytes);
        }

        public byte[] valueAsBytes() {
            if (this.value == null) {
                return new byte[0];
            }
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(this.getValue());
                oos.close();
                return os.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return String.format("{%s: %s}", this.key, this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return !(this.key != null ? !this.key.equals(pair.key) : pair.key != null);
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PairHelper
    implements Checksummer.Helper<Pair> {
        private PairHelper() {
        }

        @Override
        public InputStream asStream(Pair object) {
            if (object == null) {
                return null;
            }
            return object.valueAsStream();
        }

        @Override
        public String asString(Pair object) {
            return object.getKey();
        }

        @Override
        public Pair asObject(String string) {
            return new Pair(string);
        }
    }
}

