/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.CheckMessage;
import junit.framework.TestCase;

public class TestCheckMessage
extends TestCase {
    public void testOnlyMessage() throws Exception {
        String messageStr = "message";
        CheckMessage message = new CheckMessage("message");
        TestCheckMessage.assertEquals((String)"message", (String)message.getMessage());
        TestCheckMessage.assertEquals((String)"message", (String)message.getFormattedMessage());
        TestCheckMessage.assertNull((Object)message.getCheckId());
    }

    public void testNullMessage() throws Exception {
        String msg = "<unknown>";
        CheckMessage message = new CheckMessage(null);
        TestCheckMessage.assertEquals((String)"<unknown>", (String)message.getMessage());
        TestCheckMessage.assertEquals((String)"<unknown>", (String)message.getFormattedMessage());
        TestCheckMessage.assertNull((Object)message.getCheckId());
    }

    public void testCheckId() throws Exception {
        String messageStr = "message";
        String checkId = "checkId";
        CheckMessage message = new CheckMessage("message", "checkId");
        TestCheckMessage.assertEquals((String)"message", (String)message.getMessage());
        TestCheckMessage.assertEquals((String)"[checkId] - message", (String)message.getFormattedMessage());
        TestCheckMessage.assertEquals((String)"checkId", (String)message.getCheckId());
    }

    public void testCheckIdNull() throws Exception {
        String messageStr = "message";
        CheckMessage message = new CheckMessage("message", null);
        TestCheckMessage.assertEquals((String)"message", (String)message.getMessage());
        TestCheckMessage.assertEquals((String)"message", (String)message.getFormattedMessage());
        TestCheckMessage.assertNull((Object)message.getCheckId());
    }
}

