/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.BackupChecker;
import com.atlassian.jira.functest.unittests.config.CheckOptionsFactory;
import com.atlassian.jira.functest.unittests.config.CheckResultBuilder;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigService;
import com.atlassian.jira.functest.unittests.config.ConfigurationCheck;
import com.atlassian.jira.functest.unittests.config.JiraConfig;
import com.atlassian.jira.functest.unittests.config.TestXmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;

public class TestBackupChecker
extends TestCase {
    private static final String CHECKID_SERVICE = "backupservice";
    private static final String CHECKID_SERVICE_HOME = "backupservicehome";
    private static final String CHECKID_SERVICE_DIRECTORY = "backupservicedirectory";
    private static final String CHECKID_GLOBAL = "backupglobaldirectory";
    private static final String PROP_GLOBALPATH = "jira.path.backup";
    private static final String PROP_USE_DEFAULT_DIRECTORY = "USE_DEFAULT_DIRECTORY";
    private static final String PROP_DIR_NAME = "DIR_NAME";
    private static final String DEAFULT_BACKUP_PATH = "func_test_backup";

    public void testInvalidProperties() throws Exception {
        JiraConfig config = new JiraConfig(TestXmlUtils.createInvalidDocument(), null);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        TestBackupChecker.assertEquals((int)1, (int)result.getErrors().size());
        TestBackupChecker.assertTrue((boolean)result.getWarnings().isEmpty());
        TestBackupChecker.assertTrue((boolean)result.getErrors().iterator().next().getMessage().matches(".*Unable to read entry:.*"));
    }

    public void testCheckBackupServiceNoServices() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigService service = new ConfigService(6L, 7L, "DontMatch", "blarg", new ConfigPropertySet());
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.singletonList(service));
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        this.assertGoodResult(result);
    }

    public void testCheckBackupServiceExportService() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigService service = new ConfigService(6L, 7L, "ExportService", "blarg", new ConfigPropertySet());
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.singletonList(service));
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        CheckResultBuilder builder = new CheckResultBuilder();
        builder.error("Backup service 'blarg' exists.", CHECKID_SERVICE);
        TestBackupChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckBackupServiceBadHomeAndDir() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigPropertySet serviceConfig = new ConfigPropertySet();
        serviceConfig.setStringProperty(PROP_DIR_NAME, "somethingrandom");
        ConfigService service = new ConfigService(6L, 7L, "ExportService", "blarg", serviceConfig);
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.singletonList(service));
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE));
        CheckResultBuilder builder = new CheckResultBuilder();
        builder.error("Backup service configured to output to directory 'somethingrandom' it should be using JIRA.HOME.", CHECKID_SERVICE_HOME);
        builder.warning("Backup service configured to output to 'somethingrandom'. It should always be set to 'func_test_backup' even when using JIRA.HOME.", CHECKID_SERVICE_DIRECTORY);
        TestBackupChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckBackupServiceBadHomeAndDirDisabled() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigPropertySet serviceConfig = new ConfigPropertySet();
        ConfigService service = new ConfigService(6L, 7L, "ExportService", "blarg", serviceConfig);
        serviceConfig.setStringProperty(PROP_DIR_NAME, "somethingrandom");
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.singletonList(service));
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE, CHECKID_SERVICE_DIRECTORY, CHECKID_SERVICE_HOME));
        CheckResultBuilder builder = new CheckResultBuilder();
        TestBackupChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckBackupServiceGoodHomeNoDir() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigPropertySet serviceConfig = new ConfigPropertySet();
        serviceConfig.setStringProperty(PROP_USE_DEFAULT_DIRECTORY, "true");
        ConfigService service = new ConfigService(6L, 7L, "ExportService", "blarg", serviceConfig);
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.singletonList(service));
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE));
        CheckResultBuilder builder = new CheckResultBuilder();
        TestBackupChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckBackupServiceGoodHomeBadDir() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigPropertySet serviceConfig = new ConfigPropertySet();
        serviceConfig.setStringProperty(PROP_USE_DEFAULT_DIRECTORY, "true");
        serviceConfig.setStringProperty(PROP_DIR_NAME, "somethingrandom");
        ConfigService service = new ConfigService(6L, 7L, "ExportService", "blarg", serviceConfig);
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.singletonList(service));
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE));
        CheckResultBuilder builder = new CheckResultBuilder();
        builder.warning("Backup service configured to output to 'somethingrandom'. It should always be set to 'func_test_backup' even when using JIRA.HOME.", CHECKID_SERVICE_DIRECTORY);
        TestBackupChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckBackupServiceGoodDir() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigPropertySet serviceConfig = new ConfigPropertySet();
        serviceConfig.setStringProperty(PROP_DIR_NAME, DEAFULT_BACKUP_PATH);
        ConfigService service = new ConfigService(6L, 7L, "ExportService", "blarg", serviceConfig);
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.singletonList(service));
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE));
        CheckResultBuilder builder = new CheckResultBuilder();
        builder.error("Backup service configured to output to directory 'func_test_backup' it should be using JIRA.HOME.", CHECKID_SERVICE_HOME);
        TestBackupChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckBackupServiceGoodHomeAndDir() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigPropertySet serviceProperty = new ConfigPropertySet();
        serviceProperty.setStringProperty(PROP_DIR_NAME, DEAFULT_BACKUP_PATH);
        serviceProperty.setStringProperty(PROP_USE_DEFAULT_DIRECTORY, "true");
        ConfigService service = new ConfigService(6L, 7L, "ExportService", "blarg", serviceProperty);
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.singletonList(service));
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE));
        CheckResultBuilder builder = new CheckResultBuilder();
        TestBackupChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckBackupGlobalBackupSet() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setStringProperty(PROP_GLOBALPATH, "random");
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.<ConfigService>emptyList());
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        CheckResultBuilder builder = new CheckResultBuilder();
        builder.warning("Global backup path set to 'random'.", CHECKID_GLOBAL);
        TestBackupChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckBackupGlobalBackupSetCheckDisabled() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setStringProperty(PROP_GLOBALPATH, "random");
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.<ConfigService>emptyList());
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        ConfigurationCheck.Result result = backupChecker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE_HOME));
        CheckResultBuilder builder = new CheckResultBuilder();
        builder.warning("Global backup path set to 'random'.", CHECKID_GLOBAL);
        TestBackupChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testFixNothing() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigService service = new ConfigService(6L, 7L, "sasadasd.ExportSevice", "blarg", new ConfigPropertySet());
        ArrayList<ConfigService> services = new ArrayList<ConfigService>();
        services.add(service);
        JiraConfig config = new JiraConfig();
        config.setServices(services);
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        backupChecker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestBackupChecker.assertEquals((int)1, (int)config.getServices().size());
        TestBackupChecker.assertSame((Object)service, (Object)config.getServices().get(0));
    }

    public void testFixService() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigService service = new ConfigService(6L, 7L, "sasadasd.ExportService", "blarg", new ConfigPropertySet());
        ArrayList<ConfigService> services = new ArrayList<ConfigService>();
        services.add(service);
        JiraConfig config = new JiraConfig();
        config.setServices(services);
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        backupChecker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestBackupChecker.assertTrue((boolean)config.getServices().isEmpty());
    }

    public void testFixServiceWithDefault() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigPropertySet servicePs = new ConfigPropertySet();
        ConfigService service = new ConfigService(6L, 7L, "sasadasd.ExportService", "blarg", servicePs);
        ArrayList<ConfigService> services = new ArrayList<ConfigService>();
        services.add(service);
        JiraConfig config = new JiraConfig();
        config.setServices(services);
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        backupChecker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE));
        TestBackupChecker.assertEquals((int)1, (int)services.size());
        TestBackupChecker.assertEquals((String)Boolean.TRUE.toString(), (String)service.getPropertySet().getStringProperty(PROP_USE_DEFAULT_DIRECTORY));
        TestBackupChecker.assertNull((Object)service.getPropertySet().getStringProperty(PROP_DIR_NAME));
    }

    public void testFixServiceWithDefaultAndDir() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ConfigPropertySet servicePs = new ConfigPropertySet();
        servicePs.setStringProperty(PROP_DIR_NAME, "random");
        ConfigService service = new ConfigService(6L, 7L, "sasadasd.ExportService", "blarg", servicePs);
        ArrayList<ConfigService> services = new ArrayList<ConfigService>();
        services.add(service);
        JiraConfig config = new JiraConfig();
        config.setServices(services);
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        backupChecker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE, CHECKID_SERVICE_HOME));
        TestBackupChecker.assertEquals((int)1, (int)services.size());
        TestBackupChecker.assertEquals((String)service.getPropertySet().getStringProperty(PROP_DIR_NAME), (String)DEAFULT_BACKUP_PATH);
        TestBackupChecker.assertNull((Object)service.getPropertySet().getStringProperty(PROP_USE_DEFAULT_DIRECTORY));
    }

    public void testFixGlobalBackupPath() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setStringProperty(PROP_GLOBALPATH, "random");
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.<ConfigService>emptyList());
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        backupChecker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE_HOME));
        TestBackupChecker.assertNull((Object)ap.getStringProperty(PROP_GLOBALPATH));
    }

    public void testFixGlobalBackupPathNullPath() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.<ConfigService>emptyList());
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        backupChecker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE_HOME));
        TestBackupChecker.assertNull((Object)ap.getStringProperty(PROP_GLOBALPATH));
    }

    public void testFixGlobalBackupPathDisabled() throws Exception {
        ConfigPropertySet ap = new ConfigPropertySet();
        ap.setStringProperty(PROP_GLOBALPATH, "random");
        JiraConfig config = new JiraConfig();
        config.setServices(Collections.<ConfigService>emptyList());
        config.setApplicationProperties(ap);
        BackupChecker backupChecker = new BackupChecker();
        backupChecker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECKID_SERVICE_HOME, CHECKID_GLOBAL));
        TestBackupChecker.assertEquals((String)"random", (String)ap.getStringProperty(PROP_GLOBALPATH));
    }

    private void assertGoodResult(ConfigurationCheck.Result result) {
        TestBackupChecker.assertTrue((String)"Expected good result but found errors", (boolean)result.getErrors().isEmpty());
        TestBackupChecker.assertTrue((String)"Expected good result but found warnings", (boolean)result.getWarnings().isEmpty());
    }
}

