/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.AttachmentDirectoryChecker;
import com.atlassian.jira.functest.unittests.config.CheckOptionsFactory;
import com.atlassian.jira.functest.unittests.config.CheckResultBuilder;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigurationCheck;
import com.atlassian.jira.functest.unittests.config.JiraConfig;
import com.atlassian.jira.functest.unittests.config.TestXmlUtils;
import junit.framework.TestCase;

public class TestAttachmentDirectoryChecker
extends TestCase {
    private static final String PROP_HOME = "jira.path.attachments.use.default.directory";
    private static final String PROP_PATH = "jira.path.attachments";
    private static final String PROP_ENABLED = "jira.option.allowattachments";
    private static final String VALUE_PATH = "func_test_attachments";
    private static final String CHECK_HOME = "attachhome";
    private static final String CHECK_DIR = "attachdirectory";

    public void testInvalidProperties() throws Exception {
        JiraConfig config = new JiraConfig(TestXmlUtils.createInvalidDocument(), null);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        TestAttachmentDirectoryChecker.assertEquals((int)1, (int)result.getErrors().size());
        TestAttachmentDirectoryChecker.assertTrue((boolean)result.getWarnings().isEmpty());
        TestAttachmentDirectoryChecker.assertTrue((boolean)result.getErrors().iterator().next().getMessage().matches(".*Unable to read entry:.*"));
    }

    public void testCheckAttachmentsChecksDisabled() throws Exception {
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(new ConfigPropertySet());
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECK_DIR, CHECK_HOME));
        TestAttachmentDirectoryChecker.assertTrue((boolean)result.isGood());
    }

    public void testCheckAttachmentsGood() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, true);
        configPropertySet.setBooleanProperty(PROP_ENABLED, true);
        configPropertySet.setBooleanProperty(PROP_PATH, true);
        configPropertySet.setStringProperty(PROP_PATH, VALUE_PATH);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        TestAttachmentDirectoryChecker.assertTrue((boolean)result.isGood());
    }

    public void testCheckAttachmentsNotHome() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, false);
        configPropertySet.setBooleanProperty(PROP_ENABLED, true);
        configPropertySet.setStringProperty(PROP_PATH, VALUE_PATH);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        TestAttachmentDirectoryChecker.assertTrue((boolean)result.getWarnings().isEmpty());
        CheckResultBuilder builder = new CheckResultBuilder();
        builder.error("File has 'func_test_attachments' configured as its attachment path. It should be using its JIRA.HOME.", CHECK_HOME);
        TestAttachmentDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckAttachmentsNotHomeAttachmentsDisabled() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, false);
        configPropertySet.setBooleanProperty(PROP_ENABLED, false);
        configPropertySet.setStringProperty(PROP_PATH, VALUE_PATH);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        CheckResultBuilder builder = new CheckResultBuilder();
        TestAttachmentDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckAttachmentsNotHomeCheckDisabled() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, false);
        configPropertySet.setStringProperty(PROP_PATH, VALUE_PATH);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECK_HOME));
        TestAttachmentDirectoryChecker.assertTrue((boolean)result.isGood());
    }

    public void testCheckAttachmentsBadDir() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setStringProperty(PROP_PATH, "something");
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECK_HOME));
        CheckResultBuilder builder = new CheckResultBuilder();
        builder.warning("File has 'something' configured as it attachment path. It should always be set to 'func_test_attachments' even when using JIRA.HOME.", CHECK_DIR);
        TestAttachmentDirectoryChecker.assertEquals((Object)builder.buildResult(), (Object)result);
    }

    public void testCheckAttachmentsBadDirCheckDisabled() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, true);
        configPropertySet.setStringProperty(PROP_PATH, "randombad");
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.disabled(CHECK_DIR));
        TestAttachmentDirectoryChecker.assertTrue((boolean)result.isGood());
    }

    public void testCheckAttachmentsDirNotSet() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, true);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        ConfigurationCheck.Result result = checker.checkConfiguration(config, CheckOptionsFactory.allOptions());
        TestAttachmentDirectoryChecker.assertTrue((boolean)result.isGood());
    }

    public void testFixAttachmentsGoodAlready() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, true);
        configPropertySet.setStringProperty(PROP_PATH, VALUE_PATH);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestAttachmentDirectoryChecker.assertTrue((boolean)configPropertySet.getBooleanProperty(PROP_HOME));
        TestAttachmentDirectoryChecker.assertEquals((String)VALUE_PATH, (String)configPropertySet.getStringProperty(PROP_PATH));
    }

    public void testFixAttachmentsBadHome() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, false);
        configPropertySet.setStringProperty(PROP_PATH, VALUE_PATH);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        configPropertySet = config.getApplicationProperties();
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.allOptions());
        TestAttachmentDirectoryChecker.assertTrue((boolean)configPropertySet.getBooleanProperty(PROP_HOME));
        TestAttachmentDirectoryChecker.assertEquals((String)VALUE_PATH, (String)configPropertySet.getStringProperty(PROP_PATH));
    }

    public void testFixAttachmentsBadHomeCheckDisabled() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setStringProperty(PROP_PATH, VALUE_PATH);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECK_HOME));
        TestAttachmentDirectoryChecker.assertNull((Object)configPropertySet.getBooleanProperty(PROP_HOME));
        TestAttachmentDirectoryChecker.assertEquals((String)VALUE_PATH, (String)configPropertySet.getStringProperty(PROP_PATH));
    }

    public void testFixAttachmentsBadPath() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, false);
        configPropertySet.setBooleanProperty(PROP_ENABLED, true);
        configPropertySet.setStringProperty(PROP_PATH, "BadPath");
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        configPropertySet = config.getApplicationProperties();
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECK_HOME));
        TestAttachmentDirectoryChecker.assertFalse((boolean)configPropertySet.getBooleanProperty(PROP_HOME));
        TestAttachmentDirectoryChecker.assertEquals((String)VALUE_PATH, (String)configPropertySet.getStringProperty(PROP_PATH));
    }

    public void testFixAttachmentsBadPathCheckDisabled() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, false);
        configPropertySet.setStringProperty(PROP_PATH, "random");
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        configPropertySet = config.getApplicationProperties();
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECK_DIR));
        TestAttachmentDirectoryChecker.assertTrue((boolean)configPropertySet.getBooleanProperty(PROP_HOME));
        TestAttachmentDirectoryChecker.assertEquals((String)"random", (String)configPropertySet.getStringProperty(PROP_PATH));
    }

    public void testFixAttachmentsNoPath() throws Exception {
        ConfigPropertySet configPropertySet = new ConfigPropertySet();
        configPropertySet.setBooleanProperty(PROP_HOME, false);
        JiraConfig config = new JiraConfig();
        config.setApplicationProperties(configPropertySet);
        configPropertySet = config.getApplicationProperties();
        AttachmentDirectoryChecker checker = new AttachmentDirectoryChecker();
        checker.fixConfiguration(config, CheckOptionsFactory.disabled(CHECK_DIR));
        TestAttachmentDirectoryChecker.assertTrue((boolean)configPropertySet.getBooleanProperty(PROP_HOME));
        TestAttachmentDirectoryChecker.assertFalse((boolean)configPropertySet.contains(PROP_PATH));
    }
}

