/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.CheckOptions;
import com.atlassian.jira.functest.unittests.config.CheckResultBuilder;
import com.atlassian.jira.functest.unittests.config.ConfigMailServer;
import com.atlassian.jira.functest.unittests.config.ConfigService;
import com.atlassian.jira.functest.unittests.config.ConfigurationCheck;
import com.atlassian.jira.functest.unittests.config.JiraConfig;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MailChecker
implements ConfigurationCheck {
    private static final String CHECK_MAIL_SERVER = "mailserver";
    private static final String CHECK_MAIL_SERVICE = "mailservice";
    private static final List<String> SERVICES = Arrays.asList("PopService", "ImapService", "FileService");

    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder resultBuilder = new CheckResultBuilder();
        if (options.checkEnabled(CHECK_MAIL_SERVER)) {
            for (ConfigMailServer mailServer : config.getMailServers()) {
                String name = mailServer.getName() == null ? mailServer.getId().toString() : mailServer.getName();
                String type = mailServer.getType() == null ? "<unknown type>" : mailServer.getType().name();
                String serverName = mailServer.getServerName() == null ? "<unknown server>" : mailServer.getServerName();
                String username = mailServer.getUserName() == null ? "<anonymous>" : mailServer.getUserName();
                resultBuilder.error(String.format("Mail server '%s' to '%s:%s' for user '%s' exists.", name, type, serverName, username), CHECK_MAIL_SERVER);
            }
        }
        if (options.checkEnabled(CHECK_MAIL_SERVICE)) {
            List<ConfigService> configServiceList = config.getServices();
            for (ConfigService service : configServiceList) {
                for (String clazzName : SERVICES) {
                    if (!service.getClazz().contains(clazzName)) continue;
                    String name = service.getName();
                    if (StringUtils.isBlank((String)name)) {
                        name = service.getId().toString();
                    }
                    resultBuilder.error(String.format("Mail service '%s' exists.", name), CHECK_MAIL_SERVICE);
                }
            }
        }
        return resultBuilder.buildResult();
    }

    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        if (options.checkEnabled(CHECK_MAIL_SERVER)) {
            config.getMailServers().clear();
        }
        if (options.checkEnabled(CHECK_MAIL_SERVICE)) {
            List<ConfigService> configServiceList = config.getServices();
            Iterator<ConfigService> serviceIterator = configServiceList.iterator();
            while (serviceIterator.hasNext()) {
                ConfigService service = serviceIterator.next();
                for (String clazzName : SERVICES) {
                    if (!service.getClazz().contains(clazzName)) continue;
                    serviceIterator.remove();
                }
            }
        }
    }
}

