/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigMailServer;
import com.atlassian.jira.functest.unittests.config.ConfigMailServerManager;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySetManager;
import com.atlassian.jira.functest.unittests.config.ConfigSequence;
import com.atlassian.jira.functest.unittests.config.ConfigService;
import com.atlassian.jira.functest.unittests.config.ConfigServiceManager;
import com.atlassian.jira.functest.unittests.config.DefaultConfigMailServerManager;
import com.atlassian.jira.functest.unittests.config.DefaultConfigPropertySetManager;
import com.atlassian.jira.functest.unittests.config.DefaultConfigSequence;
import com.atlassian.jira.functest.unittests.config.DefaultConfigServiceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraConfig {
    private static final String APP_PROPS_NAME = "jira.properties";
    private static final long APP_PROPS_ID = 1L;
    private static final String ROOT_ELEMENT = "entity-engine-xml";
    private final Document document;
    private final File file;
    private final ConfigMailServerManager mailServerManager;
    private final ConfigPropertySetManager propertySetManager;
    private final ConfigServiceManager serviceManager;
    private final ConfigSequence configSequence;
    private ConfigPropertySet applicationProperties = null;
    private List<ConfigService> services = null;
    private List<ConfigMailServer> mailServers = null;

    public JiraConfig(Document document, File file) {
        if (!JiraConfig.isJiraXml(document)) {
            throw new IllegalArgumentException("The passed document does not seem to contain JIRA backup XML data.");
        }
        this.document = document;
        this.file = file;
        this.configSequence = new DefaultConfigSequence(document);
        this.mailServerManager = new DefaultConfigMailServerManager(document);
        this.propertySetManager = new DefaultConfigPropertySetManager(document, this.configSequence);
        this.serviceManager = new DefaultConfigServiceManager(document, this.propertySetManager, this.configSequence);
    }

    JiraConfig(Document document, File file, ConfigSequence configSequence, ConfigMailServerManager configMailServerManager, ConfigPropertySetManager configPropertySetManager, ConfigServiceManager configServiceManager) {
        if (!JiraConfig.isJiraXml(document)) {
            throw new IllegalArgumentException("The passed document does not seem to contain JIRA backup XML data.");
        }
        this.document = document;
        this.file = file;
        this.configSequence = configSequence;
        this.mailServerManager = configMailServerManager;
        this.propertySetManager = configPropertySetManager;
        this.serviceManager = configServiceManager;
    }

    public JiraConfig() {
        this(JiraConfig.createEmptyDocument(), null);
    }

    public JiraConfig setApplicationProperties(ConfigPropertySet applicationProperties) {
        this.applicationProperties = applicationProperties;
        return this;
    }

    public ConfigPropertySet getApplicationProperties() {
        if (this.applicationProperties == null) {
            this.applicationProperties = this.propertySetManager.loadPropertySet(APP_PROPS_NAME, 1L);
        }
        return this.applicationProperties;
    }

    public List<ConfigService> getServices() {
        if (this.services == null) {
            this.services = JiraConfig.copy(this.serviceManager.loadServices());
        }
        return this.services;
    }

    public JiraConfig setServices(List<ConfigService> services) {
        this.services = services;
        return this;
    }

    public List<ConfigMailServer> getMailServers() {
        if (this.mailServers == null) {
            this.mailServers = JiraConfig.copy(this.mailServerManager.loadServers());
        }
        return this.mailServers;
    }

    public JiraConfig setMailServers(List<ConfigMailServer> mailServers) {
        this.mailServers = mailServers;
        return this;
    }

    public boolean save() {
        boolean returnValue = false;
        if (this.applicationProperties != null) {
            returnValue = this.propertySetManager.savePropertySet(this.applicationProperties.copyForEntity(APP_PROPS_NAME, 1L));
        }
        if (this.services != null) {
            returnValue = this.serviceManager.saveServices(this.services) | returnValue;
        }
        if (this.mailServers != null) {
            returnValue = this.mailServerManager.saveServers(this.mailServers) | returnValue;
        }
        return this.configSequence.save() | returnValue;
    }

    public Document getDocument() {
        return this.document;
    }

    public File getFile() {
        return this.file;
    }

    public static boolean isJiraXml(Document document) {
        if (document == null) {
            return false;
        }
        Element rootElem = document.getRootElement();
        return rootElem != null && ROOT_ELEMENT.equalsIgnoreCase(rootElem.getName());
    }

    private static Document createEmptyDocument() {
        DocumentFactory instance = DocumentFactory.getInstance();
        Document rootDoc = instance.createDocument();
        rootDoc.setRootElement(instance.createElement(ROOT_ELEMENT));
        return rootDoc;
    }

    private static <T> List<T> copy(Collection<? extends T> source) {
        if (source == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(source);
    }
}

