/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigException;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySet;
import com.atlassian.jira.functest.unittests.config.ConfigPropertySetManager;
import com.atlassian.jira.functest.unittests.config.ConfigSequence;
import com.atlassian.jira.functest.unittests.config.ConfigService;
import com.atlassian.jira.functest.unittests.config.ConfigServiceManager;
import com.atlassian.jira.functest.unittests.config.ConfigXmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultConfigServiceManager
implements ConfigServiceManager {
    private static final String ELEMENT_SERVICE_CONFIG = "ServiceConfig";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TIME = "time";
    private static final String ATTRIBUTE_CLAZZ = "clazz";
    private static final String ATTRIBUTE_NAME = "name";
    private final Document document;
    private final ConfigPropertySetManager propertySetManager;
    private final ConfigSequence configSeqence;

    DefaultConfigServiceManager(Document document, ConfigPropertySetManager propertySetManager, ConfigSequence configSeqence) {
        this.document = document;
        this.propertySetManager = propertySetManager;
        this.configSeqence = configSeqence;
    }

    @Override
    public List<ConfigService> loadServices() {
        List configNodes = this.document.getRootElement().elements(ELEMENT_SERVICE_CONFIG);
        ArrayList<ConfigService> returnList = new ArrayList<ConfigService>(configNodes.size());
        for (Element configNode : configNodes) {
            Long id = ConfigXmlUtils.getLongValue(configNode, ATTRIBUTE_ID);
            if (id == null) {
                throw new ConfigException("Trying to read service without an ID.");
            }
            Long time = ConfigXmlUtils.getLongValue(configNode, ATTRIBUTE_TIME);
            String clazz = ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_CLAZZ);
            String name = ConfigXmlUtils.getTextValue(configNode, ATTRIBUTE_NAME);
            returnList.add(new ConfigService(id, time, clazz, name, this.propertySetManager.loadPropertySet(ELEMENT_SERVICE_CONFIG, id)));
        }
        return returnList;
    }

    @Override
    public boolean saveServices(List<ConfigService> newList) {
        List<ConfigService> oldList = this.loadServices();
        HashMap<Long, ConfigService> oldMap = new HashMap<Long, ConfigService>();
        for (ConfigService oldService : oldList) {
            oldMap.put(oldService.getId(), oldService);
        }
        boolean returnValue = false;
        for (ConfigService newService : newList) {
            ConfigService oldService = (ConfigService)oldMap.get(newService.getId());
            if (oldService == null) {
                Long newId = this.configSeqence.getNextId(ELEMENT_SERVICE_CONFIG);
                Element element = ConfigXmlUtils.createNewElement(this.document.getRootElement(), ELEMENT_SERVICE_CONFIG);
                ConfigXmlUtils.setAttribute(element, ATTRIBUTE_ID, newId.toString());
                ConfigXmlUtils.setAttribute(element, ATTRIBUTE_TIME, DefaultConfigServiceManager.asString(newService.getTimeout()));
                ConfigXmlUtils.setAttribute(element, ATTRIBUTE_NAME, DefaultConfigServiceManager.asString(newService.getName()));
                ConfigXmlUtils.setAttribute(element, ATTRIBUTE_CLAZZ, DefaultConfigServiceManager.asString(newService.getClazz()));
                ConfigPropertySet propertySet = newService.getPropertySet();
                if (propertySet != null) {
                    this.propertySetManager.savePropertySet(propertySet.copyForEntity(ELEMENT_SERVICE_CONFIG, newId));
                }
                returnValue = true;
                continue;
            }
            if (!newService.equals(oldService)) {
                Element element = this.findServiceElement(oldService);
                if (element == null) {
                    throw new ConfigException("Could not find service with id '" + oldService.getId() + "'");
                }
                ConfigXmlUtils.setAttribute(element, ATTRIBUTE_TIME, DefaultConfigServiceManager.asString(newService.getTimeout()));
                ConfigXmlUtils.setAttribute(element, ATTRIBUTE_NAME, DefaultConfigServiceManager.asString(newService.getName()));
                ConfigXmlUtils.setAttribute(element, ATTRIBUTE_CLAZZ, DefaultConfigServiceManager.asString(newService.getClazz()));
                ConfigPropertySet propertySet = newService.getPropertySet();
                if (propertySet != null) {
                    this.propertySetManager.savePropertySet(propertySet.copyForEntity(ELEMENT_SERVICE_CONFIG, newService.getId()));
                } else if (oldService.getPropertySet() != null) {
                    this.propertySetManager.deletePropertySet(oldService.getPropertySet());
                }
                returnValue = true;
            }
            oldMap.remove(newService.getId());
        }
        for (ConfigService deleteService : oldMap.values()) {
            Element element = this.findServiceElement(deleteService);
            if (element == null) {
                throw new ConfigException("Could not find service with id '" + deleteService.getId() + "'");
            }
            this.propertySetManager.deletePropertySet(deleteService.getPropertySet());
            ConfigXmlUtils.removeElement(element);
            returnValue = true;
        }
        return returnValue;
    }

    private Element findServiceElement(ConfigService oldService) {
        return (Element)this.document.selectSingleNode(String.format("/entity-engine-xml/ServiceConfig[@id='%d']", oldService.getId()));
    }

    private static String asString(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }
}

