/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigPropertySetEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigPropertySet {
    private final Map<String, ConfigPropertySetEntry> entries;
    private final String entityName;
    private final Long entityId;

    ConfigPropertySet() {
        this(null, null);
    }

    ConfigPropertySet(String entityName, Long entityId) {
        this(entityName, entityId, Collections.emptyMap());
    }

    ConfigPropertySet(ConfigPropertySet cps) {
        this(cps.entityName, cps.entityId, cps.entries);
    }

    private ConfigPropertySet(String entityName, Long entityId, Map<String, ConfigPropertySetEntry> entries) {
        this.entityName = entityName;
        this.entityId = entityId;
        this.entries = new LinkedHashMap<String, ConfigPropertySetEntry>(entries);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public boolean contains(String propertyName) {
        return this.entries.containsKey(propertyName);
    }

    public String getStringProperty(String propertyName) {
        ConfigPropertySetEntry entry = this.entries.get(propertyName);
        if (entry != null) {
            return entry.asString();
        }
        return null;
    }

    public String getStringPropertyDefault(String propertyKey, String defaultValue) {
        String string = this.getStringProperty(propertyKey);
        return string == null ? defaultValue : string;
    }

    public boolean setStringProperty(String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return this.removeProperty(propertyName);
        }
        return this.entries.put(propertyName, ConfigPropertySetEntry.createStringEntry(propertyName, propertyValue)) != null;
    }

    public String getTextProperty(String propertyName) {
        return this.getStringProperty(propertyName);
    }

    public boolean setTextProperty(String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return this.removeProperty(propertyName);
        }
        return this.entries.put(propertyName, ConfigPropertySetEntry.createTextEntry(propertyName, propertyValue)) != null;
    }

    public Long getLongProperty(String propertyName) {
        ConfigPropertySetEntry entry = this.entries.get(propertyName);
        if (entry != null) {
            return entry.asLong();
        }
        return null;
    }

    public boolean setLongProperty(String propertyName, Long propertyValue) {
        if (propertyValue == null) {
            return this.removeProperty(propertyName);
        }
        return this.entries.put(propertyName, ConfigPropertySetEntry.createLongEntry(propertyName, propertyValue)) != null;
    }

    public Integer getIntegerProperty(String propertyName) {
        ConfigPropertySetEntry entry = this.entries.get(propertyName);
        if (entry != null) {
            return entry.asInteger();
        }
        return null;
    }

    public boolean setIntegerProperty(String propertyName, Integer propertyValue) {
        if (propertyValue == null) {
            return this.removeProperty(propertyName);
        }
        return this.entries.put(propertyName, ConfigPropertySetEntry.createIntegerEntry(propertyName, propertyValue)) != null;
    }

    public Boolean getBooleanProperty(String propertyName) {
        ConfigPropertySetEntry entry = this.entries.get(propertyName);
        if (entry != null) {
            return entry.asBoolean();
        }
        return null;
    }

    public Boolean getBooleanPropertyDefault(String propertyName, Boolean defaultValue) {
        Boolean value = this.getBooleanProperty(propertyName);
        return value == null ? defaultValue : value;
    }

    public boolean setBooleanProperty(String propertyName, Boolean propertyValue) {
        if (propertyValue == null) {
            return this.removeProperty(propertyName);
        }
        return this.entries.put(propertyName, ConfigPropertySetEntry.createBooleanEntry(propertyName, propertyValue)) != null;
    }

    public Object getObjectProperty(String propertyName) {
        ConfigPropertySetEntry entry = this.entries.get(propertyName);
        if (entry != null) {
            return entry.asObject();
        }
        return null;
    }

    public boolean removeProperty(String propertyName) {
        return this.entries.remove(propertyName) != null;
    }

    public ConfigPropertySet copyForEntity(String entity, Long id) {
        return new ConfigPropertySet(entity, id, this.entryMap());
    }

    Collection<ConfigPropertySetEntry> entries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    Map<String, ConfigPropertySetEntry> entryMap() {
        return Collections.unmodifiableMap(this.entries);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Entity: ").append(this.entityName).append(", ID: ").append(this.entityId).append(" {");
        Iterator<ConfigPropertySetEntry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            ConfigPropertySetEntry entry = iterator.next();
            builder.append(entry);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append("}").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigPropertySet that = (ConfigPropertySet)o;
        if (this.entityId != null ? !this.entityId.equals(that.entityId) : that.entityId != null) {
            return false;
        }
        if (this.entityName != null ? !this.entityName.equals(that.entityName) : that.entityName != null) {
            return false;
        }
        return !(this.entries != null ? !((Object)this.entries).equals(that.entries) : that.entries != null);
    }

    public int hashCode() {
        int result = this.entries != null ? ((Object)this.entries).hashCode() : 0;
        result = 31 * result + (this.entityName != null ? this.entityName.hashCode() : 0);
        result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
        return result;
    }
}

