/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import com.atlassian.jira.functest.unittests.config.ConfigException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public abstract class ConfigFile {
    private final File file;

    protected ConfigFile(File file) {
        this.file = file;
    }

    public static ConfigFile create(File file) throws ConfigFileException {
        if (!file.exists()) {
            throw new ConfigFileException(String.format("File '%s' does not exist.", file.getPath()));
        }
        if (file.isDirectory()) {
            throw new ConfigFileException(String.format("File '%s' is a directory.", file.getPath()));
        }
        if (!file.canRead()) {
            throw new ConfigFileException(String.format("Cannot read from '%s'.", file.getPath()));
        }
        String extension = FilenameUtils.getExtension((String)file.getName());
        if ("xml".equalsIgnoreCase(extension)) {
            return new XmlConfigFile(file);
        }
        if ("zip".equalsIgnoreCase(extension)) {
            return new ZipConfigFile(file);
        }
        throw new ConfigFileException(String.format("File '%s' does not appear to be a JIRA config file.", file.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document readConfig() throws ConfigFileException {
        Document document;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(this.getFile()), "UTF-8"));
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setMergeAdjacentText(true);
            document = saxReader.read((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((Reader)reader);
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigFileException("Unable to read configuration for '" + this.getFile().getPath() + "': " + e.getMessage(), e);
            }
            catch (DocumentException e) {
                throw new ConfigFileException("Unable to read configuration for '" + this.getFile().getPath() + "': " + e.getMessage(), e);
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(Document document) throws ConfigFileException {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.getOutputStream(this.getFile()), "UTF-8"));
            try {
                ConfigFile.formatForWrite(document).write((Writer)writer);
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
        }
        catch (IOException e) {
            throw new ConfigFileException("Unable to write configuration to '" + this.getFile().getPath() + "': " + e.getMessage(), e);
        }
    }

    private static Document formatForWrite(Document document) {
        Node elementNode;
        Node node;
        List list = document.content();
        if (list.size() > 1 && (node = (Node)list.get(0)) instanceof Comment && (elementNode = (Node)list.get(1)) instanceof Element) {
            list.add(1, DocumentFactory.getInstance().createText("\n"));
        }
        return document;
    }

    public File getFile() {
        return this.file;
    }

    protected abstract InputStream getInputStream(File var1) throws IOException;

    protected abstract OutputStream getOutputStream(File var1) throws IOException;

    public static class ConfigFileException
    extends ConfigException {
        public ConfigFileException() {
        }

        public ConfigFileException(String message) {
            super(message);
        }

        public ConfigFileException(String message, Throwable cause) {
            super(message, cause);
        }

        public ConfigFileException(Throwable cause) {
            super(cause);
        }
    }

    private static class ZipConfigFile
    extends ConfigFile {
        private ZipConfigFile(File file) {
            super(file);
        }

        protected InputStream getInputStream(File file) throws IOException {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
            try {
                this.checkAndPosition(file, zis);
                return zis;
            }
            catch (IOException e) {
                try {
                    zis.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw e;
            }
        }

        private void checkAndPosition(File file, ZipInputStream zis) throws IOException {
            ZipEntry zipEntry = zis.getNextEntry();
            if (zipEntry == null) {
                throw new IOException("The zip file is empty.");
            }
            if (zipEntry.isDirectory()) {
                throw new IOException(String.format("The zip file contains a directory '%s'.", zipEntry.getName()));
            }
            String expectedName = ZipConfigFile.getEntryName(file);
            if (!zipEntry.getName().equalsIgnoreCase(expectedName)) {
                throw new IOException(String.format("The zip file contains a file '%s' but we expected '%s'.", zipEntry.getName(), expectedName));
            }
        }

        protected OutputStream getOutputStream(File file) throws IOException {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));
            zos.setLevel(9);
            try {
                zos.putNextEntry(new ZipEntry(ZipConfigFile.getEntryName(file)));
                return zos;
            }
            catch (IOException e) {
                try {
                    zos.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw e;
            }
        }

        private static String getEntryName(File file) {
            return FilenameUtils.getBaseName((String)file.getName()) + ".xml";
        }
    }

    private static class XmlConfigFile
    extends ConfigFile {
        private XmlConfigFile(File file) {
            super(file);
        }

        protected InputStream getInputStream(File file) throws IOException {
            return new FileInputStream(file);
        }

        protected OutputStream getOutputStream(File file) throws IOException {
            return new FileOutputStream(file);
        }
    }
}

