/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.unittests.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class Checksummer<T> {
    private static final String ELEMENT_CHECKSUM = "checksum";
    private static final String ELEMENT_OBJ = "object";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_VALUE = "value";
    private static final String ATTRIBUTE_DEFAULT_SUM = "defaultSum";
    private final Helper<T> helper;
    private final Map<T, Check> sums = new HashMap<T, Check>();
    private String defaultSum;
    private boolean modified = false;

    public Checksummer(Helper<T> helper) {
        this(helper, null);
    }

    public Checksummer(Helper<T> helper, String defaultSum) {
        this.defaultSum = defaultSum;
        this.helper = helper;
    }

    public static Checksummer<File> fileChecksummer(String hash) {
        return new Checksummer<File>(FileHelper.getInstance(), hash);
    }

    public String getDefaultSum() {
        return this.defaultSum;
    }

    public void setDefaultSum(String defaultSum) {
        this.defaultSum = defaultSum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanged(T object) {
        Check check = this.sums.get(object);
        if (check == null) {
            return true;
        }
        InputStream stream = this.helper.asStream(object);
        try {
            boolean bl = !check.check(stream);
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(T object) {
        Check check = this.sums.get(object);
        if (check == null) {
            check = this.createCheckForStringWithDefault(this.defaultSum);
            this.sums.put(object, check);
        }
        InputStream stream = this.helper.asStream(object);
        try {
            boolean returnVal = check.update(stream);
            this.modified = this.modified || returnVal;
            boolean bl = returnVal;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public boolean remove(T object) {
        boolean returnVal = this.sums.remove(object) != null;
        this.modified = this.modified || returnVal;
        return returnVal;
    }

    private Check createCheckForStringWithDefault(String string) {
        Check check = this.createCheckForString(string);
        if (check == null) {
            return new Adler32Check();
        }
        return check;
    }

    private Check createCheckForString(String string) {
        if (string == null) {
            return null;
        }
        MessageDigestCheck check = MessageDigestCheck.createCheck(string);
        if (check != null) {
            return check;
        }
        if ("adler32".equalsIgnoreCase(string)) {
            return new Adler32Check();
        }
        return null;
    }

    public void read(Element element) {
        this.sums.clear();
        String def = StringUtils.trimToNull((String)element.attributeValue(ATTRIBUTE_DEFAULT_SUM));
        this.setDefaultSum(def);
        List list = element.elements(ELEMENT_CHECKSUM);
        for (Element checksumElem : list) {
            Check check;
            String objectStr = this.getChildValue(checksumElem, ELEMENT_OBJ);
            String type = this.getChildValue(checksumElem, ELEMENT_TYPE);
            Element value = checksumElem.element(ELEMENT_VALUE);
            if (type == null || value == null || (check = this.createCheckForString(type)) == null || !check.load(value)) continue;
            this.sums.put(this.helper.asObject(objectStr), check);
        }
        this.modified = false;
    }

    private String getChildValue(Element parent, String childName) {
        Element element = parent.element(childName);
        if (element == null) {
            return null;
        }
        return StringUtils.trimToNull((String)element.getTextTrim());
    }

    public void write(Element checkElement) {
        if (this.defaultSum != null) {
            checkElement.addAttribute(ATTRIBUTE_DEFAULT_SUM, this.defaultSum);
        }
        DocumentFactory documentFactory = DocumentFactory.getInstance();
        for (Map.Entry<T, Check> entry : this.sums.entrySet()) {
            Element valueElement = documentFactory.createElement(ELEMENT_VALUE);
            if (!entry.getValue().save(valueElement)) continue;
            Element sumElement = checkElement.addElement(ELEMENT_CHECKSUM);
            String objStr = this.helper.asString(entry.getKey());
            if (objStr != null) {
                sumElement.addElement(ELEMENT_OBJ).setText(objStr);
            }
            sumElement.addElement(ELEMENT_TYPE).setText(entry.getValue().getType());
            sumElement.add(valueElement);
        }
        this.modified = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileHelper
    implements Helper<File> {
        private static final FileHelper instance = new FileHelper();

        private FileHelper() {
        }

        @Override
        public InputStream asStream(File object) {
            if (object == null) {
                return null;
            }
            try {
                return new BufferedInputStream(new FileInputStream(object));
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        @Override
        public String asString(File object) {
            if (object == null) {
                return null;
            }
            return object.getPath();
        }

        @Override
        public File asObject(String string) {
            if (StringUtils.isBlank((String)string)) {
                return null;
            }
            return new File(string);
        }

        public static FileHelper getInstance() {
            return instance;
        }
    }

    private static class MessageDigestCheck
    implements Check {
        private final String digest;
        private byte[] hash = null;

        private MessageDigestCheck(String digest) {
            this.digest = digest;
        }

        public boolean check(InputStream stream) {
            if (this.hash == null) {
                return false;
            }
            byte[] h = this.digest(stream);
            return h != null && Arrays.equals(this.hash, h);
        }

        public boolean update(InputStream stream) {
            byte[] h = this.digest(stream);
            if (h == null) {
                this.hash = null;
                return true;
            }
            if (Arrays.equals(this.hash, h)) {
                return false;
            }
            this.hash = h;
            return true;
        }

        public boolean save(Element element) {
            if (this.hash != null) {
                char[] data = Hex.encodeHex((byte[])this.hash);
                element.setText(new String(data));
                return true;
            }
            return false;
        }

        public boolean load(Element element) {
            String txt = StringUtils.trimToNull((String)element.getTextTrim());
            if (txt != null) {
                try {
                    this.hash = Hex.decodeHex((char[])txt.toCharArray());
                    return true;
                }
                catch (DecoderException decoderException) {
                    // empty catch block
                }
            }
            this.hash = null;
            return false;
        }

        public String getType() {
            return this.digest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] digest(InputStream stream) {
            if (stream == null) {
                return null;
            }
            MessageDigest digest = this.createDigest();
            DigestInputStream dis = new DigestInputStream(stream, digest);
            try {
                IOUtils.copy((InputStream)dis, (OutputStream)new NullOutputStream());
                byte[] byArray = dis.getMessageDigest().digest();
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                IOUtils.closeQuietly((InputStream)dis);
            }
        }

        private MessageDigest createDigest() {
            try {
                return MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        private static MessageDigestCheck createCheck(String name) {
            try {
                MessageDigest.getInstance(name);
                return new MessageDigestCheck(name);
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }
    }

    private static class Adler32Check
    extends DigestCheck {
        private static final String TYPE = "adler32";

        private Adler32Check() {
        }

        protected Checksum createChecksum() {
            return new Adler32();
        }

        public String getType() {
            return TYPE;
        }
    }

    private static abstract class DigestCheck
    implements Check {
        private Long hash = null;

        private DigestCheck() {
        }

        public boolean check(InputStream stream) {
            Long newHash = this.digest(stream);
            return newHash != null && this.hash != null && this.hash.equals(newHash);
        }

        public boolean update(InputStream stream) {
            Long newHash = this.digest(stream);
            if (newHash == null) {
                this.hash = null;
                return true;
            }
            if (newHash.equals(this.hash)) {
                return false;
            }
            this.hash = newHash;
            return true;
        }

        public boolean save(Element element) {
            if (this.hash != null) {
                element.setText(this.hash.toString());
                return true;
            }
            return false;
        }

        public boolean load(Element element) {
            String txt = StringUtils.trimToNull((String)element.getTextTrim());
            if (txt != null) {
                try {
                    this.hash = new Long(txt);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.hash = null;
            return false;
        }

        private Long digest(InputStream stream) {
            if (stream == null) {
                return null;
            }
            try {
                CheckedInputStream cis = new CheckedInputStream(stream, this.createChecksum());
                IOUtils.copy((InputStream)cis, (OutputStream)new NullOutputStream());
                Checksum checksum = cis.getChecksum();
                return checksum.getValue();
            }
            catch (IOException e) {
                return null;
            }
        }

        protected abstract Checksum createChecksum();
    }

    private static interface Check {
        public boolean check(InputStream var1);

        public boolean update(InputStream var1);

        public boolean save(Element var1);

        public boolean load(Element var1);

        public String getType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Helper<T> {
        public InputStream asStream(T var1);

        public String asString(T var1);

        public T asObject(String var1);
    }
}

