/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.sharing;

import com.atlassian.jira.functest.framework.sharing.GlobalTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.ProjectTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.util.json.TestJSONException;
import com.atlassian.jira.functest.framework.util.json.TestJSONObject;

public class SimpleTestSharingPermission
implements TestSharingPermission {
    private final String type;
    private final String perm1;
    private final String perm2;

    public SimpleTestSharingPermission(SimpleTestSharingPermission permission) {
        this(permission.getType(), permission.getPerm1(), permission.getPerm2());
    }

    public SimpleTestSharingPermission(String type) {
        this(type, null);
    }

    public SimpleTestSharingPermission(String type, String perm1) {
        this(type, perm1, null);
    }

    public SimpleTestSharingPermission(String type, String perm1, String perm2) {
        this.type = type;
        this.perm1 = perm1;
        this.perm2 = perm2;
    }

    public String getType() {
        return this.type;
    }

    public String getPerm1() {
        return this.perm1;
    }

    public String getPerm2() {
        return this.perm2;
    }

    public String toString() {
        return "Simple Permission: [Type: " + this.type + ", Perm1: " + this.perm1 + ", Perm2: " + this.perm2 + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTestSharingPermission that = (SimpleTestSharingPermission)o;
        if (this.perm1 != null ? !this.perm1.equals(that.perm1) : that.perm1 != null) {
            return false;
        }
        if (this.perm2 != null ? !this.perm2.equals(that.perm2) : that.perm2 != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.perm1 != null ? this.perm1.hashCode() : 0);
        result = 31 * result + (this.perm2 != null ? this.perm2.hashCode() : 0);
        return result;
    }

    public TestJSONObject toJson() {
        TestJSONObject object = new TestJSONObject();
        try {
            if (this.type != null) {
                object.put("type", this.type);
            }
            if (this.perm1 != null) {
                object.put("param1", this.perm1);
            }
            if (this.perm2 != null) {
                object.put("param2", this.perm2);
            }
        }
        catch (TestJSONException e) {
            throw new RuntimeException(e);
        }
        return object;
    }

    public SimpleTestSharingPermission toSimplePermission() {
        return new SimpleTestSharingPermission(this);
    }

    public static SimpleTestSharingPermission parseJson(TestJSONObject json) throws TestJSONException {
        String type = null;
        String param1 = null;
        String param2 = null;
        if (json.has("type")) {
            type = (String)json.get("type");
        }
        if (json.has("param1")) {
            param1 = (String)json.get("param1");
        }
        if (json.has("param2")) {
            param2 = (String)json.get("param2");
        }
        return new SimpleTestSharingPermission(type, param1, param2);
    }

    public String toDisplayFormat() {
        if ("project".equals(this.type)) {
            return new ProjectTestSharingPermission(this).toDisplayFormat();
        }
        if ("group".equals(this.type)) {
            return new GroupTestSharingPermission(this).toDisplayFormat();
        }
        if ("global".equals(this.type)) {
            return new GlobalTestSharingPermission().toDisplayFormat();
        }
        return this.toString();
    }
}

