/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsrfTestSuite {
    private List<XsrfCheck> checks = new ArrayList<XsrfCheck>();

    public XsrfTestSuite(Collection<XsrfCheck> checks) {
        if (checks == null || checks.isEmpty()) {
            throw new IllegalArgumentException("Please pass in at least one XsrfCheck");
        }
        this.checks.addAll(checks);
    }

    public XsrfTestSuite(XsrfCheck ... checks) {
        if (checks == null || checks.length == 0) {
            throw new IllegalArgumentException("Please pass in at least one XsrfCheck");
        }
        this.checks.addAll(Arrays.asList(checks));
    }

    public void run(FuncTestHelperFactory funcTestHelperFactory) throws Exception {
        for (XsrfCheck check : this.checks) {
            check.init(funcTestHelperFactory);
            check.run();
        }
    }

    public void run(FuncTestHelperFactory funcTestHelperFactory, String xsrfError) throws Exception {
        for (XsrfCheck check : this.checks) {
            check.init(funcTestHelperFactory);
            check.run(xsrfError);
        }
    }
}

