/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigator;

import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.meterware.httpunit.WebForm;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;

public class UserGroupPicker
implements NavigatorCondition {
    public static final String OPTION_ANY_USER = "";
    public static final String OPTION_SPECIFIC_USER = "specificuser";
    public static final String OPTION_CURRENT_USER = "issue_current_user";
    public static final String OPTION_SPECIFIC_GROUP = "specificgroup";
    private String paramName;
    private PickerOption pickerOption;

    public UserGroupPicker(UserGroupPicker picker) {
        this.paramName = picker.paramName;
        this.pickerOption = picker.pickerOption;
    }

    public UserGroupPicker(String paramName) {
        this.setParamName(paramName);
    }

    public UserGroupPicker setParamName(String paramName) {
        this.paramName = paramName;
        return this;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getSelectParamName() {
        return this.paramName + "Select";
    }

    public PickerOption getPickerOption() {
        return this.pickerOption;
    }

    public UserGroupPicker setPickerOption(PickerOption pickerOption) {
        this.pickerOption = pickerOption;
        return this;
    }

    public UserGroupPicker setAnyUser() {
        this.setPickerOption(new PickerOption(OPTION_ANY_USER));
        return this;
    }

    public boolean isAnyUser() {
        return this.isOptionSet(OPTION_ANY_USER);
    }

    public UserGroupPicker setCurrentUser() {
        this.setPickerOption(new PickerOption(OPTION_CURRENT_USER));
        return this;
    }

    public boolean isCurrentUser() {
        return this.isOptionSet(OPTION_CURRENT_USER);
    }

    public UserGroupPicker setUser(String user) {
        return this.setPickerOption(new PickerOption(OPTION_SPECIFIC_USER, user));
    }

    public String getUser() {
        return this.getValueIfOptionSet(OPTION_SPECIFIC_USER);
    }

    public UserGroupPicker setGroup(String group) {
        return this.setPickerOption(new PickerOption(OPTION_SPECIFIC_GROUP, group));
    }

    public String getGroup() {
        return this.getValueIfOptionSet(OPTION_SPECIFIC_GROUP);
    }

    String getValueIfOptionSet(String option) {
        if (this.isOptionSet(option)) {
            return this.getPickerOption().getValue();
        }
        return null;
    }

    boolean isOptionSet(String optionValue) {
        return this.getPickerOption() != null && optionValue.equals(this.getPickerOption().getOption());
    }

    public void setForm(WebTester tester) {
        if (this.getParamName() == null || this.getPickerOption() == null || this.getPickerOption().getOption() == null) {
            throw new IllegalStateException();
        }
        tester.setFormElement(this.getSelectParamName(), this.getPickerOption().getOption());
        if (this.getPickerOption().getValue() != null) {
            tester.setFormElement(this.getParamName(), this.getPickerOption().getValue());
        }
    }

    public void parseCondition(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
        this.setPickerOption(this.getPickerOption(form));
    }

    public void assertSettings(WebTester tester) {
        WebForm form = tester.getDialog().getForm();
        PickerOption currentPicker = this.getPickerOption(form);
        Assert.assertEquals((String)("User/Group picker not set correctly: " + this.paramName), (Object)this.pickerOption, (Object)currentPicker);
    }

    private PickerOption getPickerOption(WebForm form) {
        PickerOption option = null;
        String selectValue = StringUtils.trimToNull((String)form.getParameterValue(this.getSelectParamName()));
        if (selectValue != null) {
            String value = StringUtils.trimToNull((String)form.getParameterValue(this.getParamName()));
            option = new PickerOption(selectValue, value);
        }
        return option;
    }

    public NavigatorCondition copyCondition() {
        return new UserGroupPicker(this);
    }

    public NavigatorCondition copyConditionForParse() {
        return new UserGroupPicker(this.paramName);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("User/Group Picker");
        if (this.paramName != null) {
            buffer.append('(').append(this.paramName).append(')');
        }
        if (this.pickerOption != null) {
            buffer.append(" = ").append(this.pickerOption);
        }
        return buffer.toString();
    }

    public static class PickerOption {
        private final String option;
        private final String value;

        public PickerOption(PickerOption pickerOption) {
            this.option = pickerOption.option;
            this.value = pickerOption.value;
        }

        public PickerOption(String option, String value) {
            this.option = option;
            this.value = value;
        }

        public String getOption() {
            return this.option;
        }

        public String getValue() {
            return this.value;
        }

        public PickerOption(String option) {
            this(option, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickerOption that = (PickerOption)o;
            if (this.option != null ? !this.option.equals(that.option) : that.option != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.option != null ? this.option.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("[");
            builder.append(this.option);
            if (this.value != null) {
                builder.append(", ").append(this.value);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

