/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentManagement;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultAttachmentManagement;
import com.atlassian.jira.functest.framework.navigation.issue.DefaultImageAttachmentsGallery;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.navigation.issue.ImageAttachmentsGallery;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileAttachmentsList
extends Assert
implements FileAttachmentsList {
    private static final String ISSUE_KEY_ID = "key-val";
    private final WebTester tester;
    private final FuncTestLogger logger;
    private final AttachmentManagement attachmentManagement;
    private final ImageAttachmentsGallery imageAttachmentsGallery;

    public DefaultFileAttachmentsList(WebTester tester, FuncTestLogger logger) {
        this.tester = tester;
        this.logger = logger;
        this.attachmentManagement = new DefaultAttachmentManagement(tester, logger);
        this.imageAttachmentsGallery = new DefaultImageAttachmentsGallery(tester, logger);
    }

    @Override
    public List<FileAttachmentsList.FileAttachmentItem> get() {
        this.tester.assertElementPresent(ISSUE_KEY_ID);
        IdLocator issueKeyLocator = new IdLocator(this.tester, ISSUE_KEY_ID);
        this.logger.log("Beginning to retrieve attachments for the issue: " + issueKeyLocator.getText());
        ArrayList<FileAttachmentsList.FileAttachmentItem> fileAttachments = new ArrayList<FileAttachmentsList.FileAttachmentItem>();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='file_attachments']/li[contains(concat(' ', normalize-space(@class), ' '), ' attachment-content ')]");
        for (Node node : xPathLocator.getNodes()) {
            XPathLocator zipContents = new XPathLocator(node, ".//dd[@class='zip-contents']");
            if (zipContents.getNode() == null) {
                XPathLocator nameLocator = new XPathLocator(node, "./dl/dt[@class='attachment-title']/a");
                XPathLocator sizeLocator = new XPathLocator(node, "./dl/dd[@class='attachment-size']");
                XPathLocator authorLocator = new XPathLocator(node, "./dl/dd[@class='attachment-author']");
                XPathLocator dateLocator = new XPathLocator(node, "./dl/dd[@class='attachment-date']");
                fileAttachments.add(FileAttachmentsList.Items.file(nameLocator.getText(), sizeLocator.getText(), authorLocator.getText(), dateLocator.getText()));
                continue;
            }
            ArrayList<FileAttachmentsList.ZipFileAttachmentEntry> zipEntries = new ArrayList<FileAttachmentsList.ZipFileAttachmentEntry>();
            XPathLocator zipFileEntriesLocator = new XPathLocator(zipContents.getNode(), "ol/li");
            for (Node zipFileEntry : zipFileEntriesLocator.getNodes()) {
                XPathLocator nameLocator = new XPathLocator(zipFileEntry, "./a/@title");
                XPathLocator sizeLocator = new XPathLocator(zipFileEntry, "./span[@class='attachment-size']");
                zipEntries.add(FileAttachmentsList.Items.zipEntry(nameLocator.getText(), sizeLocator.getText()));
            }
            XPathLocator zipContentsTrailer = new XPathLocator(zipContents.getNode(), "./span[@class='zip-contents-trailer']");
            boolean containsShowingItemsCount = zipContentsTrailer.getText().contains("Showing 30 of ");
            if (zipEntries.size() == 30) {
                DefaultFileAttachmentsList.assertTrue((boolean)containsShowingItemsCount);
            } else {
                DefaultFileAttachmentsList.assertFalse((boolean)containsShowingItemsCount);
            }
            XPathLocator nameLocator = new XPathLocator(node, ".//div[@class='twixi-wrap concise']/dl/dt[@class='attachment-title']/a");
            XPathLocator sizeLocator = new XPathLocator(node, ".//div[@class='twixi-wrap concise']/dl/dd[@class='attachment-size']");
            XPathLocator authorLocator = new XPathLocator(node, ".//div[@class='twixi-wrap concise']/dl/dd[@class='attachment-author']");
            XPathLocator dateLocator = new XPathLocator(node, ".//div[@class='twixi-wrap concise']/dl/dd[@class='attachment-date']");
            fileAttachments.add(FileAttachmentsList.Items.zip(nameLocator.getText(), sizeLocator.getText(), authorLocator.getText(), dateLocator.getText(), zipEntries));
        }
        this.logger.log("Finished retrieving attachments for the issue: " + issueKeyLocator.getText());
        return fileAttachments;
    }
}

