/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.locator;

import com.atlassian.jira.functest.framework.locator.AbstractLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.meterware.httpunit.WebTable;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TableLocator
extends AbstractLocator {
    private final String tableId;
    private final XPathLocator delegateXpathLocator;
    private WebTable webTable;

    public TableLocator(WebTester tester, String tableId) {
        super(tester);
        if (tableId == null) {
            throw new IllegalArgumentException("The tableId must not be null");
        }
        this.delegateXpathLocator = new XPathLocator(tester, "//table[@id='" + tableId + "']");
        this.tableId = tableId;
        this.checkStateOrInit();
    }

    private synchronized void checkStateOrInit() {
        if (this.nodes == null) {
            try {
                this.webTable = this.tester.getDialog().getResponse().getTableWithID(this.tableId);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            this.originalWebResponse = this.getWebResponse(this.tester);
            this.nodes = this.delegateXpathLocator.getNodes();
        }
    }

    public Node[] getNodes() {
        this.checkStateOrInit();
        return this.nodes;
    }

    public WebTable getTable() {
        this.checkStateOrInit();
        return this.webTable;
    }
}

