/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.functest.framework.util.testcase.TestCaseKit;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestSuiteBuilder {
    private int maxBatch;
    private int batch;
    private boolean log;
    private final Set<Class<? extends TestCase>> testClasses = new LinkedHashSet<Class<? extends TestCase>>();

    public TestSuiteBuilder(int batch, int maxBatch) {
        this.batch(batch);
        this.maxBatch(maxBatch);
        this.log(false);
    }

    public TestSuiteBuilder() {
        this(-1, -1);
    }

    public TestSuiteBuilder addTests(Collection<Class<? extends TestCase>> tests) {
        this.testClasses.addAll(tests);
        return this;
    }

    public TestSuiteBuilder addTests(Class<? extends TestCase> ... tests) {
        return this.addTests(Arrays.asList(tests));
    }

    public TestSuiteBuilder addTest(Class<? extends TestCase> test) {
        this.testClasses.add(test);
        return this;
    }

    public TestSuiteBuilder log(boolean log) {
        this.log = log;
        return this;
    }

    public TestSuiteBuilder batch(int batch) {
        if (batch == 0) {
            throw new IllegalArgumentException("batch == 0");
        }
        this.batch = batch;
        return this;
    }

    public TestSuiteBuilder maxBatch(int maxBatch) {
        if (maxBatch == 0) {
            throw new IllegalArgumentException("maxBatch == 0");
        }
        this.maxBatch = maxBatch;
        return this;
    }

    private boolean isBatchMode() {
        return this.batch >= 0;
    }

    public Test build() {
        return this.isBatchMode() ? this.createTestBatch() : this.createAllTest();
    }

    private Test createAllTest() {
        EnvironmentTestSuite suite = new EnvironmentTestSuite();
        for (Class<? extends TestCase> testClass : this.testClasses) {
            suite.addTestSuite(testClass);
        }
        if (this.log) {
            FuncTestOut.log("** Tests in global **");
            TestSuiteBuilder.outputTest(suite);
            FuncTestOut.log("** End tests in global **");
        }
        return suite;
    }

    private Test createTestBatch() {
        this.checkBatchState();
        int numberOfTests = 0;
        ArrayList<TestPair> tests = new ArrayList<TestPair>(this.testClasses.size());
        for (Class<? extends TestCase> testClass : this.testClasses) {
            EnvironmentTestSuite currentTest = new EnvironmentTestSuite(testClass);
            if (!TestSuiteBuilder.isBatchable(testClass)) {
                if (this.batch != this.maxBatch || currentTest.countTestCases() <= 0) continue;
                tests.add(new TestPair(testClass, (Test)currentTest));
                continue;
            }
            if (TestSuiteBuilder.isSplittable(testClass)) {
                currentTest = this.splitSuite(currentTest);
            } else {
                numberOfTests += currentTest.countTestCases();
            }
            if (currentTest.countTestCases() <= 0) continue;
            tests.add(new TestPair(testClass, (Test)currentTest));
        }
        EnvironmentTestSuite suite = new EnvironmentTestSuite();
        int currentBatchSize = numberOfTests / this.maxBatch;
        if (numberOfTests % this.maxBatch > 0) {
            ++currentBatchSize;
        }
        int batch = 1;
        int size = 0;
        for (TestPair pair : tests) {
            if (!TestSuiteBuilder.isBatchable(pair.getKlazz())) {
                suite.addTest(pair.getTest());
                continue;
            }
            if (TestSuiteBuilder.isSplittable(pair.getKlazz())) {
                suite.addTest(pair.getTest());
                continue;
            }
            if (batch > this.batch) continue;
            if (batch == this.batch) {
                suite.addTest(pair.getTest());
            }
            if ((size += pair.getTest().countTestCases()) < currentBatchSize) continue;
            numberOfTests -= size;
            int remainingBatches = this.maxBatch - batch;
            if (remainingBatches > 0) {
                currentBatchSize = numberOfTests / remainingBatches;
                if (numberOfTests % remainingBatches > 0) {
                    ++currentBatchSize;
                }
            } else {
                assert (numberOfTests == 0);
                currentBatchSize = 0;
            }
            ++batch;
            size = 0;
        }
        if (this.log) {
            FuncTestOut.log(String.format("** Tests in batch %d of %d **", this.batch, this.maxBatch));
            TestSuiteBuilder.outputTest(suite);
            FuncTestOut.log(String.format("** End tests in batch %d of %d **", this.batch, this.maxBatch));
        }
        return suite;
    }

    private void checkBatchState() {
        if (this.maxBatch < 0) {
            throw new IllegalStateException(String.format("Invalid maxBatch(%d) when batch(%d) >= 0.", this.maxBatch, this.batch));
        }
        if (this.batch > this.maxBatch) {
            throw new IllegalStateException(String.format("batch(%d) > maxBatch(%d).", this.batch, this.maxBatch));
        }
    }

    private static boolean isBatchable(Class<?> testClass) {
        return EnvironmentAware.class.isAssignableFrom(testClass);
    }

    private static boolean isSplittable(Class<? extends TestCase> testClass) {
        return testClass.getAnnotation(Splitable.class) != null;
    }

    private TestSuite splitSuite(TestSuite splitTest) {
        EnvironmentTestSuite newSuite = new EnvironmentTestSuite(splitTest.getName());
        ArrayList<TestCase> newTests = new ArrayList<TestCase>(splitTest.countTestCases());
        Enumeration enumeration = splitTest.tests();
        while (enumeration.hasMoreElements()) {
            Test innerTest = (Test)enumeration.nextElement();
            if (innerTest instanceof TestCase) {
                newTests.add((TestCase)innerTest);
                continue;
            }
            if (this.batch != 1) continue;
            newSuite.addTest(innerTest);
        }
        Collections.sort(newTests, new Comparator<TestCase>(){

            @Override
            public int compare(TestCase o1, TestCase o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int testsInBatch = newTests.size() / this.maxBatch;
        int testsInBatchRem = newTests.size() % this.maxBatch;
        int startPos = testsInBatch * (this.batch - 1);
        if (testsInBatchRem != 0) {
            startPos = this.batch <= testsInBatchRem ? (startPos += this.batch - 1) : (startPos += testsInBatchRem);
        }
        if (startPos < newTests.size()) {
            int endPos = testsInBatch + startPos;
            if (endPos > newTests.size()) {
                endPos = newTests.size();
            } else if (endPos < newTests.size() && this.batch <= testsInBatchRem) {
                ++endPos;
            }
            for (TestCase testCase : newTests.subList(startPos, endPos)) {
                newSuite.addTest((Test)testCase);
            }
        }
        return newSuite;
    }

    private static void outputTest(TestSuite suite) {
        Enumeration enumeration = suite.tests();
        while (enumeration.hasMoreElements()) {
            Test nextTest = (Test)enumeration.nextElement();
            if (nextTest instanceof TestSuite) {
                TestSuiteBuilder.outputTest((TestSuite)nextTest);
                continue;
            }
            if (nextTest instanceof TestCase) {
                FuncTestOut.log(TestCaseKit.getFullName((TestCase)nextTest));
                continue;
            }
            FuncTestOut.log("Unknown Test: " + nextTest);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static class EnvironmentTestSuite
    extends TestSuite
    implements EnvironmentAware {
        public EnvironmentTestSuite() {
        }

        public EnvironmentTestSuite(Class theClass) {
            super(theClass);
        }

        public EnvironmentTestSuite(String name) {
            super(name);
        }

        public void setEnvironmentData(JIRAEnvironmentData environmentData) {
            Enumeration enumeration = this.tests();
            while (enumeration.hasMoreElements()) {
                Object testObj = enumeration.nextElement();
                if (!(testObj instanceof EnvironmentAware)) continue;
                ((EnvironmentAware)testObj).setEnvironmentData(environmentData);
            }
        }

        public void addTestSuite(Class testClass) {
            this.addTest((Test)new EnvironmentTestSuite(testClass));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestPair {
        private final Class<? extends TestCase> klazz;
        private final Test test;

        private TestPair(Class<? extends TestCase> klazz, Test test) {
            this.klazz = klazz;
            this.test = test;
        }

        private Class<? extends TestCase> getKlazz() {
            return this.klazz;
        }

        private Test getTest() {
            return this.test;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

