/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.setup.JiraSetupInstanceHelper;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;

public class FuncTestCaseJiraSetup
extends AbstractFuncTestUtil {
    private long startTime;
    private static long classStartTime = System.currentTimeMillis();
    private final Navigation navigation;

    public FuncTestCaseJiraSetup(TestCase testCase, WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, FuncTestWebClientListener webClientListener) {
        super(tester, environmentData, 2);
        this.environmentData = environmentData;
        this.startTime = System.currentTimeMillis();
        this.navigation = navigation;
        new JiraSetupInstanceHelper(tester, environmentData).ensureJIRAIsReadyToGo(webClientListener);
    }

    public void tearDown(TestCase testCase) {
        String testName = testCase.getClass().getName() + "." + testCase.getName();
        try {
            this.navigation.logout();
        }
        catch (RuntimeException rte) {
            this.log("Could not logout on '" + testName + ".tearDown()'");
        }
    }

    public long getRuntimeMillis() {
        return FuncTestCaseJiraSetup.getRuntimeMillis(this.startTime);
    }

    public static long getRuntimeMillis(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    public static long getSuiteRuntimeMillis() {
        return System.currentTimeMillis() - classStartTime;
    }

    static String getTestName(TestCase testCase) {
        return testCase.getClass().getName() + "." + testCase.getName();
    }
}

