/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.functest.framework.log.FuncTestLoggerImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class AbstractFuncTestUtil
implements FuncTestLogger {
    protected JIRAEnvironmentData environmentData;
    protected WebTester tester;
    protected FuncTestLogger logger;
    protected static final String FS = System.getProperty("file.separator");
    private final FuncTestHelperFactory funcTestHelperFactory;

    public AbstractFuncTestUtil(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        this.environmentData = environmentData;
        this.tester = tester;
        this.logger = new FuncTestLoggerImpl(logIndentLevel);
        this.funcTestHelperFactory = new FuncTestHelperFactory(tester, environmentData);
    }

    public JIRAEnvironmentData getEnvironmentData() {
        return this.environmentData;
    }

    public FuncTestHelperFactory getFuncTestHelperFactory() {
        return this.funcTestHelperFactory;
    }

    public FuncTestLogger getLogger() {
        return this.logger;
    }

    public void log(Object logData) {
        this.logger.log(logData);
    }

    public void log(Throwable t) {
        this.logger.log(t);
    }

    protected void submitAtPage(String url, String button, String logOnFail) {
        this.tester.gotoPage(url);
        if (this.tester.getDialog().hasSubmitButton(button)) {
            this.tester.submit(button);
        } else if (logOnFail != null) {
            this.log(logOnFail);
        }
    }
}

