(function () {
    var suppressedFlag;

    var getMeta = function(name) {
        return AJS.Meta.getBoolean(name) === true;
    };

    var FeedbackLinkApi = Class.extend({
        /**
         * Suppresses the feedback link.
         *
         * @return {undefined}
         */
        suppress: function() {
            suppressedFlag = true;

            return undefined;
        },

        /**
         * Returns a boolean indicating whether the feedback link has been suppressed.
         *
         * @return {Boolean} whether the Feedback link has been suppressed.
         */
        isSuppressed: function() {
            if (suppressedFlag === true) {
                return true;
            }

            // also respect what's in the page <head>
            return getMeta('disable-issue-collector');
        }
    });

    // export public things
    JIRA = JIRA || {};
    JIRA.Feedback = JIRA.Feedback || {};
    JIRA.Feedback.Link = new FeedbackLinkApi();

})();
