AJS.$(function ($) {
    "use strict";

    var evalCollectorId = "d3de7fb5";
    var onDemandCollectorId = "c612fb25";

    var buildInfo = AJS.Meta.get("version-number");
    var itWontCauseAnInsecureContentWarning = !($.browser.msie && parseInt($.browser.version, 10) < 9);
    var selectCollectorId = function () {
        // JIRADEV-11614, JRADEV-12356 - Sadly, jQuery#ajax will cause IE7 / IE8 to warn about insecure content.
        if (!itWontCauseAnInsecureContentWarning) {
            return false;
        }

        if (AJS.DarkFeatures.isEnabled("com.atlassian.jira.config.CoreFeatures.ON_DEMAND")) {
            return onDemandCollectorId;
        }

        //check if this is the sandbox
        if (AJS.params.baseURL && AJS.params.baseURL.indexOf("sandbox.onjira.com") >= 0) {
            return evalCollectorId;
        }
        //check if we are running a m,beta,rc or SNAPSHOT release
        if (AJS.Meta.get("is-beta") || AJS.Meta.get("is-rc") ||
                AJS.Meta.get("is-snapshot") || AJS.Meta.get("is-milestone")) {
            return evalCollectorId;
        }
        //check if this is an evaluation license
        if ($(".licensemessagered:contains('JIRA evaluation license')").length > 0) {
            return evalCollectorId;
        }

        return false;
    };

    var collectorId = selectCollectorId();
    if (!JIRA.Feedback.Link.isSuppressed() && collectorId) {
        _renderFeedbackLink();
        JIRA.bind(JIRA.Events.LAYOUT_RENDERED, _listenToEvents);
        JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, _listenToEvents);
    }

    function _listenToEvents(e, context, reason) {
        if ((e.type === "newContentAdded" && reason === "pageLoad") ||
            (e.type === "layoutRendered" && context === "list-view")) {
            var shouldDockLeft = $(".navigator-sidebar").hasClass("collapsed");
            var feedback = $('.jira-feedback-link-container');
            feedback.remove();
            feedback = _renderFeedbackLink();
            if (shouldDockLeft && feedback.hasClass("subtle-style")) {
                feedback.addClass("left noborder");
            }
        }
    }

    function _onFeedbackLinkClick() {

        var footerText = $("#footer-build-information").text();
        var environmentProps = function () {
            return {
                "Location": window.location.href,
                "User-Agent": navigator.userAgent,
                "Referrer": document.referrer,
                "Screen Resolution": screen.width + " x " + screen.height,
                "JIRA Version": buildInfo,
                "JIRA Footer Version": footerText
            };
        };

        var dlg = new JIRAS_OWN_ATL_JQ.IssueDialog({
            collectorId: collectorId,
            collectFeedback: environmentProps
        });
        dlg.show();
    }

    function _renderFeedbackLink() {
        // It's possible to have multiple Atlassian footers, we want the Got Feedback link on the first.
        var footer = $("#footer .atlassian-footer:visible").eq(0);
        var target;

        if (footer.length > 0) {
            target = footer;
            target.append(JIRA.Feedback.Plugin.footerLink());
        } else {
            target = $("body");
            target.append(JIRA.Feedback.Plugin.subtleLink());
        }

        var container = target.find(".jira-feedback-link-container");
        container.on("click", ".jira-feedback-link", _onFeedbackLinkClick);
        return container;
    }
});
