/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.sal.api.page.PageCapabilities;
import com.atlassian.sal.api.page.PageCapability;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import javax.servlet.http.HttpServletRequest;

public class PageCapabilitiesImpl
extends PageCapabilities {
    public static final String DEFAULT_PARAM_NAME = "page_caps";
    public static final String DEFAULT_CLS_PREFIX = "CAPS_";
    public static final String DEFAULT_ATTR_NAME = "pageCaps";
    private final EnumSet<PageCapability> pageCaps;

    public static PageCapabilitiesImpl fromRequest(HttpServletRequest request) {
        return PageCapabilitiesImpl.fromRequest(request, DEFAULT_PARAM_NAME);
    }

    public static PageCapabilitiesImpl fromRequest(HttpServletRequest request, String paramName) {
        return new PageCapabilitiesImpl(PageCapabilities.valueOf((String)request.getParameter(paramName)));
    }

    public PageCapabilitiesImpl(EnumSet<PageCapability> pageCaps) {
        this.pageCaps = pageCaps;
    }

    public String getBodyCssClass() {
        return this.getBodyCssClass(DEFAULT_CLS_PREFIX);
    }

    public String getBodyCssClass(final String clsPrefix) {
        return Joiner.on((String)" ").join(Iterables.transform(this.pageCaps, (Function)new Function<PageCapability, String>(){

            public String apply(PageCapability pageCapability) {
                return clsPrefix + pageCapability.toString();
            }
        }));
    }

    public PageCapabilitiesImpl setRequestAttribute(HttpServletRequest request) {
        return this.setRequestAttribute(request, DEFAULT_ATTR_NAME);
    }

    public PageCapabilitiesImpl setRequestAttribute(HttpServletRequest request, String attributeName) {
        request.setAttribute(attributeName, (Object)PageCapabilities.toString(this.pageCaps));
        return this;
    }

    public EnumSet<PageCapability> getPageCaps() {
        return this.pageCaps;
    }
}

