/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.servlet.AbstractViewFileServlet;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import com.atlassian.jira.web.servlet.MimeSniffingKit;
import io.atlassian.blobstore.client.api.Unit;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewAttachmentServlet
extends AbstractViewFileServlet {
    @Override
    protected void getInputStream(String attachmentQuery, InputStreamConsumer<Unit> consumer) throws PermissionException, IOException {
        Attachment attachment = this.getAttachment(attachmentQuery);
        if (!this.hasPermissionToViewAttachment(this.getUserName(), attachment)) {
            throw new PermissionException("You do not have permissions to view this issue");
        }
        ComponentAccessor.getAttachmentManager().streamAttachmentContent(attachment, consumer);
    }

    protected Attachment getAttachment(String query) {
        Long id;
        int x = query.indexOf(47, 1);
        String idStr = query.substring(1, x);
        try {
            id = new Long(idStr);
        }
        catch (NumberFormatException e) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        if (query.indexOf(47, x + 1) != -1) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        return ComponentAccessor.getAttachmentManager().getAttachment(id);
    }

    @Override
    protected void setResponseHeaders(HttpServletRequest request, HttpServletResponse response) throws AttachmentNotFoundException, IOException {
        Attachment attachment = this.getAttachment(this.attachmentQuery(request));
        response.setContentType(attachment.getMimetype());
        response.setContentLength(attachment.getFilesize().intValue());
        this.getMimeSniffingKit().setAttachmentResponseHeaders(attachment, request.getHeader("USER-AGENT"), response);
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
    }

    private MimeSniffingKit getMimeSniffingKit() {
        return (MimeSniffingKit)ComponentAccessor.getComponent(MimeSniffingKit.class);
    }

    protected boolean hasPermissionToViewAttachment(String username, Attachment attachment) throws DataAccessException {
        Issue issue = attachment.getIssueObject();
        if (username == null) {
            return ComponentAccessor.getPermissionManager().hasPermission(10, issue, (ApplicationUser)null);
        }
        ApplicationUser user = ComponentAccessor.getUserManager().getUserByName(username);
        if (user == null) {
            throw new DataAccessException("User '" + username + "' not found");
        }
        return ComponentAccessor.getPermissionManager().hasPermission(10, issue, user);
    }
}

