/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.multiuserpicker;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.jira.web.component.WebComponentUtils;
import com.atlassian.jira.web.component.multiuserpicker.UserBean;
import com.atlassian.jira.web.component.multiuserpicker.UserPickerLayoutBean;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserPickerWebComponent
extends AbstractWebComponent {
    private final JiraAuthenticationContext authenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class);
    private final UserSearchService searchService;

    public UserPickerWebComponent(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, UserSearchService searchService) {
        super(templatingEngine, applicationProperties);
        this.searchService = searchService;
    }

    public String getHtml(UserPickerLayoutBean layoutBean, Collection<ApplicationUser> currentUsers, boolean canEdit, Long id) {
        List<UserBean> userBeans = UserBean.convertUsersToUserBeans(this.authenticationContext.getLocale(), currentUsers);
        return this.getHtml(layoutBean, userBeans, canEdit, id, this.getI18nBean());
    }

    public String getHtmlForUsernames(UserPickerLayoutBean layoutBean, List<String> usernames, boolean canEdit, Long id) {
        List<UserBean> userBeans = UserBean.convertUsernamesToUserBeans(this.authenticationContext.getLocale(), usernames);
        return this.getHtml(layoutBean, userBeans, canEdit, id, this.getI18nBean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHtml(UserPickerLayoutBean layoutBean, List<UserBean> currentUsers, boolean canEdit, Long id, I18nHelper i18n) {
        try {
            UtilTimerStack.push((String)"UserPickerHtml");
            ApplicationUser loggedInUser = this.authenticationContext.getUser();
            boolean canPickUsers = ComponentAccessor.getPermissionManager().hasPermission(27, loggedInUser);
            HashMap<String, Object> startingParams = new HashMap<String, Object>();
            startingParams.put("userUtil", ComponentAccessor.getUserUtil());
            startingParams.put("layout", layoutBean);
            startingParams.put("currentSelections", currentUsers);
            startingParams.put("i18n", i18n);
            startingParams.put("canEdit", canEdit);
            startingParams.put("id", id);
            startingParams.put("canPick", canPickUsers);
            startingParams.put("windowName", "UserPicker");
            Map<String, Object> velocityParams = JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
            JiraServiceContextImpl ctx = new JiraServiceContextImpl(loggedInUser);
            boolean canPerformAjaxSearch = this.searchService.canPerformAjaxSearch((JiraServiceContext)ctx);
            if (canPerformAjaxSearch) {
                velocityParams.put("canPerformAjaxSearch", "true");
                velocityParams.put("ajaxLimit", this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
            }
            WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
            webResourceManager.requireResource("jira.webresources:autocomplete");
            String string = this.getHtml("templates/jira/multipicker/pickertable.vm", velocityParams);
            return string;
        }
        finally {
            UtilTimerStack.pop((String)"UserPickerHtml");
        }
    }

    public static Collection<String> getUserNamesToRemove(Map<String, ?> params, String paramPrefix) {
        return WebComponentUtils.getRemovalValues(params, paramPrefix);
    }

    public static Collection<String> getUserNamesToAdd(String rawUserNames) {
        return WebComponentUtils.convertStringToCollection(rawUserNames);
    }

    private I18nHelper getI18nBean() {
        return this.authenticationContext.getI18nHelper();
    }
}

