/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.jql;

import com.atlassian.fugue.Option;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.index.property.AliasClauseInformation;
import com.atlassian.jira.index.property.IssuePropertyJql;
import com.atlassian.jira.issue.comparator.LocaleSensitiveStringComparator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.NoOpClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.ArrayListMultimap;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;

public class DefaultAutoCompleteJsonGenerator
implements AutoCompleteJsonGenerator {
    private final SearchHandlerManager searchHandlerManager;
    private final JqlStringSupport jqlStringSupport;
    private final FieldManager fieldManager;
    private final JqlFunctionHandlerRegistry jqlFunctionHandlerRegistry;

    public DefaultAutoCompleteJsonGenerator(SearchHandlerManager searchHandlerManager, JqlStringSupport jqlStringSupport, FieldManager fieldManager, JqlFunctionHandlerRegistry jqlFunctionHandlerRegistry) {
        this.searchHandlerManager = searchHandlerManager;
        this.jqlStringSupport = jqlStringSupport;
        this.fieldManager = fieldManager;
        this.jqlFunctionHandlerRegistry = jqlFunctionHandlerRegistry;
    }

    public String getVisibleFieldNamesJson(ApplicationUser user, Locale locale) throws JSONException {
        String displayName;
        TreeMap<String, Object> visibleNames = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        HashMap<String, HashSet<ClauseNameValue>> customFieldNameToClauseNames = new HashMap<String, HashSet<ClauseNameValue>>();
        ArrayListMultimap aliasClauseNames = ArrayListMultimap.create();
        Collection handlers = this.searchHandlerManager.getVisibleClauseHandlers(user);
        for (ClauseHandler clauseHandler : handlers) {
            boolean isSearchable;
            ClauseInformation information = clauseHandler.getInformation();
            ClauseNames visibleClauseName = information.getJqlClauseNames();
            String fieldId = information.getFieldId();
            Set supportedOperators = information.getSupportedOperators();
            JiraDataType supportedType = information.getDataType();
            Field field = this.fieldManager.getField(fieldId);
            boolean isAutoCompleteable = clauseHandler instanceof ValueGeneratingClauseHandler;
            boolean isOrderByable = field instanceof NavigableField;
            boolean bl = isSearchable = !(clauseHandler instanceof NoOpClauseHandler);
            if (this.isCustomFieldClauseNames(visibleClauseName) && field != null) {
                String name = field instanceof CustomField ? ((CustomField)field).getUntranslatedName() : field.getName();
                HashSet<ClauseNameValue> namesList = (HashSet<ClauseNameValue>)customFieldNameToClauseNames.get(name);
                if (namesList == null) {
                    namesList = new HashSet<ClauseNameValue>();
                    customFieldNameToClauseNames.put(name, namesList);
                }
                namesList.add(new ClauseNameValue(visibleClauseName.getPrimaryName(), isAutoCompleteable, isOrderByable, isSearchable, visibleClauseName.getJqlFieldNames().size() == 1, supportedOperators, supportedType));
                for (String s : visibleClauseName.getJqlFieldNames()) {
                    if (JqlCustomFieldId.isJqlCustomFieldId((String)s) || s.equalsIgnoreCase(name)) continue;
                    HashSet<ClauseNameValue> clauseNamesList = (HashSet<ClauseNameValue>)customFieldNameToClauseNames.get(name);
                    if (clauseNamesList == null) {
                        clauseNamesList = new HashSet<ClauseNameValue>();
                        customFieldNameToClauseNames.put(s, clauseNamesList);
                    }
                    clauseNamesList.add(new ClauseNameValue(visibleClauseName.getPrimaryName(), isAutoCompleteable, isOrderByable, isSearchable, visibleClauseName.getJqlFieldNames().size() == 1, supportedOperators, supportedType));
                }
                continue;
            }
            if (this.isJqlPropertyClauseFieldName(information)) {
                AliasClauseInformation aliasClauseInformation = (AliasClauseInformation)information;
                IssuePropertyJql issuePropertyJql = aliasClauseInformation.getIssuePropertyJql();
                ClauseNameValue clauseNameValue = new ClauseNameValue(issuePropertyJql.getCanonicalJql(), aliasClauseInformation.isAutoComplete(), aliasClauseInformation.isOrderable(), true, false, information.getSupportedOperators(), information.getDataType());
                aliasClauseNames.put((Object)aliasClauseInformation.getAlias(), (Object)new AliasClauseNameValue(clauseNameValue, aliasClauseInformation));
                continue;
            }
            for (String clauseName : visibleClauseName.getJqlFieldNames()) {
                visibleNames.put(clauseName, new ClauseNameValue(clauseName, isAutoCompleteable, isOrderByable, isSearchable, false, supportedOperators, supportedType));
            }
        }
        for (Map.Entry entry : aliasClauseNames.asMap().entrySet()) {
            String alias = (String)entry.getKey();
            Collection clauseNames = (Collection)entry.getValue();
            if (visibleNames.containsKey(alias) || customFieldNameToClauseNames.containsKey(alias) || clauseNames.size() > 1) {
                for (AliasClauseNameValue clauseName : clauseNames) {
                    displayName = alias + " - " + clauseName.getInformation().getPluginName();
                    visibleNames.put(displayName, clauseName.getClauseNameValue());
                }
                continue;
            }
            ClauseNameValue aliasClauseName = ((AliasClauseNameValue)clauseNames.iterator().next()).getClauseNameValue();
            visibleNames.put(alias, new ClauseNameValue(alias, aliasClauseName.isAutoCompleteable(), aliasClauseName.isOrderByable(), aliasClauseName.isSearchable(), aliasClauseName.isMustUseNameValue(), aliasClauseName.getSupportedOperators(), aliasClauseName.getSupportedType()));
        }
        for (Map.Entry entry : customFieldNameToClauseNames.entrySet()) {
            String customFieldName = (String)entry.getKey();
            Set clauseNameValues = (Set)entry.getValue();
            if (clauseNameValues.size() == 1) {
                ClauseNameValue cfClauseValue = (ClauseNameValue)clauseNameValues.iterator().next();
                String displayName2 = customFieldName + " - " + cfClauseValue.getClauseNameValue();
                if (!(visibleNames.containsKey(customFieldName) || aliasClauseNames.containsKey((Object)customFieldName) || cfClauseValue.isMustUseNameValue())) {
                    visibleNames.put(displayName2, new ClauseNameValue(customFieldName, cfClauseValue.getClauseNameValue(), cfClauseValue.isAutoCompleteable(), cfClauseValue.isOrderByable(), cfClauseValue.isSearchable(), cfClauseValue.isMustUseNameValue(), cfClauseValue.getSupportedOperators(), cfClauseValue.getSupportedType()));
                    continue;
                }
                visibleNames.put(displayName2, cfClauseValue);
                continue;
            }
            for (ClauseNameValue cfClauseValue : clauseNameValues) {
                displayName = customFieldName + " - " + cfClauseValue.getClauseNameValue();
                visibleNames.put(displayName, cfClauseValue);
            }
        }
        ArrayList visibleNamesList = new ArrayList(visibleNames.keySet());
        Collections.sort(visibleNamesList, new LocaleSensitiveStringComparator(locale));
        JSONArray jSONArray = new JSONArray();
        for (String fieldName : visibleNamesList) {
            JSONObject jsonObj = new JSONObject();
            ClauseNameValue clauseNameValue = (ClauseNameValue)visibleNames.get(fieldName);
            jsonObj.put("value", (Object)this.jqlStringSupport.encodeFieldName(clauseNameValue.getClauseNameValue()));
            jsonObj.put("displayName", (Object)this.htmlEncode(fieldName));
            if (clauseNameValue.isAutoCompleteable()) {
                jsonObj.put("auto", (Object)"true");
            }
            if (clauseNameValue.isOrderByable()) {
                jsonObj.put("orderable", (Object)"true");
            }
            if (clauseNameValue.isSearchable()) {
                jsonObj.put("searchable", (Object)"true");
            }
            if (clauseNameValue.getCustomFieldIdClauseName() != null) {
                jsonObj.put("cfid", (Object)clauseNameValue.getCustomFieldIdClauseName());
            }
            JSONArray supOpers = new JSONArray();
            for (Operator operator : clauseNameValue.getSupportedOperators()) {
                supOpers.put((Object)operator.getDisplayString());
            }
            jsonObj.put("operators", (Object)supOpers);
            JSONArray supportedTypes = new JSONArray();
            for (String typeString : clauseNameValue.getSupportedType().asStrings()) {
                supportedTypes.put((Object)typeString);
            }
            jsonObj.put("types", (Object)supportedTypes);
            jSONArray.put((Object)jsonObj);
        }
        return jSONArray.toString();
    }

    private boolean isJqlPropertyClauseFieldName(ClauseInformation information) {
        return information instanceof AliasClauseInformation;
    }

    public String getVisibleFunctionNamesJson(ApplicationUser user, Locale locale) throws JSONException {
        List<String> functionNames = this.jqlFunctionHandlerRegistry.getAllFunctionNames();
        Collections.sort(functionNames, new LocaleSensitiveStringComparator(locale));
        JSONArray results = new JSONArray();
        for (String functionName : functionNames) {
            if ("currentUser".equals(functionName) && user == null) continue;
            final FunctionOperandHandler functionHandler = this.jqlFunctionHandlerRegistry.getOperandHandler(new FunctionOperand(functionName));
            JSONObject jsonObj = new JSONObject();
            Option minArgumentsFromPlugin = SafePluginPointAccess.call((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return functionHandler.getJqlFunction().getMinimumNumberOfExpectedArguments();
                }
            });
            if (minArgumentsFromPlugin.isEmpty()) continue;
            int minArguments = (Integer)minArgumentsFromPlugin.get();
            StringBuilder argPart = new StringBuilder("(");
            for (int i = 0; i < minArguments; ++i) {
                if (i != 0) {
                    argPart.append(", ");
                }
                argPart.append("\"\"");
            }
            argPart.append(")");
            jsonObj.put("value", (Object)(this.jqlStringSupport.encodeFunctionName(functionName) + argPart.toString()));
            jsonObj.put("displayName", (Object)(this.htmlEncode(functionName) + argPart.toString()));
            if (functionHandler.isList()) {
                jsonObj.put("isList", (Object)"true");
            }
            JSONArray functionTypes = new JSONArray();
            for (String typeString : (Collection)SafePluginPointAccess.call((Callable)new Callable<Collection<String>>(){

                @Override
                public Collection<String> call() throws Exception {
                    return functionHandler.getJqlFunction().getDataType().asStrings();
                }
            }).getOrElse(Collections.emptyList())) {
                functionTypes.put((Object)typeString);
            }
            jsonObj.put("types", (Object)functionTypes);
            results.put((Object)jsonObj);
        }
        return results.toString();
    }

    public String getJqlReservedWordsJson() throws JSONException {
        Set reservedWords = this.jqlStringSupport.getJqlReservedWords();
        JSONArray results = new JSONArray();
        for (String reservedWord : reservedWords) {
            results.put((Object)reservedWord);
        }
        return results.toString();
    }

    String htmlEncode(String string) {
        return TextUtils.htmlEncode((String)string);
    }

    private boolean isCustomFieldClauseNames(ClauseNames clauseNames) {
        for (String clauseName : clauseNames.getJqlFieldNames()) {
            if (!JqlCustomFieldId.isJqlCustomFieldId((String)clauseName)) continue;
            return true;
        }
        return false;
    }

    private static class ClauseNameValue {
        private final String clauseNameValue;
        private final String customFieldIdClauseName;
        private final boolean autoCompleteable;
        private final boolean orderByable;
        private final boolean searchable;
        private final boolean mustUseNameValue;
        private final Set<Operator> supportedOperators;
        private final JiraDataType supportedType;

        private ClauseNameValue(String clauseNameValue, boolean isAutoCompleteable, boolean isOrderByable, boolean isSearchable, boolean mustUseNameValue, Set<Operator> supportedOperators, JiraDataType supportedType) {
            this.clauseNameValue = clauseNameValue;
            this.autoCompleteable = isAutoCompleteable;
            this.orderByable = isOrderByable;
            this.searchable = isSearchable;
            this.mustUseNameValue = mustUseNameValue;
            this.supportedOperators = supportedOperators;
            this.supportedType = supportedType;
            this.customFieldIdClauseName = null;
        }

        private ClauseNameValue(String clauseNameValue, String customFieldIdClauseName, boolean isAutoCompleteable, boolean isOrderByable, boolean isSearchable, boolean mustUseNameValue, Set<Operator> supportedOperators, JiraDataType supportedType) {
            this.clauseNameValue = clauseNameValue;
            this.customFieldIdClauseName = customFieldIdClauseName;
            this.autoCompleteable = isAutoCompleteable;
            this.orderByable = isOrderByable;
            this.searchable = isSearchable;
            this.mustUseNameValue = mustUseNameValue;
            this.supportedOperators = supportedOperators;
            this.supportedType = supportedType;
        }

        public String getClauseNameValue() {
            return this.clauseNameValue;
        }

        public String getCustomFieldIdClauseName() {
            return this.customFieldIdClauseName;
        }

        public boolean isAutoCompleteable() {
            return this.autoCompleteable;
        }

        public boolean isOrderByable() {
            return this.orderByable;
        }

        public boolean isMustUseNameValue() {
            return this.mustUseNameValue;
        }

        public boolean isSearchable() {
            return this.searchable;
        }

        public Set<Operator> getSupportedOperators() {
            return this.supportedOperators;
        }

        public JiraDataType getSupportedType() {
            return this.supportedType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClauseNameValue that = (ClauseNameValue)o;
            if (this.autoCompleteable != that.autoCompleteable) {
                return false;
            }
            if (this.mustUseNameValue != that.mustUseNameValue) {
                return false;
            }
            if (this.orderByable != that.orderByable) {
                return false;
            }
            if (this.searchable != that.searchable) {
                return false;
            }
            if (this.clauseNameValue != null ? !this.clauseNameValue.equals(that.clauseNameValue) : that.clauseNameValue != null) {
                return false;
            }
            if (this.customFieldIdClauseName != null ? !this.customFieldIdClauseName.equals(that.customFieldIdClauseName) : that.customFieldIdClauseName != null) {
                return false;
            }
            if (this.supportedOperators != null ? !this.supportedOperators.equals(that.supportedOperators) : that.supportedOperators != null) {
                return false;
            }
            return !(this.supportedType != null ? !this.supportedType.equals(that.supportedType) : that.supportedType != null);
        }

        public int hashCode() {
            int result = this.clauseNameValue != null ? this.clauseNameValue.hashCode() : 0;
            result = 31 * result + (this.customFieldIdClauseName != null ? this.customFieldIdClauseName.hashCode() : 0);
            result = 31 * result + (this.autoCompleteable ? 1 : 0);
            result = 31 * result + (this.orderByable ? 1 : 0);
            result = 31 * result + (this.searchable ? 1 : 0);
            result = 31 * result + (this.mustUseNameValue ? 1 : 0);
            result = 31 * result + (this.supportedOperators != null ? this.supportedOperators.hashCode() : 0);
            result = 31 * result + (this.supportedType != null ? this.supportedType.hashCode() : 0);
            return result;
        }
    }

    private static class AliasClauseNameValue {
        private final ClauseNameValue clauseNameValue;
        private final AliasClauseInformation information;

        private AliasClauseNameValue(ClauseNameValue clauseNameValue, AliasClauseInformation information) {
            this.clauseNameValue = clauseNameValue;
            this.information = information;
        }

        public ClauseNameValue getClauseNameValue() {
            return this.clauseNameValue;
        }

        public AliasClauseInformation getInformation() {
            return this.information;
        }
    }
}

