/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.core.util.DataUtils;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.dataimport.ExportService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.action.setup.DevModeSecretSauce;
import com.atlassian.jira.web.action.util.DataCleaner;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class XmlBackup
extends ProjectActionSupport {
    private static final String CONFIRM = "confirm";
    private static final String FIX_INVALID_XML_CHARACTERS = "fixchars";
    private String filename;
    private String destinationFile;
    boolean confirm = false;
    private final DevModeSecretSauce devModeSecretSauce;
    private final ExportService exportService;

    public XmlBackup(ExportService exportService, JiraProperties jiraSystemProperties) {
        this.exportService = exportService;
        this.devModeSecretSauce = new DevModeSecretSauce(jiraSystemProperties);
    }

    protected void doValidation() {
        if (StringUtils.isBlank((String)this.filename)) {
            this.addError("filename", this.getText("admin.errors.export.must.enter.file.location"));
        } else {
            File safeBackupPath = this.getSafeBackupPath();
            try {
                new File(safeBackupPath, this.filename).getCanonicalFile();
            }
            catch (IOException e) {
                this.addError("filename", this.getText("admin.errors.export.file.invalid", this.filename));
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            ServiceOutcome<Void> outcome;
            if (TextUtils.stringSet((String)this.filename)) {
                this.filename = this.devModeSecretSauce.isBoneFideJiraDeveloper() ? DataUtils.getXmlFilename((String)this.filename.trim()) : DataUtils.getZipFilename((String)this.filename.trim());
                File safeBackupPath = this.getSafeBackupPath();
                File potentialFile = new File(this.filename);
                File potentiaSafeFile = new File(safeBackupPath, potentialFile.getName());
                if (this.devModeSecretSauce.isBoneFideJiraDeveloper() && potentialFile.isAbsolute()) {
                    potentiaSafeFile = potentialFile;
                }
                this.destinationFile = potentiaSafeFile.getAbsoluteFile().toString();
                if (potentiaSafeFile.exists()) {
                    if (!potentiaSafeFile.canWrite()) {
                        this.addError("filename", this.getText("admin.errors.export.file.exists.unwriteable", "'" + this.destinationFile + "'"));
                        return this.getResult();
                    }
                    if (!this.confirm) {
                        return CONFIRM;
                    }
                }
                this.filename = this.destinationFile;
                this.log.warn((Object)String.format("The filename that will be used for exporting is: '%s'", this.filename));
            }
            if ((outcome = this.devModeSecretSauce.isBoneFideJiraDeveloper() ? this.exportService.exportForDevelopment(this.getLoggedInUser(), this.filename, TaskProgressSink.NULL_SINK) : this.exportService.export(this.getLoggedInUser(), this.filename, TaskProgressSink.NULL_SINK)).isValid()) {
                return "success";
            }
            this.addErrors(outcome.getErrorCollection().getErrors());
            this.addErrorMessages(outcome.getErrorCollection().getErrorMessages());
            if (outcome.getErrorCollection().getReasons().contains(ErrorCollection.Reason.VALIDATION_FAILED)) {
                return FIX_INVALID_XML_CHARACTERS;
            }
            return "error";
        }
        catch (Exception e) {
            this.log.error((Object)("Exception occurred backing up: " + e), (Throwable)e);
            this.addErrorMessage(TextUtils.plainTextToHtml((String)this.getText("admin.errors.export.exception.occured.backing.up", e)));
            return "error";
        }
    }

    public String doFixChars() throws Exception {
        OfBizDelegator ofBizDelegator = (OfBizDelegator)ComponentAccessor.getComponent(OfBizDelegator.class);
        ApplicationProperties applicationProperties = (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
        DataCleaner dataCleaner = new DataCleaner(applicationProperties, ofBizDelegator);
        dataCleaner.clean();
        return "input";
    }

    public File getSafeBackupPath() {
        return new File(this.jiraHome().getHome(), "export").getAbsoluteFile();
    }

    JiraHome jiraHome() {
        return (JiraHome)ComponentAccessor.getComponentOfType(JiraHome.class);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        if (TextUtils.stringSet((String)filename)) {
            this.filename = filename;
        }
    }

    public String getDestinationFile() {
        return this.destinationFile;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

