/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataCleaner {
    private static final Logger log = LoggerFactory.getLogger(DataCleaner.class);
    private ApplicationProperties applicationProperties;
    private OfBizDelegator ofBizDelegator;

    DataCleaner(ApplicationProperties applicationProperties, OfBizDelegator ofBizDelegator) {
        this.applicationProperties = applicationProperties;
        this.ofBizDelegator = ofBizDelegator;
    }

    void clean() throws DataAccessException {
        List issues = this.ofBizDelegator.findAll("Issue");
        List comments = this.ofBizDelegator.findByAnd("Action", (Map)FieldMap.build((String)"type", (Object)"comment"));
        for (GenericValue issue : issues) {
            this.escapeField(issue, "summary");
            this.escapeField(issue, "environment");
            this.escapeField(issue, "description");
            List changeGroups = this.ofBizDelegator.findByAnd("ChangeGroup", (Map)FieldMap.build((String)"issue", (Object)issue.getLong("id")), Arrays.asList("created"));
            for (GenericValue changeGroup : changeGroups) {
                for (GenericValue changeItem : this.ofBizDelegator.getRelated("ChildChangeItem", changeGroup)) {
                    this.escapeField(changeItem, "oldstring");
                    this.escapeField(changeItem, "newstring");
                }
            }
        }
        for (Object comment : comments) {
            this.escapeField((GenericValue)comment, "body");
        }
        List customFieldValues = this.ofBizDelegator.findAll("CustomFieldValue");
        for (GenericValue customFieldValue : customFieldValues) {
            this.escapeField(customFieldValue, "stringvalue");
        }
        List changeItems = this.ofBizDelegator.findAll("ChangeItem");
        for (GenericValue changeItem : changeItems) {
            this.escapeField(changeItem, "oldstring");
            this.escapeField(changeItem, "newstring");
        }
    }

    private String getEncoding() {
        try {
            return this.applicationProperties.getEncoding();
        }
        catch (Exception e) {
            return "UTF-8";
        }
    }

    private String escapeString(String s) {
        return StringUtils.escapeCP1252((String)s, (String)this.getEncoding());
    }

    private void escapeField(GenericValue gv, String fieldName) {
        String escapedValue;
        String fieldValue = gv.getString(fieldName);
        if (TextUtils.stringSet((String)fieldValue) && !fieldValue.equals(escapedValue = this.escapeString(fieldValue))) {
            gv.set(fieldName, (Object)this.escapeString(fieldValue));
            try {
                CoreFactory.getGenericDelegator().storeAll(Arrays.asList(gv));
            }
            catch (GenericEntityException e) {
                log.error("Error storing entity " + gv + " while escaping field " + fieldName, (Throwable)e);
            }
        }
    }
}

