/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class DeleteProject
extends IssueActionSupport {
    private boolean confirm;
    private Long pid;
    private final ProjectService projectService;
    private Project project;

    public DeleteProject(IssueManager issueManager, CustomFieldManager customFieldManager, AttachmentManager attachmentManager, ProjectManager projectManager, PermissionManager permissionManager, VersionManager versionManager, ProjectService projectService, UserIssueHistoryManager userHistoryManager, TimeTrackingConfiguration timeTrackingConfiguration) {
        super(issueManager, customFieldManager, attachmentManager, projectManager, permissionManager, versionManager, userHistoryManager, timeTrackingConfiguration);
        this.projectService = projectService;
    }

    protected void doValidation() {
        Project projectObject = this.getProject();
        if (projectObject == null) {
            this.addErrorMessage(this.getText("admin.deleteproject.error.no.project", this.pid));
            return;
        }
        ProjectService.DeleteProjectValidationResult result = this.projectService.validateDeleteProject(this.getLoggedInUser(), projectObject.getKey());
        if (!result.isValid()) {
            this.addErrorCollection(result.getErrorCollection());
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            ProjectService.DeleteProjectValidationResult result = this.projectService.validateDeleteProject(this.getLoggedInUser(), this.getProject().getKey());
            ProjectService.DeleteProjectResult projectResult = this.projectService.deleteProject(this.getLoggedInUser(), result);
            if (!projectResult.isValid()) {
                this.addErrorCollection(projectResult.getErrorCollection());
                return "error";
            }
        }
        return this.getResult();
    }

    public Project getProject() {
        if (this.project == null) {
            this.project = this.getProjectManager().getProjectObj(this.pid);
        }
        return this.project;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
}

