/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachment;
import com.atlassian.jira.util.ExceptionUtil;
import com.atlassian.jira.web.action.issue.TemporaryWebAttachmentsMonitor;
import com.atlassian.util.concurrent.Effect;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultTemporaryWebAttachmentsMonitor
implements HttpSessionBindingListener,
TemporaryWebAttachmentsMonitor {
    private static final Logger log = LoggerFactory.getLogger(DefaultTemporaryWebAttachmentsMonitor.class);
    private final ConcurrentMap<String, TemporaryWebAttachment> temporaryAttachments = new ConcurrentHashMap<String, TemporaryWebAttachment>();
    private final StreamAttachmentStore attachmentStore;

    public DefaultTemporaryWebAttachmentsMonitor(StreamAttachmentStore attachmentStore) {
        this.attachmentStore = attachmentStore;
    }

    @Override
    public Option<TemporaryWebAttachment> getById(String temporaryAttachmentId) {
        return Option.option(this.temporaryAttachments.get(temporaryAttachmentId));
    }

    @Override
    public Option<TemporaryWebAttachment> removeById(String temporaryAttachmentId) {
        return Option.option(this.temporaryAttachments.remove(temporaryAttachmentId));
    }

    @Override
    public void add(TemporaryWebAttachment temporaryAttachment) {
        Preconditions.checkNotNull((Object)temporaryAttachment, (Object)"temporaryAttachment");
        String stringId = (String)Preconditions.checkNotNull((Object)temporaryAttachment.getStringId(), (Object)"attachmentStringId");
        if (this.temporaryAttachments.putIfAbsent(stringId, temporaryAttachment) != null) {
            throw new IllegalArgumentException(String.format("Temporary attachment with id='%s' already in monitor", stringId));
        }
    }

    @Override
    public Collection<TemporaryWebAttachment> getByFormToken(final String formToken) {
        Preconditions.checkNotNull((Object)formToken);
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.temporaryAttachments.values(), (Predicate)new Predicate<TemporaryWebAttachment>(){

            public boolean apply(TemporaryWebAttachment attachment) {
                return formToken.equals(attachment.getFormToken());
            }
        }));
    }

    @Override
    public void cleanByFormToken(String formToken) {
        for (TemporaryWebAttachment temporaryWebAttachment : this.getByFormToken(formToken)) {
            this.safelyRemoveTemporaryAttachmentFromStore(temporaryWebAttachment);
            this.temporaryAttachments.remove(temporaryWebAttachment.getStringId());
        }
    }

    private void safelyRemoveTemporaryAttachmentFromStore(TemporaryWebAttachment temporaryWebAttachment) {
        this.attachmentStore.deleteTemporaryAttachment(temporaryWebAttachment.getTemporaryAttachmentId()).fail((Effect)new Effect<Throwable>(){

            public void apply(Throwable throwable) {
                ExceptionUtil.logExceptionWithWarn(log, "Got exception while removing temporary attachment.", throwable);
            }
        });
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        for (Map.Entry entry : this.temporaryAttachments.entrySet()) {
            this.safelyRemoveTemporaryAttachmentFromStore((TemporaryWebAttachment)entry.getValue());
        }
        this.temporaryAttachments.clear();
    }
}

