/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.CreateIssueDetails;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class CloneIssueDetails
extends CreateIssueDetails {
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final IssueLinkManager issueLinkManager;
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final SubTaskManager subTaskManager;
    private final AttachmentManager attachmentManager;
    private final FieldManager fieldManager;
    private final IssueFactory issueFactory;
    private IssueLinkType cloneIssueLinkType;
    private String cloneIssueLinkTypeName;
    private MutableIssue issueObject;
    private Issue originalIssue;
    private Issue cloneParent;
    private boolean cloneLinks;
    private boolean cloneSubTasks;
    private boolean cloneAttachments;
    private final Map<Long, Long> newIssueIdMap = new HashMap<Long, Long>();
    private static final String BROWSE_ISSUE_PAGE_PREFIX = "/browse/";

    public CloneIssueDetails(ApplicationProperties applicationProperties, PermissionManager permissionManager, IssueLinkManager issueLinkManager, RemoteIssueLinkManager remoteIssueLinkManager, IssueLinkTypeManager issueLinkTypeManager, SubTaskManager subTaskManager, AttachmentManager attachmentManager, FieldManager fieldManager, IssueCreationHelperBean issueCreationHelperBean, IssueFactory issueFactory, IssueService issueService, TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator) {
        super(issueFactory, issueCreationHelperBean, issueService, temporaryAttachmentsMonitorLocator);
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.issueLinkManager = issueLinkManager;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.subTaskManager = subTaskManager;
        this.attachmentManager = attachmentManager;
        this.fieldManager = fieldManager;
        this.issueFactory = issueFactory;
    }

    @Override
    public String doDefault() throws Exception {
        this.cloneSubTasks = true;
        this.cloneLinks = false;
        this.cloneAttachments = false;
        try {
            this.setOriginalIssue(this.getIssueObject(this.getIssue()));
            this.copySummaryFieldFromOriginalIssueToHolder();
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return "input";
    }

    private void copySummaryFieldFromOriginalIssueToHolder() throws GenericEntityException {
        String summary = this.getOriginalIssue().getSummary();
        if (StringUtils.isNotBlank((String)summary)) {
            String clonePrefixProperties = this.applicationProperties.getDefaultBackedString("jira.clone.prefix");
            String cloneSummary = StringUtils.isBlank((String)clonePrefixProperties) ? summary : StringUtils.join((Object[])new Object[]{clonePrefixProperties, summary}, (String)" ");
            this.getFieldValuesHolder().put("summary", cloneSummary);
        }
    }

    public FieldScreenRenderLayoutItem getFieldScreenRenderLayoutItem(String fieldId) {
        return this.getFieldScreenRenderer().getFieldScreenRenderLayoutItem(this.fieldManager.getOrderableField(fieldId));
    }

    public Issue getIssueObject(GenericValue genericValue) {
        return this.issueFactory.getIssue(genericValue);
    }

    @Override
    public MutableIssue getIssueObject() {
        if (this.issueObject == null) {
            this.issueObject = this.issueFactory.cloneIssue(this.getOriginalIssue());
        }
        return this.issueObject;
    }

    @Override
    protected void doValidation() {
        try {
            this.setOriginalIssue(this.getIssueObject(this.getIssue()));
        }
        catch (IssuePermissionException ipe) {
            return;
        }
        catch (IssueNotFoundException infe) {
            return;
        }
        this.setPid(this.getOriginalIssue().getProject().getLong("id"));
        this.getIssueObject().setProjectObject(this.getProjectObject());
        this.setIssuetype(this.getOriginalIssue().getIssueTypeId());
        this.getIssueObject().setIssueType(this.getIssueType());
        SummarySystemField summaryField = (SummarySystemField)this.fieldManager.getOrderableField("summary");
        Map<String, Object> map = this.getFieldValuesHolder();
        ActionContext.getContext();
        summaryField.populateFromParams(map, ActionContext.getParameters());
        summaryField.validateParams(this, (ErrorCollection)this, (I18nHelper)this, (Issue)this.getIssueObject(), this.getFieldScreenRenderLayoutItem("summary"));
    }

    private void prepareForCloningIssue() {
        this.setNotCloningFieldsToBlankByDefault();
        this.cloneSomeFieldsFromOriginalIssue();
    }

    private void setNotCloningFieldsToBlankByDefault() {
        this.getIssueObject().setCreated(null);
        this.getIssueObject().setUpdated(null);
        this.getIssueObject().setVotes(null);
        this.getIssueObject().setWatches(Long.valueOf(0L));
        this.getIssueObject().setStatus(null);
        this.getIssueObject().setWorkflowId(null);
        this.getIssueObject().setEstimate(this.getOriginalIssue().getOriginalEstimate());
        this.getIssueObject().setTimeSpent(null);
        this.getIssueObject().setResolutionDate(null);
        if (!this.isCanModifyReporter()) {
            this.getIssueObject().setReporter(this.getLoggedInUser());
        }
    }

    private void cloneSomeFieldsFromOriginalIssue() {
        this.getIssueObject().setSummary((String)this.getFieldValuesHolder().get("summary"));
        this.getIssueObject().setFixVersions(this.withoutArchivedVersions(this.getOriginalIssue().getFixVersions()));
        this.getIssueObject().setAffectedVersions(this.withoutArchivedVersions(this.getOriginalIssue().getAffectedVersions()));
        List<CustomField> customFields = this.getCustomFields(this.getOriginalIssue());
        for (CustomField customField : customFields) {
            Object value = customField.getValue(this.getOriginalIssue());
            if (value == null) continue;
            this.getIssueObject().setCustomFieldValue(customField, value);
        }
    }

    private Collection withoutArchivedVersions(Collection<Version> versions) {
        ArrayList<Version> notArchivedVersions = new ArrayList<Version>();
        for (Version version : versions) {
            if (version.isArchived()) continue;
            notArchivedVersions.add(version);
        }
        return notArchivedVersions;
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() {
        try {
            this.prepareForCloningIssue();
            super.createIssue();
            if (super.hasAnyErrors()) {
                return "error";
            }
            this.cloneIssue();
            return this.doPostCreationTasks();
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.exception") + " " + e);
            return "error";
        }
    }

    void cloneIssue() throws Exception {
        Issue cloneIssue = this.getIssueObject(super.getIssue());
        this.linkCloningIssueToOriginalOne(cloneIssue);
        this.cloneAttachmentsIfNeeded(cloneIssue);
        Set<Long> originalIssueIdSet = this.idsOfOriginalIssueIncludingSubTaskIfNeeded();
        this.cloneLinksIfNeeded(cloneIssue, originalIssueIdSet);
        if (this.isCloningSubTask()) {
            this.linkCloningSubTaskToOriginalSubTaskParent();
        } else {
            this.setCloneParent((Issue)this.getIssueObject());
            this.cloneSubTasksIfNeeded(originalIssueIdSet);
        }
    }

    private Set<Long> idsOfOriginalIssueIncludingSubTaskIfNeeded() {
        HashSet<Long> originalIssues = new HashSet<Long>();
        originalIssues.add(this.originalIssue.getId());
        if (this.subTaskManager.isSubTasksEnabled() && this.isCloneSubTasks()) {
            for (Issue subTask : this.originalIssue.getSubTaskObjects()) {
                originalIssues.add(subTask.getId());
            }
        }
        return originalIssues;
    }

    public boolean isDisplayCopyLink() {
        if (this.issueLinkManager.isLinkingEnabled()) {
            if (this.givenIssueHasAnyCopyableLink(this.getOriginalIssue())) {
                return true;
            }
            if (this.originalIssueHasSubTask()) {
                for (Issue subTask : this.getOriginalIssue().getSubTaskObjects()) {
                    if (!this.givenIssueHasAnyCopyableLink(subTask)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void cloneLinksIfNeeded(Issue clone, Set<Long> originalIssueIdSet) throws CreateException {
        if (this.isCloneLinks() && this.issueLinkManager.isLinkingEnabled()) {
            List inwardLinks = this.issueLinkManager.getInwardLinks(this.originalIssue.getId());
            this.cloneInwardLinks(clone, originalIssueIdSet, inwardLinks);
            List outwardLinks = this.issueLinkManager.getOutwardLinks(this.originalIssue.getId());
            this.cloneOutwardLinks(clone, originalIssueIdSet, outwardLinks);
            this.cloneRemoteIssueLinks(clone);
        }
    }

    private void cloneAttachmentsIfNeeded(Issue clone) throws CreateException {
        if (this.isCloneAttachments() && this.attachmentManager.attachmentsEnabled()) {
            Map result = this.attachmentManager.copyAttachments(this.originalIssue, this.getLoggedInUser(), clone.getKey());
            for (Either either : result.values()) {
                if (!either.isLeft()) continue;
                AttachmentError error = (AttachmentError)either.left().get();
                this.log.warn((Object)error.getLogMessage(), (Throwable)error.getException().getOrNull());
            }
        }
    }

    public boolean isDisplayCopyAttachments() {
        if (this.attachmentManager.attachmentsEnabled()) {
            if (this.givenIssueHasAnyAttachment(this.originalIssue)) {
                return true;
            }
            if (this.subTaskManager.isSubTasksEnabled() && this.originalIssueHasSubTask()) {
                for (Issue subTask : this.originalIssue.getSubTaskObjects()) {
                    if (!this.givenIssueHasAnyAttachment(subTask)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isDisplayCopySubTasks() {
        return this.subTaskManager.isSubTasksEnabled() && this.originalIssueHasSubTask();
    }

    private boolean givenIssueHasAnyCopyableLink(Issue issue) {
        List inwardLinks = this.issueLinkManager.getInwardLinks(issue.getId());
        if (this.hasAnyCopyableLinkInGivenLinks(inwardLinks)) {
            return true;
        }
        List outwardLinks = this.issueLinkManager.getOutwardLinks(issue.getId());
        return this.hasAnyCopyableLinkInGivenLinks(outwardLinks);
    }

    private boolean originalIssueHasSubTask() {
        return CollectionUtils.isNotEmpty((Collection)this.getOriginalIssue().getSubTaskObjects());
    }

    private boolean isCopyableLink(IssueLink checkingLink) {
        return !checkingLink.isSystemLink() && (this.getCloneIssueLinkType() == null || this.givenLinkTypeIsNotSameAsCloneIssueLinkType(checkingLink));
    }

    public boolean isCloneLinks() {
        return this.cloneLinks;
    }

    public void setCloneLinks(boolean cloneLinks) {
        this.cloneLinks = cloneLinks;
    }

    public boolean isCloneSubTasks() {
        return this.cloneSubTasks;
    }

    public void setCloneSubTasks(boolean cloneSubTasks) {
        this.cloneSubTasks = cloneSubTasks;
    }

    public boolean isCloneAttachments() {
        return this.cloneAttachments;
    }

    public void setCloneAttachments(boolean cloneAttachments) {
        this.cloneAttachments = cloneAttachments;
    }

    @Override
    protected String doPostCreationTasks() throws Exception {
        if (this.getCloneParent() != null) {
            return this.inlineRedirectToIssueWithKey(this.getCloneParent().getString("key"));
        }
        return this.inlineRedirectToIssueWithKey(this.getIssue().getString("key"));
    }

    private void cloneSubTasksIfNeeded(Set<Long> originalIssueIdSet) throws Exception {
        if (this.subTaskManager.isSubTasksEnabled() && this.isCloneSubTasks()) {
            for (Issue subTaskIssue : this.originalIssue.getSubTaskObjects()) {
                this.setOriginalIssue(subTaskIssue);
                this.issueObject = null;
                this.validationResult = null;
                this.copySummaryFieldFromOriginalIssueToHolder();
                this.prepareForCloningIssue();
                this.getIssueObject().setParentId(this.cloneParent.getLong("id"));
                super.createIssue();
                if (!super.hasAnyErrors()) {
                    Issue newSubTask = this.getIssueObject(this.getIssue());
                    this.newIssueIdMap.put(this.getOriginalIssue().getId(), newSubTask.getId());
                    this.cloneLinksIfNeeded(newSubTask, originalIssueIdSet);
                    this.subTaskManager.createSubTaskIssueLink(this.cloneParent, (Issue)this.getIssueObject(), this.getLoggedInUser());
                    this.cloneAttachmentsIfNeeded(newSubTask);
                    continue;
                }
                for (Object message : super.getErrorMessages()) {
                    this.log.warn((Object)("Could not create subtask for issue: " + this.cloneParent.getKey() + ", validation error has occured: " + message));
                }
            }
        }
    }

    public Issue getOriginalIssue() {
        return this.originalIssue;
    }

    public void setOriginalIssue(Issue originalIssue) {
        this.originalIssue = originalIssue;
    }

    public Issue getCloneParent() {
        return this.cloneParent;
    }

    public void setCloneParent(Issue cloneParent) {
        this.cloneParent = cloneParent;
    }

    public IssueLinkType getCloneIssueLinkType() {
        if (this.cloneIssueLinkType == null) {
            Collection cloneIssueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypesByName(this.getCloneLinkTypeName());
            if (StringUtils.isBlank((String)this.getCloneLinkTypeName())) {
                this.cloneIssueLinkType = null;
            } else if (CollectionUtils.isEmpty((Collection)cloneIssueLinkTypes)) {
                this.log.warn((Object)("The clone link type '" + this.getCloneLinkTypeName() + "' does not exist. A link to the original issue will not be created."));
                this.cloneIssueLinkType = null;
            } else {
                for (IssueLinkType issueLinkType : cloneIssueLinkTypes) {
                    if (!issueLinkType.getName().equals(this.getCloneLinkTypeName())) continue;
                    this.cloneIssueLinkType = issueLinkType;
                }
            }
        }
        return this.cloneIssueLinkType;
    }

    public boolean isDisplayCloneLinkWarning() {
        return StringUtils.isNotBlank((String)this.getCloneLinkTypeName()) && this.getCloneIssueLinkType() == null;
    }

    public boolean isCanModifyReporter() {
        return this.permissionManager.hasPermission(30, (Issue)this.getIssueObject(), this.getLoggedInUser());
    }

    public String getCloneLinkTypeName() {
        if (this.cloneIssueLinkTypeName == null) {
            this.cloneIssueLinkTypeName = this.applicationProperties.getDefaultBackedString("jira.clone.linktype.name");
        }
        return this.cloneIssueLinkTypeName;
    }

    @Override
    public Project getProjectObject() {
        return this.getProjectManager().getProjectObj(this.getIssue().getLong("project"));
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }

    private void linkCloningIssueToOriginalOne(Issue cloneIssue) throws CreateException {
        this.newIssueIdMap.put(this.getOriginalIssue().getId(), cloneIssue.getId());
        IssueLinkType cloneIssueLinkType = this.getCloneIssueLinkType();
        if (cloneIssueLinkType != null) {
            this.issueLinkManager.createIssueLink(this.getIssue().getLong("id"), this.getOriginalIssue().getId(), cloneIssueLinkType.getId(), null, this.getLoggedInUser());
        }
    }

    private boolean isCloningSubTask() {
        return this.originalIssue.isSubTask();
    }

    private void linkCloningSubTaskToOriginalSubTaskParent() throws CreateException {
        Issue subTaskParent = this.originalIssue.getParentObject();
        this.subTaskManager.createSubTaskIssueLink(subTaskParent, (Issue)this.getIssueObject(), this.getLoggedInUser());
    }

    private void cloneInwardLinks(Issue cloneIssue, Set<Long> originalIssueIdSet, Collection<IssueLink> givenLinks) throws CreateException {
        this.cloningGivenIssueLinks(cloneIssue, originalIssueIdSet, givenLinks, true);
    }

    private void cloneOutwardLinks(Issue cloneIssue, Set<Long> originalIssueIdSet, Collection<IssueLink> givenLinks) throws CreateException {
        this.cloningGivenIssueLinks(cloneIssue, originalIssueIdSet, givenLinks, false);
    }

    private void cloningGivenIssueLinks(Issue cloneIssue, Set<Long> originalIssueIdSet, Collection<IssueLink> givenLinks, boolean isCopyingInwardLinks) throws CreateException {
        for (IssueLink issueLink : givenLinks) {
            Long workingIssueId;
            if (!this.isCopyableLink(issueLink)) continue;
            Long l = workingIssueId = isCopyingInwardLinks ? issueLink.getSourceId() : issueLink.getDestinationId();
            if (originalIssueIdSet.contains(workingIssueId)) {
                workingIssueId = this.newIssueIdMap.get(workingIssueId);
            }
            if (workingIssueId == null) continue;
            if (isCopyingInwardLinks) {
                this.log.debug((Object)("Creating inward link to " + cloneIssue.getKey() + " (cloned from " + this.originalIssue.getKey() + ", link " + issueLink + ")"));
                this.issueLinkManager.createIssueLink(workingIssueId, cloneIssue.getId(), issueLink.getIssueLinkType().getId(), null, this.getLoggedInUser());
                continue;
            }
            this.log.debug((Object)("Creating outward link from " + cloneIssue.getKey() + " (cloned from " + this.originalIssue.getKey() + ", link " + issueLink + ")"));
            this.issueLinkManager.createIssueLink(cloneIssue.getId(), workingIssueId, issueLink.getIssueLinkType().getId(), null, this.getLoggedInUser());
        }
    }

    private void cloneRemoteIssueLinks(Issue cloneIssue) throws CreateException {
        List originalLinks = this.remoteIssueLinkManager.getRemoteIssueLinksForIssue(this.originalIssue);
        for (RemoteIssueLink originalLink : originalLinks) {
            RemoteIssueLink link = new RemoteIssueLinkBuilder(originalLink).id(null).issueId(cloneIssue.getId()).build();
            this.remoteIssueLinkManager.createRemoteIssueLink(link, this.getLoggedInUser());
        }
    }

    private boolean hasAnyCopyableLinkInGivenLinks(Collection<IssueLink> givenLinks) {
        for (IssueLink checkingIssueLink : givenLinks) {
            if (!this.isCopyableLink(checkingIssueLink)) continue;
            return true;
        }
        return false;
    }

    private boolean givenLinkTypeIsNotSameAsCloneIssueLinkType(IssueLink checkingLink) {
        return !this.getCloneIssueLinkType().getId().equals(checkingLink.getIssueLinkType().getId());
    }

    private boolean givenIssueHasAnyAttachment(Issue givenIssue) {
        return CollectionUtils.isNotEmpty((Collection)this.attachmentManager.getAttachments(givenIssue));
    }

    private String inlineRedirectToIssueWithKey(String issueKey) {
        return super.returnCompleteWithInlineRedirect(BROWSE_ISSUE_PAGE_PREFIX + issueKey);
    }

    private static String nullSafeLoggedUsername(ApplicationUser loggedUser) {
        return loggedUser == null ? null : loggedUser.getUsername();
    }
}

