/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentsBulkOperationResult;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.atlassian.jira.web.action.issue.util.BackwardCompatibleTemporaryAttachmentUtil;
import com.atlassian.jira.web.action.message.ClosingPolicy;
import com.atlassian.jira.web.action.message.MessageResponder;
import com.atlassian.jira.web.action.message.PopUpMessage;
import com.atlassian.jira.web.action.message.PopUpMessageFactory;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.math.NumberUtils;
import org.ofbiz.core.entity.GenericValue;

public class AttachFile
extends AbstractCommentableIssue
implements OperationContext {
    private static final String ATTACHMENTS_VIEW = "ManageAttachments.jspa";
    private final Function<AttachmentError, PopUpMessage> ERROR_TO_MESSAGE = new Function<AttachmentError, PopUpMessage>(){

        public PopUpMessage apply(@Nullable AttachmentError error) {
            Preconditions.checkNotNull((Object)error, (Object)"error");
            String fileName = error.getFilename();
            String plainMessage = error.getLocalizedMessage();
            return AttachFile.this.messageFactory.createPlainMessage(JiraWebActionSupport.MessageType.ERROR, fileName, plainMessage, ClosingPolicy.MANUAL);
        }
    };
    private final AttachmentService attachmentService;
    private final IssueUpdater issueUpdater;
    private final BackwardCompatibleTemporaryAttachmentUtil temporaryAttachmentUtil;
    private final MessageResponder responder;
    private final PopUpMessageFactory messageFactory;
    private long maxSize = Long.MIN_VALUE;
    private String[] filetoconvert;

    public AttachFile(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, AttachmentService attachmentService, IssueUpdater issueUpdater, UserUtil userUtil, BackwardCompatibleTemporaryAttachmentUtil temporaryAttachmentUtil, MessageResponder responder, PopUpMessageFactory messageFactory) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.attachmentService = attachmentService;
        this.issueUpdater = issueUpdater;
        this.temporaryAttachmentUtil = temporaryAttachmentUtil;
        this.responder = responder;
        this.messageFactory = messageFactory;
    }

    public String doDefault() throws Exception {
        try {
            return this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), this.getIssueObject()) ? "input" : "error";
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
    }

    @Override
    protected void doValidation() {
        try {
            this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), this.getIssueObject());
            super.doValidation();
        }
        catch (IssueNotFoundException ex) {
            return;
        }
        catch (IssuePermissionException ex) {
            return;
        }
        List<String> temporaryAttachmentsIds = this.getTemporaryAttachmentsIds();
        if (temporaryAttachmentsIds.isEmpty()) {
            this.addError("tempFilename", this.getText("attachfile.error.filerequired"));
        } else if (!this.temporaryAttachmentUtil.allAttachmentsExists(temporaryAttachmentsIds)) {
            this.addError("tempFilename", this.getText("attachment.temporary.id.session.time.out"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        List<String> temporaryAttachmentsIds = this.getTemporaryAttachmentsIds();
        AttachmentsBulkOperationResult<ChangeItemBean> convertResult = this.temporaryAttachmentUtil.convertTemporaryAttachments(this.getLoggedInUser(), this.getIssueObject(), temporaryAttachmentsIds);
        List errors = convertResult.getErrors();
        List results = convertResult.getResults();
        IssueUpdateBean issueUpdateBean = this.createIssueUpdateBeanWithComment(results, this.createComment());
        this.issueUpdater.doUpdate(issueUpdateBean, true);
        this.temporaryAttachmentUtil.clearTemporaryAttachmentsByFormToken(this.getFormToken());
        ImmutableList messages = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)errors, this.ERROR_TO_MESSAGE));
        URI redirect = this.getRedirect();
        String title = this.getI18nHelper().getText("attachfile.title");
        return this.responder.respond((Iterable<PopUpMessage>)messages, redirect, (JiraWebActionSupport)this, title);
    }

    private URI getRedirect() {
        Map redirectParameters = MapBuilder.newBuilder().add((Object)"id", (Object)this.getIssue().getString("id")).add((Object)"atl_token", (Object)this.getXsrfToken()).toMap();
        UrlBuilder urlBuilder = new UrlBuilder(ATTACHMENTS_VIEW);
        urlBuilder.addParametersFromMap(redirectParameters);
        return urlBuilder.asURI();
    }

    private IssueUpdateBean createIssueUpdateBeanWithComment(List<ChangeItemBean> changeItems, @Nullable Comment comment) {
        GenericValue issueGV = this.getIssue();
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issueGV, issueGV, EventType.ISSUE_UPDATED_ID, this.getLoggedInUser());
        issueUpdateBean.setComment(comment);
        issueUpdateBean.setChangeItems(changeItems);
        issueUpdateBean.setDispatchEvent(true);
        issueUpdateBean.setParams(EasyMap.build((Object)"eventsource", (Object)"action"));
        return issueUpdateBean;
    }

    public String getTargetUrl() {
        return this.isInlineDialogMode() ? this.redirectToIssue() : this.redirectToAttachments();
    }

    private String redirectToAttachments() {
        return "ManageAttachments.jspa?id=" + this.getIssue().getLong("id");
    }

    private String redirectToIssue() {
        return this.getViewUrl();
    }

    public String[] getFiletoconvert() {
        return this.filetoconvert;
    }

    public void setFiletoconvert(String[] filetoconvert) {
        this.filetoconvert = filetoconvert;
    }

    public long getMaxSize() {
        if (this.maxSize != Long.MIN_VALUE) {
            return this.maxSize;
        }
        String maxSizeProperty = this.getApplicationProperties().getDefaultBackedString("webwork.multipart.maxSize");
        this.maxSize = NumberUtils.toLong((String)maxSizeProperty, (long)-1L);
        return this.maxSize;
    }

    public String getMaxSizePretty() {
        long maxSize = this.getMaxSize();
        if (maxSize > 0L) {
            return FileSize.format((long)maxSize);
        }
        return "Unknown?";
    }

    private List<String> getTemporaryAttachmentsIds() {
        return this.asList(this.getFiletoconvert());
    }

    private <T> List<T> asList(@Nullable T[] strings) {
        if (strings == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(strings);
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

