/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.BrowseProjectTypeManager;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeyFormatter;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.project.type.ProjectTypesDarkFeature;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.browser.ProjectTypeBean;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.seraph.util.RedirectUtils;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class BrowseProjects
extends JiraWebActionSupport {
    private final UserProjectHistoryManager projectHistoryManager;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final SimpleLinkManager simpleLinkManager;
    private final WebInterfaceManager webInterfaceManager;
    private final PageBuilderService pageBuilderService;
    private final UserFormats userFormats;
    private final ProjectTypeManager projectTypeManager;
    private final ProjectTypesDarkFeature projectTypesDarkFeature;
    private final BrowseProjectTypeManager browseProjectTypeManager;
    private static final String ALL = "all";
    private static final String NONE = "none";
    private static final String RECENT = "recent";
    private final Long PROJECT_DEFAULT_AVATAR_ID;
    private final Supplier<List<ProjectCategoryBean>> categories = Suppliers.memoize((Supplier)new Supplier<List<ProjectCategoryBean>>(){

        public List<ProjectCategoryBean> get() {
            Collection noCategoryProjects;
            ArrayList categories = Lists.newArrayList();
            Collection projectCategories = BrowseProjects.this.projectManager.getAllProjectCategories();
            for (ProjectCategory projectCategory : projectCategories) {
                Collection projects;
                if (projectCategory == null || (projects = BrowseProjects.this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, BrowseProjects.this.getLoggedInUser(), projectCategory)) == null || projects.isEmpty()) continue;
                categories.add(new ProjectCategoryBean(projectCategory));
            }
            if (!categories.isEmpty() && !(noCategoryProjects = BrowseProjects.this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, BrowseProjects.this.getLoggedInUser(), null)).isEmpty()) {
                categories.add(new ProjectCategoryBean(BrowseProjects.this.getText("browse.projects.none"), BrowseProjects.this.getText("browse.projects.none.desc"), BrowseProjects.NONE));
            }
            categories.add(new ProjectCategoryBean(BrowseProjects.this.getText("browse.projects.category.all"), BrowseProjects.this.getText("browse.projects.category.all.desc"), BrowseProjects.ALL));
            if (!((List)BrowseProjects.this.recentProjects.get()).isEmpty()) {
                categories.add(new ProjectCategoryBean(BrowseProjects.this.getText("browse.projects.recent"), BrowseProjects.this.getText("browse.projects.recent.desc"), BrowseProjects.RECENT));
            }
            return ImmutableList.copyOf((Collection)categories);
        }
    });
    private Supplier<List<ProjectBean>> projects = Suppliers.memoize((Supplier)new Supplier<List<ProjectBean>>(){

        public List<ProjectBean> get() {
            Collection allProjects = BrowseProjects.this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, BrowseProjects.this.getLoggedInUser());
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)allProjects, (Function)new Function<Project, ProjectBean>(){

                public ProjectBean apply(@Nullable Project project) {
                    if (project == null) {
                        return null;
                    }
                    return new ProjectBean(project, ((List)BrowseProjects.this.recentProjects.get()).contains(project));
                }
            }), (Predicate)Predicates.notNull()));
        }
    });
    private final Supplier<Map<String, ProjectTypeBean>> projectTypes = Suppliers.memoize((Supplier)new Supplier<Map<String, ProjectTypeBean>>(){

        public Map<String, ProjectTypeBean> get() {
            if (!BrowseProjects.this.projectTypesDarkFeature.isEnabled()) {
                return null;
            }
            return this.getProjectTypeBeans();
        }

        private Map<String, ProjectTypeBean> getProjectTypeBeans() {
            ArrayList projectTypes = Lists.newArrayList((Iterable)BrowseProjects.this.projectTypeManager.getAllProjectTypes());
            projectTypes.add(BrowseProjects.this.projectTypeManager.getInaccessibleProjectType());
            return projectTypes.stream().map(ProjectTypeBean::new).collect(Collectors.toMap(ProjectTypeBean::getKey, projectTypeBean -> projectTypeBean));
        }
    });
    private final Supplier<List<Project>> recentProjects = Suppliers.memoize((Supplier)new Supplier<List<Project>>(){

        public List<Project> get() {
            return ImmutableList.copyOf((Collection)BrowseProjects.this.projectHistoryManager.getProjectHistoryWithPermissionChecks(10, BrowseProjects.this.getLoggedInUser()));
        }
    });
    private String selectedCategory;
    private String selectedProjectType;
    private final Supplier<List<ProjectTypeBean>> availableProjectTypes = Suppliers.memoize((Supplier)new Supplier<List<ProjectTypeBean>>(){

        public List<ProjectTypeBean> get() {
            List allProjectTypes = BrowseProjects.this.convertToProjectTypeBeans(BrowseProjects.this.browseProjectTypeManager.getAllProjectTypes(BrowseProjects.this.getLoggedInUser()));
            allProjectTypes.add(new ProjectTypeBean(BrowseProjects.ALL, BrowseProjects.this.getText("browse.projects.all.project.type")));
            return allProjectTypes;
        }
    });

    private List<ProjectTypeBean> convertToProjectTypeBeans(List<ProjectType> projectTypes) {
        ArrayList<ProjectTypeBean> projectTypeBeans = new ArrayList<ProjectTypeBean>();
        for (ProjectType projectType : projectTypes) {
            projectTypeBeans.add(new ProjectTypeBean(projectType));
        }
        return projectTypeBeans;
    }

    public BrowseProjects(UserProjectHistoryManager projectHistoryManager, ProjectManager projectManager, PermissionManager permissionManager, SimpleLinkManager simpleLinkManager, WebInterfaceManager webInterfaceManager, AvatarManager avatarManager, PageBuilderService pageBuilderService, UserFormats userFormats, ProjectTypeManager projectTypeManager, BrowseProjectTypeManager browseProjectTypeManager, ProjectTypesDarkFeature projectTypesDarkFeature) {
        this.projectHistoryManager = projectHistoryManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.simpleLinkManager = simpleLinkManager;
        this.webInterfaceManager = webInterfaceManager;
        this.pageBuilderService = pageBuilderService;
        this.userFormats = userFormats;
        this.projectTypeManager = projectTypeManager;
        this.browseProjectTypeManager = browseProjectTypeManager;
        this.projectTypesDarkFeature = projectTypesDarkFeature;
        this.PROJECT_DEFAULT_AVATAR_ID = avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT);
    }

    protected String doExecute() throws Exception {
        if (!((List)this.projects.get()).isEmpty()) {
            this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:browseprojects");
            this.pageBuilderService.assembler().resources().requireContext("jira.browse");
            this.pageBuilderService.assembler().resources().requireContext("jira.browse.projects");
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:categories", this.getCategoriesJsonable());
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:projects", this.getProjectsJsonable());
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:projectTypes", this.getProjectTypesJsonable());
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:selectedCategory", this.getSelectedCategory());
            if (this.projectTypesDarkFeature.isEnabled()) {
                this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:availableProjectTypes", this.getAvailableProjectTypesJsonable());
                this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse:selectedProjectType", this.getSelectedProjectType());
            }
            return super.doExecute();
        }
        return "error";
    }

    @ActionViewData(value="success")
    public Collection<SimpleLink> getOperationLinks() {
        return this.simpleLinkManager.getLinksForSection("system.browse.projects.operations", this.getLoggedInUser(), this.getJiraHelper());
    }

    private JiraHelper getJiraHelper() {
        HashMap params = Maps.newHashMap();
        return new JiraHelper(ServletActionContext.getRequest(), null, (Map)params);
    }

    @ActionViewData(value="success")
    public String getInfoPanelHtml() {
        StringBuilder sb = new StringBuilder();
        List webPanelDescriptors = this.webInterfaceManager.getDisplayableWebPanelDescriptors("webpanels.browse.projects.info-panels", Collections.emptyMap());
        for (final WebPanelModuleDescriptor webPanelDescriptor : webPanelDescriptors) {
            Option result = SafePluginPointAccess.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ((WebPanel)webPanelDescriptor.getModule()).getHtml(Collections.emptyMap());
                }
            });
            if (!result.isDefined()) continue;
            sb.append((String)result.get());
        }
        return sb.toString();
    }

    @ActionViewData(value="error")
    public Collection<String> getErrorMessages() {
        ArrayList errors = Lists.newArrayList();
        if ("true".equals(this.getApplicationProperties().getString("jira.setup"))) {
            boolean projectsEmpty = this.projectManager.getProjectObjects().isEmpty();
            if (this.getLoggedInUser() == null && !projectsEmpty) {
                errors.add(this.getText("noprojects.notloggedin"));
                String loginLink = "<a href=\"" + RedirectUtils.getLinkLoginURL((HttpServletRequest)this.getHttpRequest()) + "\">" + this.getText("common.words.login") + "</a>";
                String logInOrSignup = this.getText("noprojects.mustfirstlogin", loginLink);
                if (JiraUtils.isPublicMode()) {
                    logInOrSignup = logInOrSignup + " " + this.getText("noprojects.signup", "<a href=\"" + this.getHttpRequest().getContextPath() + "/secure/Signup!default.jspa\">", "</a>");
                }
                errors.add(logInOrSignup);
            } else if (!projectsEmpty) {
                errors.add(this.getText("noprojects.nopermissions"));
                if (this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
                    String linkToProjectsAdminPage = this.getHttpRequest().getContextPath() + "/secure/admin/default.jsp";
                    errors.add(this.getText("noprojects.viewallprojects.message", "<a href=\"" + linkToProjectsAdminPage + "\">", "</a>"));
                } else {
                    errors.add(this.getText("noprojects.contactadmin.permissions", this.getAdministratorContactLink()));
                }
            } else {
                errors.add(this.getText("noprojects"));
                if (this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
                    errors.add("<a class=\"add-project-trigger\" href=\"" + this.getHttpRequest().getContextPath() + "/secure/project/ViewProjects.jspa\">" + this.getText("noprojects.createprojectnow.link") + "</a>");
                } else {
                    errors.add(this.getText("noprojects.contactadmin.permissions", this.getAdministratorContactLink()));
                }
            }
        } else {
            errors.add(this.getText("noprojects.mustsetupfirst"));
            errors.add(this.getText("noprojects.createadmintocreateotheradmins"));
            errors.add("<a href=\"" + this.getHttpRequest().getContextPath() + "/secure/Setup!default.jspa\">" + this.getText("noprojects.setupjira.link") + "</a>");
        }
        return errors;
    }

    public String getSelectedCategory() throws GenericEntityException {
        if (this.selectedCategory != null) {
            return this.selectedCategory;
        }
        String sessionCategory = this.getSession().get("jira.browse.projects.current.tab");
        if (ALL.equals(sessionCategory)) {
            return sessionCategory;
        }
        String returnKey = null;
        for (ProjectCategoryBean category : (List)this.categories.get()) {
            if (returnKey != null && !category.getId().equals(sessionCategory)) continue;
            returnKey = category.getId();
        }
        this.selectedCategory = returnKey == null ? ALL : returnKey;
        return this.selectedCategory;
    }

    public String getSelectedProjectType() throws GenericEntityException {
        if (this.selectedProjectType != null) {
            return this.selectedProjectType;
        }
        Option lastSelectedProjectType = Option.option((Object)this.getSession().get("jira.browse.projects.current.project.type"));
        return (String)lastSelectedProjectType.getOrElse((Object)ALL);
    }

    public void setSelectedProjectType(String selectedProjectType) {
        this.selectedProjectType = selectedProjectType;
    }

    private Map<String, String> getSession() {
        return ActionContext.getSession();
    }

    public Jsonable getCategoriesJsonable() throws GenericEntityException {
        return this.getJsonable(this.categories.get());
    }

    public Jsonable getProjectsJsonable() {
        return this.getJsonable(this.projects.get());
    }

    public Jsonable getProjectTypesJsonable() {
        return this.getJsonable(this.projectTypes.get());
    }

    public Jsonable getAvailableProjectTypesJsonable() {
        return this.getJsonable(this.availableProjectTypes.get());
    }

    private Jsonable getJsonable(Object entityToTransform) {
        return writer -> {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            mapper.writeValue(writer, entityToTransform);
        };
    }

    private static String convertCategoryToDescription(ProjectCategory category) {
        String name = category.getName();
        String desc = category.getDescription();
        if (StringUtils.isBlank((String)desc)) {
            return name;
        }
        return name + " - " + desc;
    }

    public boolean hasDefaultAvatar(Project project) {
        Long avatarId = project.getAvatar().getId();
        return avatarId == null || avatarId.equals(this.PROJECT_DEFAULT_AVATAR_ID);
    }

    public void setSelectedCategory(String selectedCategory) {
        this.selectedCategory = selectedCategory;
    }

    public Supplier<List<ProjectTypeBean>> getAvailableProjectTypes() {
        return this.availableProjectTypes;
    }

    public class ProjectCategoryBean {
        private final String name;
        private final String description;
        private final String id;

        public ProjectCategoryBean(ProjectCategory category) {
            this(category.getName(), BrowseProjects.convertCategoryToDescription(category), String.valueOf(category.getId()));
        }

        public ProjectCategoryBean(String name, String description, String id) {
            this.name = name;
            this.description = description;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getId() {
            return this.id;
        }
    }

    public class ProjectBean {
        private final String key;
        private final String name;
        private final Long id;
        private final boolean hasDefaultAvatar;
        private final boolean recent;
        private final String lead;
        private final String leadProfileLink;
        private final Long projectCategoryId;
        private final String url;
        private final String projectTypeKey;
        private final String projectTypeName;

        public ProjectBean(Project project, boolean recent) {
            this(project.getKey(), project.getName(), project.getId(), this$0.hasDefaultAvatar(project), project.getProjectLead(), project.getProjectCategoryObject(), recent, project.getUrl(), project.getProjectTypeKey());
        }

        public ProjectBean(String key, String name, Long id, boolean hasDefaultAvatar, ApplicationUser lead, ProjectCategory projectCategory, boolean recent, String url, ProjectTypeKey projectTypeKey) {
            this.key = key;
            this.name = name;
            this.id = id;
            this.hasDefaultAvatar = hasDefaultAvatar;
            this.recent = recent;
            this.projectTypeKey = projectTypeKey.getKey();
            this.projectTypeName = ProjectTypeKeyFormatter.format((ProjectTypeKey)projectTypeKey);
            if (lead != null) {
                this.lead = lead.getKey();
                this.leadProfileLink = BrowseProjects.this.userFormats.formatter("profileLink").formatUserkey(this.lead, "");
            } else {
                this.lead = null;
                this.leadProfileLink = null;
            }
            this.url = url;
            this.projectCategoryId = projectCategory != null ? projectCategory.getId() : null;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public Long getId() {
            return this.id;
        }

        public boolean isHasDefaultAvatar() {
            return this.hasDefaultAvatar;
        }

        public boolean isRecent() {
            return this.recent;
        }

        @Nullable
        public String getLead() {
            return this.lead;
        }

        public String getUrl() {
            return this.url;
        }

        @Nullable
        public String getLeadProfileLink() {
            return this.leadProfileLink;
        }

        @Nullable
        public Long getProjectCategoryId() {
            return this.projectCategoryId;
        }

        public String getProjectTypeKey() {
            return this.projectTypeKey;
        }

        public String getProjectTypeName() {
            return this.projectTypeName;
        }
    }
}

