/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowMigrationResultForMultipleProjects
implements WorkflowMigrationResult {
    private final List<WorkflowMigrationResult> results;

    public WorkflowMigrationResultForMultipleProjects(List<WorkflowMigrationResult> results) {
        this.results = results;
    }

    @Override
    public int getResult() {
        for (WorkflowMigrationResult result : this.results) {
            if (result.getResult() == 0) continue;
            return result.getResult();
        }
        return 0;
    }

    @Override
    public ErrorCollection getErrorCollection() {
        SimpleErrorCollection allErrors = new SimpleErrorCollection();
        for (WorkflowMigrationResult result : this.results) {
            ErrorCollection projectErrors = result.getErrorCollection();
            if (projectErrors == null || !projectErrors.hasAnyErrors()) continue;
            allErrors.addErrorCollection(projectErrors);
        }
        return allErrors;
    }

    @Override
    public int getNumberOfFailedIssues() {
        int totalNumber = 0;
        for (WorkflowMigrationResult result : this.results) {
            totalNumber += result.getNumberOfFailedIssues();
        }
        return totalNumber;
    }

    @Override
    public Map<Long, String> getFailedIssues() {
        HashMap allFailedIssues = Maps.newHashMap();
        for (WorkflowMigrationResult result : this.results) {
            Map<Long, String> projectFailedIssues = result.getFailedIssues();
            if (projectFailedIssues == null) continue;
            allFailedIssues.putAll(projectFailedIssues);
        }
        return allFailedIssues;
    }
}

