/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.runtime.GroupNotFoundException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.CreateUserApplicationHelper;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.event.web.action.admin.UserAddedEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserDetails;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
public class AddUser
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger(AddUser.class);
    private final UserService userService;
    private final UserManager userManager;
    private final WebInterfaceManager webInterfaceManager;
    private final EventPublisher eventPublisher;
    private final CreateUserApplicationHelper applicationHelper;
    private final ApplicationRoleManager roleManager;
    private String username;
    private String password;
    private String confirm;
    private String fullname;
    private String email;
    private Long directoryId;
    private boolean sendEmail = false;
    private UserService.CreateUserValidationResult result;
    private List<WebErrorMessage> passwordErrors = ImmutableList.of();
    private String[] selectedApplications;
    private String[] disabledApplications;

    public AddUser(UserService userService, UserManager userManager, WebInterfaceManager webInterfaceManager, EventPublisher eventPublisher, CreateUserApplicationHelper applicationHelper, ApplicationRoleManager roleManager) {
        this.userService = userService;
        this.userManager = userManager;
        this.webInterfaceManager = webInterfaceManager;
        this.eventPublisher = eventPublisher;
        this.applicationHelper = applicationHelper;
        this.roleManager = roleManager;
    }

    public String doDefault() {
        if (this.selectedApplications == null) {
            this.selectedApplications = (String[])this.roleManager.getDefaultApplicationKeys().stream().map(ApplicationKey::toString).toArray(String[]::new);
        }
        return "input";
    }

    protected void doValidation() {
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)this.getLoggedInUser(), (String)this.getUsername(), (String)this.getPassword(), (String)this.getEmail(), (String)this.getFullname()).inDirectory(this.getDirectoryId()).withApplicationAccess(this.getSelectedApplicationKeys()).sendNotification(this.sendEmail);
        this.result = this.userService.validateCreateUser(createUserRequest);
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
        this.validateConfirmPassword(this.getPassword(), this.getConfirm());
        this.passwordErrors = this.result.getPasswordErrors();
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        try {
            this.userService.createUser(this.result);
            this.eventPublisher.publish((Object)new UserAddedEvent(this.request.getParameterMap()));
        }
        catch (PermissionException e) {
            this.addError("username", this.getText("admin.errors.user.no.permission.to.create"));
        }
        catch (CreateException e) {
            this.addError("username", this.getText("admin.errors.user.cannot.create", e.getMessage()));
        }
        catch (GroupNotFoundException e) {
            String directoryName = this.userManager.getDirectory(this.getDirectoryId()).getName();
            log.warn("Error occurred while adding user to group, the directory {} may be out of sync.", (Object)directoryName, (Object)e);
            String warningMessage = StringEscapeUtils.escapeHtml4((String)this.getText("admin.warn.user.create.no.group", this.getUsername(), e.getMessage(), directoryName));
            return this.returnCompleteWithInlineRedirectAndMsg(this.viewUserUrl(), warningMessage, JiraWebActionSupport.MessageType.WARNING, true, null);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.returnCompleteWithInlineRedirect(this.viewUserUrl());
    }

    private String viewUserUrl() {
        return "ViewUser.jspa?name=" + JiraUrlCodec.encode((String)this.username.toLowerCase());
    }

    private void validateConfirmPassword(String password, String confirmPassword) {
        if (!(!StringUtils.isNotEmpty((String)confirmPassword) && !StringUtils.isNotEmpty((String)password) || password != null && password.equals(confirmPassword))) {
            this.addError("confirm", this.getI18nHelper().getText("signup.error.password.mustmatch"));
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim((String)username);
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = StringUtils.trim((String)email);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtils.isEmpty((String)password) ? null : password;
    }

    public List<WebErrorMessage> getPasswordErrors() {
        return this.passwordErrors;
    }

    public boolean hasPasswordWritableDirectory() {
        return this.userManager.hasPasswordWritableDirectory();
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = StringUtils.isEmpty((String)confirm) ? null : confirm;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(Long directoryId) {
        this.directoryId = directoryId;
    }

    public List<Directory> getDirectories() {
        return this.userManager.getWritableDirectories();
    }

    public Map<Long, Boolean> getCanDirectoryUpdatePasswordMap() {
        List<Directory> directories = this.getDirectories();
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(directories.size());
        for (Directory directory : directories) {
            result.put(directory.getId(), this.userManager.canDirectoryUpdateUserPassword(directory));
        }
        return result;
    }

    public String getUserCountWebPanelHtml() {
        return this.getPanels("webpanels.admin.adduser.count");
    }

    public String getWebPanelHtml() {
        return this.getPanels("webpanels.admin.adduser");
    }

    private String getPanels(String panelLocation) {
        StringBuilder builder = new StringBuilder();
        List panels = this.webInterfaceManager.getDisplayableWebPanelDescriptors(panelLocation, Collections.emptyMap());
        for (final WebPanelModuleDescriptor panel : panels) {
            Option fragment = SafePluginPointAccess.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (panel == null || panel.getModule() == null) {
                        return null;
                    }
                    return ((WebPanel)panel.getModule()).getHtml(Collections.emptyMap());
                }
            });
            if (!fragment.isDefined()) continue;
            builder.append((String)fragment.get());
        }
        return builder.toString();
    }

    public String[] getSelectedApplications() {
        return this.selectedApplications;
    }

    public void setSelectedApplications(String[] selectedApplications) {
        this.selectedApplications = selectedApplications;
    }

    public String[] getDisabledApplications() {
        return this.disabledApplications;
    }

    public void setDisabledApplications(String[] disabledApplications) {
        this.disabledApplications = disabledApplications;
    }

    @Nonnull
    public Set<ApplicationKey> getSelectedApplicationKeys() {
        HashSet applicationKeys = Sets.newHashSet();
        if (this.selectedApplications != null) {
            for (String selectedApplication : this.selectedApplications) {
                applicationKeys.add(ApplicationKey.valueOf((String)selectedApplication));
            }
        }
        return ImmutableSet.copyOf((Collection)applicationKeys);
    }

    public boolean hasOnlyOneApplication() {
        return this.applicationHelper.isSingleApplicationInstance();
    }

    @Nonnull
    public Collection<CreateUserApplicationHelper.ApplicationSelection> getSelectableApplications() {
        Set<ApplicationKey> selectedKeys = this.getApplicationKeyObjects(this.selectedApplications);
        Set<ApplicationKey> disabledKeys = this.getApplicationKeyObjects(this.disabledApplications);
        ImmutableSet applicationKeys = ImmutableSet.builder().addAll(selectedKeys).addAll(disabledKeys).build();
        return this.applicationHelper.getApplicationsForSelection((Set<ApplicationKey>)applicationKeys);
    }

    private Set<ApplicationKey> getApplicationKeyObjects(String[] applicationKeys) {
        if (applicationKeys == null) {
            return ImmutableSet.of();
        }
        return (Set)Arrays.stream(applicationKeys).map(ApplicationKey::valueOf).collect(CollectorsUtil.toImmutableSet());
    }

    private UserDetails toApplicationUserCreationData() {
        return new UserDetails(this.getUsername(), this.getFullname()).withDirectory(this.getDirectoryId()).withPassword(this.getPassword()).withEmail(this.getEmail());
    }
}

