/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.roles.AbstractRoleActorAction;
import com.atlassian.jira.web.component.multiuserpicker.UserPickerLayoutBean;
import com.atlassian.jira.web.component.multiuserpicker.UserPickerWebComponent;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import webwork.action.ActionContext;

public class UserRoleActorAction
extends AbstractRoleActorAction {
    private static final String REMOVE_USERS_PREFIX = "removeusers_";
    private String userNames;
    private final ProjectRoleService projectRoleService;
    private final VelocityTemplatingEngine templatingEngine;
    private final UserSearchService searchService;

    public UserRoleActorAction(ProjectRoleService projectRoleService, ProjectManager projectManager, ProjectFactory projectFactory, RoleActorFactory roleActorFactory, VelocityTemplatingEngine templatingEngine, UserSearchService searchService) {
        super(projectRoleService, projectManager, projectFactory, roleActorFactory);
        this.projectRoleService = projectRoleService;
        this.templatingEngine = templatingEngine;
        this.searchService = searchService;
    }

    protected String doExecute() {
        if (!this.projectRoleService.hasProjectRolePermission(this.getProject())) {
            return "securitybreach";
        }
        return "success";
    }

    public String getUserPickerHtml() {
        String removeUsersAction = "UserRoleActorAction!removeUsers.jspa?projectRoleId=" + this.getProjectRoleId() + (this.getProject() != null ? "&projectId=" + this.getProjectId() : "");
        String addUserAction = "UserRoleActorAction!addUsers.jspa?projectRoleId=" + this.getProjectRoleId() + (this.getProject() != null ? "&projectId=" + this.getProjectId() : "");
        UserPickerLayoutBean userPickerLayoutBean = new UserPickerLayoutBean("admin.user.role.actor.action", REMOVE_USERS_PREFIX, removeUsersAction, addUserAction);
        UserPickerWebComponent userPickerWebComponent = new UserPickerWebComponent(this.templatingEngine, this.getApplicationProperties(), this.searchService);
        return userPickerWebComponent.getHtml(userPickerLayoutBean, this.getProjectRoleActorUsers(), true, this.getProjectRoleId());
    }

    private Collection<ApplicationUser> getProjectRoleActorUsers() {
        Object defaultRoleActors = this.getProject() == null ? this.projectRoleService.getDefaultRoleActors(this.getProjectRole(), (ErrorCollection)this) : this.projectRoleService.getProjectRoleActors(this.getProjectRole(), this.getProject(), (ErrorCollection)this);
        TreeSet<ApplicationUser> usersByType = new TreeSet<ApplicationUser>((Comparator<ApplicationUser>)new UserCachingComparator(this.getLocale()));
        if (defaultRoleActors != null) {
            for (RoleActor roleActor : defaultRoleActors.getRoleActorsByType("atlassian-user-role-actor")) {
                ProjectRoleActor projectRoleActor = (ProjectRoleActor)roleActor;
                usersByType.add(this.getUserManager().getUserByKey(projectRoleActor.getParameter()));
            }
        }
        return usersByType;
    }

    @RequiresXsrfCheck
    public String doRemoveUsers() {
        Collection<String> userNamesToRemove = UserPickerWebComponent.getUserNamesToRemove(ActionContext.getParameters(), REMOVE_USERS_PREFIX);
        HashSet<String> userKeysToRemove = new HashSet<String>();
        for (String nameToAdd : userNamesToRemove) {
            ApplicationUser userToAdd = this.getUserManager().getUserByName(nameToAdd);
            if (userToAdd == null) continue;
            userKeysToRemove.add(userToAdd.getKey());
        }
        if (this.getProject() == null) {
            this.projectRoleService.removeDefaultActorsFromProjectRole(userKeysToRemove, this.getProjectRole(), "atlassian-user-role-actor", (ErrorCollection)this);
        } else {
            this.projectRoleService.removeActorsFromProjectRole(userKeysToRemove, this.getProjectRole(), this.getProject(), "atlassian-user-role-actor", (ErrorCollection)this);
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "success";
    }

    @RequiresXsrfCheck
    public String doAddUsers() {
        Collection<String> userNamesToAdd = UserPickerWebComponent.getUserNamesToAdd(this.getUserNames());
        HashSet<String> userKeysToAdd = new HashSet<String>();
        for (String nameToAdd : userNamesToAdd) {
            ApplicationUser userToAdd = this.getUserManager().getUserByName(nameToAdd);
            if (userToAdd != null) {
                userKeysToAdd.add(userToAdd.getKey());
                continue;
            }
            this.getErrorMessages().add(this.getText("admin.user.role.actor.action.error.invalid", nameToAdd));
        }
        if (this.getProject() == null) {
            this.projectRoleService.addDefaultActorsToProjectRole(userKeysToAdd, this.getProjectRole(), "atlassian-user-role-actor", (ErrorCollection)this);
        } else {
            this.projectRoleService.addActorsToProjectRole(userKeysToAdd, this.getProjectRole(), this.getProject(), "atlassian-user-role-actor", (ErrorCollection)this);
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "success";
    }

    public String getUserNames() {
        return this.userNames;
    }

    public void setUserNames(String userNames) {
        this.userNames = userNames;
    }
}

