/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.resolutions;

import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.web.action.admin.constants.AbstractViewConstants;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class ViewResolutions
extends AbstractViewConstants<Resolution> {
    private final ResolutionManager resolutionManager;

    public ViewResolutions(TranslationManager translationManager, ResolutionManager resolutionManager) {
        super(translationManager);
        this.resolutionManager = resolutionManager;
    }

    @Override
    protected String getConstantEntityName() {
        return "Resolution";
    }

    @Override
    protected String getNiceConstantName() {
        return "resolution";
    }

    @Override
    protected String getIssueConstantField() {
        return this.getText("admin.issue.constant.resolution.lowercase");
    }

    @Override
    protected Resolution getConstant(String id) {
        return this.getConstantsManager().getResolutionObject(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewResolutions.jspa";
    }

    @Override
    protected Collection<Resolution> getConstants() {
        return this.getConstantsManager().getResolutionObjects();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshResolutions();
    }

    @Override
    protected String redirectToView() {
        return this.getRedirect("ViewResolutions.jspa");
    }

    @Override
    protected String getDefaultPropertyName() {
        return "jira.constant.default.resolution";
    }

    @Override
    protected void addConstant() throws GenericEntityException {
        this.resolutionManager.createResolution(this.name, this.description);
    }

    public String doMakeDefault() throws Exception {
        this.resolutionManager.setDefaultResolution(this.make);
        return "success";
    }

    public String doMoveDown() {
        this.resolutionManager.moveResolutionDown(this.down);
        return this.getResult();
    }

    public String doMoveUp() {
        this.resolutionManager.moveResolutionUp(this.up);
        return this.getResult();
    }
}

