/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.action.admin.index.AbstractAsyncIndexerCommand;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.google.common.annotations.VisibleForTesting;
import org.apache.log4j.Logger;

@Internal
@VisibleForTesting
public class ReIndexBackgroundIndexerCommand
extends AbstractAsyncIndexerCommand {
    private final IssueIndexingParams issueIndexingParams;

    public ReIndexBackgroundIndexerCommand(IndexLifecycleManager indexManager, Logger log, I18nHelper i18nHelper, I18nHelper.BeanFactory i18nBeanFactory) {
        super(null, indexManager, log, i18nHelper, i18nBeanFactory);
        this.issueIndexingParams = IssueIndexingParams.INDEX_ISSUE_ONLY;
    }

    public ReIndexBackgroundIndexerCommand(IndexLifecycleManager indexManager, IssueIndexingParams issueIndexingParams, Logger log, I18nHelper i18nHelper, I18nHelper.BeanFactory i18nBeanFactory) {
        super(null, indexManager, log, i18nHelper, i18nBeanFactory);
        this.issueIndexingParams = issueIndexingParams;
    }

    @Override
    public IndexCommandResult doReindex(Context context, IndexLifecycleManager indexManager) {
        long reindexTime = indexManager.reIndexIssuesInBackground(context, this.issueIndexingParams);
        return new IndexCommandResult(reindexTime);
    }
}

