/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Iterator;

@WebSudoRequired
public class ViewLicense
extends JiraWebActionSupport {
    private static final String MANAGE_APPLICATIONS = "/plugins/servlet/applications/manage";
    private final LicenseCountService licenseCountService;
    private final LicenseJohnsonEventRaiser licenseJohnsonEventRaiser;
    private final JiraLicenseUpdaterService jiraLicenseService;
    private final ApplicationRoleManager applicationRoleManager;
    private final UserManager userManager;
    private final JohnsonProvider johnsonProvider;
    private String licenseString = "";
    private JiraLicenseService.ValidationResult validationResult;

    public ViewLicense(LicenseCountService licenseCountService, JiraLicenseUpdaterService jiraLicenseService, LicenseJohnsonEventRaiser licenseJohnsonEventRaiser, ApplicationRoleManager applicationRoleManager, UserManager userManager, JohnsonProvider johnsonProvider) {
        this.johnsonProvider = johnsonProvider;
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
        this.licenseJohnsonEventRaiser = (LicenseJohnsonEventRaiser)Assertions.notNull((String)"licenseJohnsonEventRaiser", (Object)licenseJohnsonEventRaiser);
        this.jiraLicenseService = (JiraLicenseUpdaterService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.licenseCountService = (LicenseCountService)Assertions.notNull((String)"licenseCountService", (Object)licenseCountService);
    }

    public Iterator<LicenseDetails> getAllLicenseDetails() {
        return this.jiraLicenseService.getLicenses().iterator();
    }

    public boolean isLicenseSet() {
        return this.jiraLicenseService.isLicenseSet();
    }

    public String doRefreshActiveUserCount() {
        if (this.applicationRoleManager.rolesEnabled()) {
            return this.getRedirect(MANAGE_APPLICATIONS);
        }
        this.licenseCountService.flush();
        this.licenseCountService.totalBillableUsers();
        return "success";
    }

    protected void doValidation() {
        this.validationResult = this.jiraLicenseService.validate((I18nHelper)this, this.licenseString);
        if (this.validationResult.getErrorCollection().hasAnyErrors()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    public String doDefault() {
        if (this.applicationRoleManager.rolesEnabled()) {
            return this.getRedirect(MANAGE_APPLICATIONS);
        }
        return "input";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.applicationRoleManager.rolesEnabled()) {
            return this.getRedirect(MANAGE_APPLICATIONS);
        }
        this.jiraLicenseService.setLicense(this.validationResult);
        this.licenseString = "";
        if (this.licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild()) {
            return this.getRedirect(this.johnsonProvider.getConfig().getErrorPath());
        }
        return "success";
    }

    public String getLicense() {
        return this.licenseString;
    }

    public void setLicense(String license) {
        this.licenseString = license;
    }

    @Deprecated
    public boolean isPersonalLicense() {
        Iterator it = this.jiraLicenseService.getLicenses().iterator();
        return it.hasNext() ? ((LicenseDetails)it.next()).isPersonalLicense() : false;
    }

    public boolean isLicenseRequiresUserLimit(LicenseDetails licenseDetails) {
        return !licenseDetails.isUnlimitedNumberOfUsers();
    }

    public int getActiveUserCount() {
        return this.licenseCountService.totalBillableUsers();
    }

    public boolean hasExceededUserLimit() {
        return this.applicationRoleManager.isAnyRoleLimitExceeded();
    }

    public String getLicenseStatusMessage(LicenseDetails licenseDetails) {
        return licenseDetails.getLicenseStatusMessage(this.getLoggedInUser(), "<br/><br/>", this.userManager);
    }

    public String getLicenseExpiryStatusMessage(LicenseDetails licenseDetails) {
        return licenseDetails.getLicenseExpiryStatusMessage(this.getLoggedInUser());
    }

    public String getPurchaseDate(LicenseDetails licenseDetails) {
        return licenseDetails.getPurchaseDate(this.getOutlookDate());
    }
}

